/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.events;

import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.StateListener;
import java.util.function.IntSupplier;

public enum ChartBits implements IntSupplier
{
    AxisLayout,
    AxisCanvas,
    AxisRange,
    AxisTickLabelText,
    AxisLabelText,
    AxisDescriptionRange,
    AxisDescriptionName,
    ChartLayout,
    ChartCanvas,
    ChartAxes,
    ChartRenderers,
    ChartDataSets,
    ChartLegend,
    ChartPlugins,
    ChartPluginState,
    DataSetDataAdded,
    DataSetDataRemoved,
    DataSetRange,
    DataSetName,
    DataSetStyle,
    DataSetMetaData,
    DataSetPermutation,
    DataViewWindow,
    DataSetMeasurement;

    private static final ChartBits[] AllBits;
    public static final int KnownMask;
    public static final int AxisMask;
    public static final IntSupplier DataSetData;
    public static final int DataSetMask;
    private static final StateListener PRINTER;
    private static final StateListener STACK_TRACE_PRINTER;
    final int bit = 1 << this.ordinal();

    public static StateListener printer() {
        return PRINTER;
    }

    public static StateListener printerWithStackTrace() {
        return STACK_TRACE_PRINTER;
    }

    @Override
    public int getAsInt() {
        return this.bit;
    }

    public boolean isSet(int n2) {
        return BitState.isSet(n2, this.bit);
    }

    static {
        AllBits = ChartBits.values();
        KnownMask = BitState.mask(AllBits);
        AxisMask = BitState.mask(AxisLayout, AxisCanvas, AxisRange, AxisTickLabelText, AxisLabelText);
        DataSetData = BitState.maskSupplier(DataSetDataAdded, DataSetDataRemoved);
        DataSetMask = BitState.mask(DataSetData, ChartDataSets, DataSetStyle, DataSetRange, DataSetMetaData, DataSetPermutation, ChartCanvas);
        PRINTER = BitState.createDebugPrinter(AllBits);
        STACK_TRACE_PRINTER = BitState.createDebugPrinterWithStackTrace(AllBits);
        if (AllBits.length > 32) {
            throw new AssertionError((Object)"The int32 based event system can only support 32 different types");
        }
    }
}

