/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.events;

import io.fair_acc.dataset.events.StateListener;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.IntSupplier;

public abstract class BitState
implements StateListener {
    private static final int DEFAULT_MIN_STACK_TRACE = 6;
    private static final int DEFAULT_MAX_STACK_TRACE = 25;
    final Object source;
    final int filter;
    public static final int ALL_BITS = -1;
    List<StateListener> changeListeners;
    List<StateListener> invalidateListeners = null;

    public Runnable onAction(IntSupplier intSupplier, IntSupplier ... intSupplierArray) {
        return this.onAction(BitState.mask(intSupplier, intSupplierArray));
    }

    public Runnable onAction(int n2) {
        return () -> this.setDirty(n2);
    }

    public StateListener.OnChangeSetter onPropChange(IntSupplier intSupplier, IntSupplier ... intSupplierArray) {
        return this.onPropChange(BitState.mask(intSupplier, intSupplierArray));
    }

    public StateListener.OnChangeSetter onPropChange(int n2) {
        return (object, object2, object3) -> this.setDirty(n2);
    }

    public StateListener.OnInvalidateSetter onPropInvalidate(IntSupplier intSupplier, IntSupplier ... intSupplierArray) {
        return this.onPropInvalidate(BitState.mask(intSupplier, intSupplierArray));
    }

    public StateListener.OnInvalidateSetter onPropInvalidate(int n2) {
        return object -> this.setDirty(n2);
    }

    public static int mask(IntSupplier[] intSupplierArray) {
        int n2 = 0;
        for (IntSupplier intSupplier : intSupplierArray) {
            n2 |= intSupplier.getAsInt();
        }
        return n2;
    }

    public static IntSupplier maskSupplier(IntSupplier intSupplier, IntSupplier ... intSupplierArray) {
        int n2 = BitState.mask(intSupplier, intSupplierArray);
        return () -> n2;
    }

    public static int mask(IntSupplier intSupplier, IntSupplier ... intSupplierArray) {
        int n2 = intSupplier.getAsInt();
        for (IntSupplier intSupplier2 : intSupplierArray) {
            n2 |= intSupplier2.getAsInt();
        }
        return n2;
    }

    @Override
    public void accept(BitState bitState, int n2) {
        this.setDirty(n2);
    }

    public void setDirty(IntSupplier intSupplier, IntSupplier ... intSupplierArray) {
        this.setDirty(BitState.mask(intSupplier, intSupplierArray));
    }

    public boolean isDirty() {
        return this.getBits() != 0;
    }

    public boolean isDirty(int n2) {
        return (this.getBits() & n2) != 0;
    }

    public boolean isDirty(IntSupplier intSupplier) {
        return this.isDirty(intSupplier.getAsInt());
    }

    public boolean isDirty(IntSupplier intSupplier, IntSupplier intSupplier2) {
        return this.isDirty(intSupplier.getAsInt() | intSupplier2.getAsInt());
    }

    public boolean isDirty(IntSupplier intSupplier, IntSupplier intSupplier2, IntSupplier ... intSupplierArray) {
        return this.isDirty(intSupplier.getAsInt() | intSupplier2.getAsInt() | BitState.mask(intSupplierArray));
    }

    public boolean isClean() {
        return this.getBits() == 0;
    }

    public boolean isClean(int n2) {
        return (this.getBits() & n2) == 0;
    }

    public boolean isClean(IntSupplier intSupplier) {
        return this.isClean(intSupplier.getAsInt());
    }

    public boolean isClean(IntSupplier intSupplier, IntSupplier intSupplier2) {
        return this.isClean(intSupplier.getAsInt() | intSupplier2.getAsInt());
    }

    public boolean isClean(IntSupplier intSupplier, IntSupplier intSupplier2, IntSupplier ... intSupplierArray) {
        return this.isClean(intSupplier.getAsInt() | intSupplier2.getAsInt() | BitState.mask(intSupplierArray));
    }

    public void getBits(StateListener stateListener) {
        stateListener.accept(this, this.getBits());
    }

    public abstract int getBits();

    public void setDirty(int n2) {
        int n3 = n2 & this.filter;
        int n4 = this.setDirtyAndGetDelta(n3);
        if (n4 != 0) {
            this.notifyListeners(this.changeListeners, n4);
        }
        this.notifyListeners(this.invalidateListeners, n2);
    }

    protected abstract int setDirtyAndGetDelta(int var1);

    public int clear() {
        return this.clear(-1);
    }

    public abstract int clear(int var1);

    public int clear(IntSupplier intSupplier) {
        return this.clear(intSupplier.getAsInt());
    }

    public int clear(IntSupplier intSupplier, IntSupplier intSupplier2) {
        return this.clear(intSupplier.getAsInt() | intSupplier2.getAsInt());
    }

    public int clear(IntSupplier intSupplier, IntSupplier intSupplier2, IntSupplier ... intSupplierArray) {
        return this.clear(intSupplier.getAsInt() | intSupplier2.getAsInt() | BitState.mask(intSupplierArray));
    }

    public BitState addChangeListener(IntSupplier intSupplier, StateListener stateListener) {
        return this.addChangeListener(intSupplier.getAsInt(), stateListener);
    }

    public BitState addChangeListener(int n2, StateListener stateListener) {
        return this.addChangeListener(new FilteredListener(n2, stateListener));
    }

    public BitState addInvalidateListener(IntSupplier intSupplier, StateListener stateListener) {
        return this.addInvalidateListener(intSupplier.getAsInt(), stateListener);
    }

    public BitState addInvalidateListener(int n2, StateListener stateListener) {
        return this.addInvalidateListener(new FilteredListener(n2, stateListener));
    }

    public BitState addChangeListener(StateListener stateListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new CopyOnWriteArrayList<StateListener>();
        }
        this.changeListeners.add(stateListener);
        return this;
    }

    public BitState addInvalidateListener(StateListener stateListener) {
        if (this.invalidateListeners == null) {
            this.invalidateListeners = new CopyOnWriteArrayList<StateListener>();
        }
        this.invalidateListeners.add(stateListener);
        return this;
    }

    public boolean removeChangeListener(StateListener stateListener) {
        return BitState.removeListener(this.changeListeners, stateListener);
    }

    public boolean removeInvalidateListener(StateListener stateListener) {
        return BitState.removeListener(this.invalidateListeners, stateListener);
    }

    private static boolean removeListener(List<StateListener> list, StateListener stateListener) {
        if (list == null) {
            return false;
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            if (!BitState.isEqual(list.get(i2), stateListener)) continue;
            list.remove(i2);
            return true;
        }
        return false;
    }

    private void notifyListeners(List<StateListener> list, int n2) {
        if (list != null) {
            for (StateListener stateListener : list) {
                stateListener.accept(this, n2);
            }
        }
    }

    private static boolean isEqual(StateListener stateListener, StateListener stateListener2) {
        if (stateListener == stateListener2) {
            return true;
        }
        if (stateListener instanceof FilteredListener) {
            return ((FilteredListener)stateListener).listener == stateListener2;
        }
        return false;
    }

    public static boolean isSet(int n2, int n3) {
        return (n3 & n2) != 0;
    }

    public static int clear(int n2, int n3) {
        return n2 & ~n3;
    }

    public static StateListener createDebugPrinter(IntSupplier ... intSupplierArray) {
        return BitState.createDebugPrinter(System.out::println, intSupplierArray);
    }

    public static StateListener createDebugPrinterWithStackTrace(IntSupplier ... intSupplierArray) {
        return BitState.createDebugPrinterWithStackTrace(System.out::println, intSupplierArray);
    }

    public static StateListener createDebugPrinter(Consumer<String> consumer, IntSupplier ... intSupplierArray) {
        return BitState.createDebugPrinter(false, 0, 0, consumer, intSupplierArray);
    }

    public static StateListener createDebugPrinterWithStackTrace(int n2, IntSupplier ... intSupplierArray) {
        return BitState.createDebugPrinter(true, 6, n2, System.out::println, intSupplierArray);
    }

    public static StateListener createDebugPrinterWithStackTrace(Consumer<String> consumer, IntSupplier ... intSupplierArray) {
        return BitState.createDebugPrinter(true, 6, 25, consumer, intSupplierArray);
    }

    public static StateListener createDebugPrinter(boolean bl2, int n2, int n3, Consumer<String> consumer, IntSupplier ... intSupplierArray) {
        StringBuilder stringBuilder = new StringBuilder();
        return (bitState, n4) -> {
            stringBuilder.setLength(0);
            stringBuilder.append(bitState.getSource()).append(": ");
            BitState.appendBitStrings(stringBuilder, n4, intSupplierArray);
            if (bl2) {
                BitState.appendStackTrace(stringBuilder, n2, n3);
            }
            consumer.accept(stringBuilder.toString());
        };
    }

    public String getAsString(IntSupplier ... intSupplierArray) {
        return BitState.appendBitStrings(new StringBuilder(), this.getBits(), intSupplierArray).toString();
    }

    public static StringBuilder appendBitStrings(StringBuilder stringBuilder, int n2, IntSupplier ... intSupplierArray) {
        if (n2 == 0) {
            return stringBuilder.append("clean");
        }
        int n3 = 0;
        stringBuilder.append("dirty[");
        for (IntSupplier intSupplier : intSupplierArray) {
            int n4 = intSupplier.getAsInt();
            if (!BitState.isSet(n2, n4)) continue;
            stringBuilder.append(intSupplier).append(", ");
            n3 |= n4;
        }
        if (BitState.clear(n2, n3) != 0) {
            stringBuilder.append("UNKNOWN, ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.append("]");
    }

    public static StringBuilder appendStackTrace(StringBuilder stringBuilder, int n2, int n3) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = n2; i2 < Math.min(stackTraceElementArray.length, n3); ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append("\n   [").append(i2).append("] ").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")");
        }
        return stringBuilder;
    }

    public Object getSource() {
        return this.source;
    }

    public static BitState initClean(Object object) {
        return BitState.initClean(object, -1);
    }

    public static BitState initDirty(Object object) {
        return BitState.initDirty(object, -1);
    }

    public static BitState initClean(Object object, int n2) {
        return new SingleThreadedBitState(object, n2, 0);
    }

    public static BitState initDirty(Object object, int n2) {
        return new SingleThreadedBitState(object, n2, n2);
    }

    public static BitState initCleanMultiThreaded(Object object, int n2) {
        return new MultiThreadedBitState(object, n2, 0);
    }

    public static BitState initDirtyMultiThreaded(Object object, int n2) {
        return new MultiThreadedBitState(object, n2, n2);
    }

    protected BitState(Object object, int n2) {
        this.source = object;
        this.filter = n2;
    }

    @Deprecated
    public List<StateListener> getChangeListeners() {
        return this.changeListeners == null ? Collections.emptyList() : this.changeListeners;
    }

    @Deprecated
    public List<StateListener> getInvalidationListeners() {
        return this.invalidateListeners == null ? Collections.emptyList() : this.invalidateListeners;
    }

    public String toString() {
        return "bits(" + String.valueOf(this.source) + ")";
    }

    private static class FilteredListener
    implements StateListener {
        final int filter;
        final StateListener listener;

        private FilteredListener(int n2, StateListener stateListener) {
            this.filter = n2;
            this.listener = stateListener;
        }

        @Override
        public void accept(BitState bitState, int n2) {
            int n3 = this.filter & n2;
            if (n3 != 0) {
                this.listener.accept(bitState, n3);
            }
        }
    }

    protected static class SingleThreadedBitState
    extends BitState {
        int state;

        protected SingleThreadedBitState(Object object, int n2, int n3) {
            super(object, n2);
            this.state = n3;
        }

        @Override
        protected int setDirtyAndGetDelta(int n2) {
            int n3 = (this.state ^ n2) & n2;
            this.state |= n2;
            return n3;
        }

        @Override
        public int clear(int n2) {
            int n3 = this.state;
            this.state &= ~n2;
            return n3;
        }

        @Override
        public int getBits() {
            return this.state;
        }
    }

    protected static class MultiThreadedBitState
    extends BitState {
        private final AtomicInteger state = new AtomicInteger();

        protected MultiThreadedBitState(Object object, int n2, int n3) {
            super(object, n2);
            this.state.set(n3);
        }

        @Override
        public int setDirtyAndGetDelta(int n2) {
            int n3;
            int n4;
            int n5;
            do {
                n5 = this.getBits();
                n4 = n5 | n2;
                n3 = n5 ^ n4;
            } while (n5 != n4 && !this.state.compareAndSet(n5, n4));
            return n3;
        }

        @Override
        public int clear(int n2) {
            int n3;
            int n4;
            while ((n4 = this.getBits()) != (n3 = n4 & ~n2) && !this.state.compareAndSet(n4, n3)) {
            }
            return n4;
        }

        @Override
        public int getBits() {
            return this.state.get();
        }
    }
}

