/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.viewer;

import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Region;

public class SquareButton
extends Button {
    static final int MAX_BUTTON_SIZE = 30;

    public SquareButton(String string) {
        this.getStyleClass().setAll((Object[])new String[]{string});
        this.setPadding(Insets.EMPTY);
        this.updateListener();
    }

    public SquareButton(String string, Node node) {
        super(string, node);
        this.setPadding(Insets.EMPTY);
        this.updateListener();
    }

    private void adjustDimension() {
        if (!(this.getParent() instanceof Region)) {
            return;
        }
        Region region = (Region)this.getParent();
        double d2 = region.getInsets().getTop() + region.getInsets().getBottom();
        double d3 = this.getPadding().getTop() + this.getPadding().getBottom();
        double d4 = region.getHeight() < 1.0 ? 30.0 + d3 : this.adjustForScaling(region.getHeight() - d2);
        this.setPrefSize(d4, d4);
        this.setMaxSize(30.0, 30.0);
    }

    private double adjustForScaling(double d2) {
        if (this.isSnapToPixel()) {
            double d3 = this.getScaleY();
            return Math.floor(d2 * d3) / d3;
        }
        return d2;
    }

    private void updateListener() {
        ChangeListener changeListener = (observableValue, number, number2) -> this.adjustDimension();
        this.widthProperty().addListener(changeListener);
        this.heightProperty().addListener(changeListener);
        this.parentProperty().addListener((observableValue, parent, parent2) -> {
            Region region;
            if (parent != null) {
                if (!(parent instanceof Region)) {
                    return;
                }
                region = (Region)parent;
                region.heightProperty().removeListener(changeListener);
            }
            if (parent2 != null) {
                if (!(parent2 instanceof Region)) {
                    return;
                }
                region = (Region)parent2;
                region.heightProperty().addListener(changeListener);
                this.adjustDimension();
            }
        });
        this.adjustDimension();
    }
}

