/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.viewer;

import io.fair_acc.chartfx.ui.TilingPane;
import io.fair_acc.chartfx.viewer.DataView;
import io.fair_acc.chartfx.viewer.DataViewWindow;
import io.fair_acc.chartfx.viewer.SquareButton;
import io.fair_acc.dataset.utils.NoDuplicatesList;
import java.util.ArrayList;
import java.util.Objects;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="views")
public class DataViewer
extends BorderPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewer.class);
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    private final ObjectProperty<DataViewWindow.WindowDecoration> windowDecoration = new SimpleObjectProperty((Object)this, "windowDecoration", (Object)DataViewWindow.WindowDecoration.BAR);
    private final BooleanProperty detachableWindow = new SimpleBooleanProperty((Object)this, "detachableWindow", true);
    private final FontIcon rootIcon = new FontIcon("fas-square-root-alt:20");
    private final DataView dataViewRoot = new DataView("root", (Node)this.rootIcon, null);
    private final HBox viewList = new HBox();
    private final Separator separator1 = new Separator(Orientation.HORIZONTAL);
    private final Separator separator2 = new Separator(Orientation.HORIZONTAL);
    private final ToolBar toolBar;
    private final ObservableList<Node> userToolBarItems = FXCollections.observableList(new NoDuplicatesList());
    private final BooleanProperty showListStyleDataViews = new SimpleBooleanProperty((Object)this, "listStyleViews", false);
    protected final BooleanProperty explorerVisible = new SimpleBooleanProperty(false){

        protected void invalidated() {
            DataViewer.this.requestLayout();
        }
    };
    protected final ListChangeListener<? super DataView> subDataViewChangeListener = change -> {
        while (change.next()) {
            DataView dataView = this.dataViewRoot.getActiveView();
            if (change.getAddedSize() <= 0 || dataView != null && dataView != this.dataViewRoot) continue;
            this.dataViewRoot.setActiveSubView((DataView)((Object)((Object)change.getAddedSubList().get(0))));
        }
    };
    protected final ChangeListener<? super DataView> activeSubDataViewChangeListener = (observableValue, dataView, dataView2) -> {
        if (dataView2 == null) {
            this.dataViewRoot.getChildren().clear();
            this.updateToolBar();
            return;
        }
        this.dataViewRoot.getChildren().setAll((Object[])new Node[]{dataView2});
        if (!this.dataViewRoot.getSubDataViews().contains((Object)dataView2)) {
            this.dataViewRoot.getSubDataViews().add((Object)dataView2);
        }
        this.updateToolBar();
    };
    protected final ChangeListener<? super Boolean> closeWindowButtonHandler = (observableValue, bl2, bl3) -> {
        switch (this.getWindowDecoration()) {
            case BAR: 
            case BAR_WO_CLOSE: {
                this.setWindowDecoration(Boolean.TRUE.equals(bl3) ? DataViewWindow.WindowDecoration.BAR : DataViewWindow.WindowDecoration.BAR_WO_CLOSE);
                break;
            }
        }
    };

    public DataViewer() {
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.dataViewRoot.getSubDataViews().addListener(this.subDataViewChangeListener);
        this.dataViewRoot.activeSubViewProperty().addListener(this.activeSubDataViewChangeListener);
        this.userToolBarItems.addListener(change -> this.updateToolBar());
        this.showListStyleDataViews.addListener((observableValue, bl2, bl3) -> this.updateToolBar());
        this.selectedViewProperty().addListener((observableValue, dataView, dataView2) -> this.updateToolBar());
        this.windowDecorationProperty().addListener((observableValue, windowDecoration, windowDecoration2) -> this.updateWindowDecorations(this.dataViewRoot));
        this.detachableWindowProperty().addListener((observableValue, bl2, bl3) -> this.updateDetachableWindowProperty(this.dataViewRoot));
        Label label = new Label();
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        this.toolBar = new ToolBar(new Node[]{this.separator1, this.viewList, this.separator2, label});
        this.setCenter((Node)this.dataViewRoot);
        this.requestLayout();
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("DataViewer.css")).toExternalForm();
    }

    public DataViewer(DataView ... dataViewArray) {
        this();
        this.getViews().addAll((Object[])dataViewArray);
    }

    public BooleanProperty detachableWindowProperty() {
        return this.detachableWindow;
    }

    public BooleanProperty explorerVisibleProperty() {
        return this.explorerVisible;
    }

    public final DataView getSelectedView() {
        return (DataView)((Object)this.selectedViewProperty().get());
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public ObservableList<Node> getUserToolBarItems() {
        return this.userToolBarItems;
    }

    public final ObservableList<DataView> getViews() {
        return this.dataViewRoot.getSubDataViews();
    }

    public DataViewWindow.WindowDecoration getWindowDecoration() {
        return (DataViewWindow.WindowDecoration)((Object)this.windowDecorationProperty().get());
    }

    public boolean isDetachableWindow() {
        return this.detachableWindowProperty().get();
    }

    public final boolean isExplorerVisible() {
        return this.explorerVisibleProperty().get();
    }

    public final ObjectProperty<DataView> selectedViewProperty() {
        return this.dataViewRoot.activeSubViewProperty();
    }

    public void setDetachableWindow(boolean bl2) {
        this.detachableWindowProperty().set(bl2);
    }

    public final void setExplorerVisible(boolean bl2) {
        this.explorerVisibleProperty().set(bl2);
    }

    public final void setSelectedView(DataView dataView) {
        this.selectedViewProperty().set((Object)dataView);
    }

    public final void setSelectedView(String string) {
        for (DataView dataView : this.getViews()) {
            if (dataView.getName() == null || !dataView.getName().equals(string)) continue;
            this.setSelectedView(dataView);
            return;
        }
    }

    public void setWindowDecoration(DataViewWindow.WindowDecoration windowDecoration) {
        this.windowDecorationProperty().set((Object)windowDecoration);
    }

    public BooleanProperty showListStyleDataViewProperty() {
        return this.showListStyleDataViews;
    }

    public void updateMenuButton(Menu menu, DataView dataView) {
        for (DataView dataView2 : dataView.getSubDataViews()) {
            MenuItem menuItem;
            String string = dataView2.getName();
            Node node = dataView2.getIcon();
            if (dataView2.getSubDataViews().isEmpty()) {
                menuItem = new MenuItem(string, node);
                menuItem.setOnAction(actionEvent -> dataView.setView(dataView2));
                menu.getItems().add((Object)menuItem);
                continue;
            }
            menuItem = new Menu(string, node);
            menuItem.setOnAction(actionEvent -> dataView.setView(dataView2));
            menu.getItems().add((Object)menuItem);
            this.updateMenuButton((Menu)menuItem, dataView2);
        }
    }

    public ObjectProperty<DataViewWindow.WindowDecoration> windowDecorationProperty() {
        return this.windowDecoration;
    }

    protected void updateDetachableWindowProperty(DataView dataView) {
        Object object2;
        for (Object object2 : dataView.getSubDataViews()) {
            this.updateDetachableWindowProperty((DataView)((Object)object2));
        }
        if (dataView.getContentPane() == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(dataView.getContentPane());
        arrayList.addAll(dataView.getChildren());
        arrayList.addAll(dataView.getContentPane().getChildren());
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            Node node = (Node)object2.next();
            if (!(node instanceof DataViewWindow)) continue;
            DataViewWindow dataViewWindow = (DataViewWindow)node;
            dataViewWindow.setDetachableWindow(this.isDetachableWindow());
        }
    }

    protected void updateToolBar() {
        Object object;
        Object object2;
        Object object3;
        this.toolBar.getItems().clear();
        this.toolBar.getItems().addAll(this.userToolBarItems);
        if (this.getSelectedView() == null) {
            return;
        }
        this.toolBar.getItems().add((Object)this.separator1);
        for (Object object4 : this.dataViewRoot.getSubDataViews()) {
            Object object5 = ((DataView)((Object)object4)).getName();
            object3 = ((DataView)((Object)object4)).getIcon();
            object2 = object3 == null && object5 == null ? new Button(null, (Node)new FontIcon("fa-question")) : (object3 == null ? new Button(object5, null) : new Button(null, (Node)object3));
            object2.setTooltip(new Tooltip("activates view '" + object5 + "'"));
            if (this.showListStyleDataViewProperty().get()) continue;
            object2.setOnAction(arg_0 -> this.lambda$updateToolBar$10((DataView)((Object)object4), arg_0));
            this.toolBar.getItems().add(object2);
        }
        if (this.showListStyleDataViewProperty().get()) {
            Object object4;
            object = new Menu(null, (Node)new FontIcon("fas-list-ul"));
            object4 = new MenuBar(new Menu[]{object});
            this.updateMenuButton((Menu)object, this.dataViewRoot);
            if (!object.getItems().isEmpty()) {
                this.toolBar.getItems().add(object4);
            }
        }
        if (this.getSelectedView().isStandalone()) {
            this.toolBar.requestLayout();
            return;
        }
        this.toolBar.getItems().add((Object)this.separator2);
        object = new SquareButton(null, (Node)new FontIcon("fa-sort-alpha-asc"));
        object.setTooltip(new Tooltip("sort children"));
        object.setOnAction(actionEvent -> this.getSelectedView().getActiveView().sort());
        this.toolBar.getItems().add(object);
        for (Object object5 : this.getSelectedView().getSubDataViews()) {
            if (!(((DataView)((Object)object5)).getContentPane() instanceof TilingPane)) continue;
            object3 = (TilingPane)((DataView)((Object)object5)).getContentPane();
            object2 = ((TilingPane)((Object)object3)).getLayout();
            SquareButton squareButton = new SquareButton(null, ((TilingPane.Layout)((Object)object2)).getIcon());
            squareButton.setTooltip(new Tooltip("configure pane for " + ((TilingPane.Layout)((Object)object2)).getName() + "-style layout"));
            squareButton.setOnAction(arg_0 -> this.lambda$updateToolBar$12((DataView)((Object)object5), arg_0));
            if (((Enum)object2).equals((Object)TilingPane.Layout.MAXIMISE)) continue;
            this.toolBar.getItems().add((Object)squareButton);
        }
        this.toolBar.requestLayout();
    }

    protected void updateWindowDecorations(DataView dataView) {
        Object object2;
        for (Object object2 : dataView.getSubDataViews()) {
            this.updateWindowDecorations((DataView)((Object)object2));
        }
        if (dataView.getContentPane() == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(dataView.getContentPane());
        arrayList.addAll(dataView.getChildren());
        arrayList.addAll(dataView.getContentPane().getChildren());
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            Node node = (Node)object2.next();
            if (!(node instanceof DataViewWindow)) continue;
            DataViewWindow dataViewWindow = (DataViewWindow)node;
            dataViewWindow.setWindowDecoration(this.getWindowDecoration());
        }
    }

    private /* synthetic */ void lambda$updateToolBar$12(DataView dataView, ActionEvent actionEvent) {
        this.getSelectedView().setView(dataView);
    }

    private /* synthetic */ void lambda$updateToolBar$10(DataView dataView, ActionEvent actionEvent) {
        this.setSelectedView(dataView);
    }
}

