/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.utils.RotatedBounds;
import java.util.function.DoubleUnaryOperator;
import javafx.scene.Node;

public class RotatedRegion {
    private final Node node;
    private final DoubleUnaryOperator computePrefWidth;
    private final DoubleUnaryOperator computePrefHeight;
    private final ResizeRelocateMethod resizeRelocate;
    private final RotatedBounds bounds = new RotatedBounds();

    public RotatedRegion(Node node, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2, ResizeRelocateMethod resizeRelocateMethod) {
        this.node = node;
        this.computePrefWidth = doubleUnaryOperator;
        this.computePrefHeight = doubleUnaryOperator2;
        this.resizeRelocate = resizeRelocateMethod;
    }

    public double computePrefWidth(double d2) {
        return this.getRotate() == 0.0 ? this.computePrefWidth.applyAsDouble(d2) : this.bounds.setSize(this.computePrefWidth.applyAsDouble(d2), this.computePrefHeight.applyAsDouble(d2)).rotateCenter(this.getRotate()).getWidth();
    }

    public double computePrefHeight(double d2) {
        return this.getRotate() == 0.0 ? this.computePrefHeight.applyAsDouble(d2) : this.bounds.setSize(this.computePrefWidth.applyAsDouble(d2), this.computePrefHeight.applyAsDouble(d2)).rotateCenter(this.getRotate()).getHeight();
    }

    public void resizeRelocate(double d2, double d3, double d4, double d5) {
        if (this.getRotate() == 0.0) {
            this.resizeRelocate.apply(d2, d3, d4, d5);
        } else {
            this.bounds.setBounds(d2, d3, d4, d5).rotateCenter(this.getRotate());
            this.resizeRelocate.apply(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        }
    }

    private double getRotate() {
        return this.node.getRotate();
    }

    @FunctionalInterface
    public static interface ResizeRelocateMethod {
        public void apply(double var1, double var3, double var5, double var7);
    }
}

