/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableValue;

public class PropUtil {
    public static boolean set(DoubleProperty doubleProperty, double d2) {
        if (PropUtil.isEqual(doubleProperty.get(), d2)) {
            return false;
        }
        doubleProperty.set(d2);
        return true;
    }

    public static boolean set(StringProperty stringProperty, String string) {
        if (Objects.equals(stringProperty.get(), string)) {
            return false;
        }
        stringProperty.set((Object)string);
        return true;
    }

    public static BooleanProperty createBooleanProperty(Object object, String string, boolean bl2, Runnable ... runnableArray) {
        SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(object, string, bl2);
        for (Runnable runnable : runnableArray) {
            PropUtil.runOnChange(runnable, new ObservableValue[]{simpleBooleanProperty});
        }
        return simpleBooleanProperty;
    }

    public static DoubleProperty createDoubleProperty(Object object, String string, double d2, Runnable ... runnableArray) {
        SimpleDoubleProperty simpleDoubleProperty = new SimpleDoubleProperty(object, string, d2);
        for (Runnable runnable : runnableArray) {
            PropUtil.runOnChange(runnable, new ObservableValue[]{simpleDoubleProperty});
        }
        return simpleDoubleProperty;
    }

    public static ReadOnlyDoubleWrapper createReadOnlyDoubleWrapper(Object object, String string, double d2, Runnable ... runnableArray) {
        ReadOnlyDoubleWrapper readOnlyDoubleWrapper = new ReadOnlyDoubleWrapper(object, string, d2);
        for (Runnable runnable : runnableArray) {
            PropUtil.runOnChange(runnable, new ObservableValue[]{readOnlyDoubleWrapper});
        }
        return readOnlyDoubleWrapper;
    }

    public static <T> ObjectProperty<T> createObjectProperty(Object object, String string, T t2, Runnable ... runnableArray) {
        SimpleObjectProperty simpleObjectProperty = new SimpleObjectProperty(object, string, t2);
        for (Runnable runnable : runnableArray) {
            PropUtil.runOnChange(runnable, new ObservableValue[]{simpleObjectProperty});
        }
        return simpleObjectProperty;
    }

    public static void initAndRunOnChange(Runnable runnable, ObservableValue<?> ... observableValueArray) {
        runnable.run();
        PropUtil.runOnChange(runnable, observableValueArray);
    }

    public static void runOnChange(final Runnable runnable, ObservableValue<?> ... observableValueArray) {
        for (ObservableValue<?> observableValue2 : observableValueArray) {
            ObservableDoubleValue observableDoubleValue;
            if (observableValue2 instanceof ObservableDoubleValue) {
                observableDoubleValue = (ObservableDoubleValue)observableValue2;
                observableValue2.addListener(new InvalidationListener(){
                    double prev;
                    {
                        this.prev = observableDoubleValue.get();
                    }

                    public void invalidated(Observable observable) {
                        if (!PropUtil.isEqual(this.prev, observableDoubleValue.get())) {
                            this.prev = observableDoubleValue.get();
                            runnable.run();
                        }
                    }
                });
                continue;
            }
            if (observableValue2 instanceof ObservableBooleanValue) {
                observableDoubleValue = (ObservableBooleanValue)observableValue2;
                observableValue2.addListener(new InvalidationListener(){
                    boolean prev;
                    final /* synthetic */ ObservableBooleanValue val$obs;
                    final /* synthetic */ Runnable val$action;
                    {
                        this.val$obs = observableBooleanValue;
                        this.val$action = runnable;
                        this.prev = this.val$obs.get();
                    }

                    public void invalidated(Observable observable) {
                        if (this.prev != this.val$obs.get()) {
                            this.prev = this.val$obs.get();
                            this.val$action.run();
                        }
                    }
                });
                continue;
            }
            if (observableValue2 instanceof ObservableIntegerValue) {
                observableDoubleValue = (ObservableIntegerValue)observableValue2;
                observableValue2.addListener(new InvalidationListener(){
                    int prev;
                    final /* synthetic */ ObservableIntegerValue val$obs;
                    final /* synthetic */ Runnable val$action;
                    {
                        this.val$obs = observableIntegerValue;
                        this.val$action = runnable;
                        this.prev = this.val$obs.get();
                    }

                    public void invalidated(Observable observable) {
                        if (this.prev != this.val$obs.get()) {
                            this.prev = this.val$obs.get();
                            this.val$action.run();
                        }
                    }
                });
                continue;
            }
            if (observableValue2 instanceof ObservableLongValue) {
                observableDoubleValue = (ObservableLongValue)observableValue2;
                observableValue2.addListener(new InvalidationListener(){
                    long prev;
                    final /* synthetic */ ObservableLongValue val$obs;
                    final /* synthetic */ Runnable val$action;
                    {
                        this.val$obs = observableLongValue;
                        this.val$action = runnable;
                        this.prev = this.val$obs.get();
                    }

                    public void invalidated(Observable observable) {
                        if (this.prev != this.val$obs.get()) {
                            this.prev = this.val$obs.get();
                            this.val$action.run();
                        }
                    }
                });
                continue;
            }
            observableValue2.addListener((observableValue, object, object2) -> runnable.run());
        }
    }

    public static boolean isEqual(double d2, double d3) {
        return Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isBlank();
    }

    private PropUtil() {
    }
}

