/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.utils.PaletteQuantizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaletteQuantizerNeuQuant
implements PaletteQuantizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaletteQuantizerNeuQuant.class);
    private int parNcolors = 256;
    private int parNcycles = 330;
    private int _parCutnetsize;
    private int _parMaxnetpos;
    private int parRadiusbiasshift = 6;
    private int _parRadiusbias;
    private int _parInitBiasRadius;
    private int parRadiusdec = 30;
    private int parTransparencyThreshold = 127;
    private int parAlphabiasshift = 10;
    private int _parIinitalpha;
    private double parGamma = 1024.0;
    private double parBeta = 9.765625E-4;
    private double _parGammaBetta;
    private boolean parReserveAlphaColor = false;
    private int parMaxPixelsToSample = 30000;
    private int _parSamplefac;
    private double[][] network;
    protected int[][] colormap;
    private final int[] netindex = new int[256];
    private double[] bias;
    private double[] freq;
    private final int width;
    private final int height;
    private final PixelGetter pixelGetter;
    private boolean done = false;

    public PaletteQuantizerNeuQuant(int n2, int n3, PixelGetter pixelGetter) {
        this.width = n2;
        this.height = n3;
        this.pixelGetter = pixelGetter;
    }

    public int[] convert(int n2, int n3, int n4) {
        this.initGuard();
        int n5 = this.indexSearch(n4, n3, n2);
        int n6 = this.colormap[n5][0];
        int n7 = this.colormap[n5][1];
        int n8 = this.colormap[n5][2];
        return new int[]{n8, n7, n6};
    }

    public int[] convert(int n2, int n3, int n4, int n5) {
        this.initGuard();
        if (this.parReserveAlphaColor && n5 < this.parTransparencyThreshold) {
            return new int[]{0, 0, 0, 0};
        }
        int n6 = this.indexSearch(n4, n3, n2);
        int n7 = this.colormap[n6][0];
        int n8 = this.colormap[n6][1];
        int n9 = this.colormap[n6][2];
        return new int[]{n9, n8, n7};
    }

    @Override
    public int[] getColor(int n2) {
        this.initGuard();
        int n3 = n2;
        if (this.parReserveAlphaColor && --n3 < 0) {
            return new int[]{0, 0, 0, 0};
        }
        if (n3 < 0 || n3 >= this.parNcolors) {
            throw new IllegalArgumentException("index out of range [0, " + this.parNcolors + "[");
        }
        int n4 = this.colormap[n3][0];
        int n5 = this.colormap[n3][1];
        int n6 = this.colormap[n3][2];
        return new int[]{n6, n5, n4, 255};
    }

    @Override
    public int getColorCount() {
        this.initGuard();
        return this.parReserveAlphaColor ? this.parNcolors + 1 : this.parNcolors;
    }

    @Override
    public int getTransparentIndex() {
        this.initGuard();
        return this.parReserveAlphaColor ? 0 : -1;
    }

    public boolean isParReserveAlphaColor() {
        return this.parReserveAlphaColor;
    }

    @Override
    public int lookup(int n2, int n3, int n4) {
        this.initGuard();
        int n5 = this.indexSearch(n4, n3, n2);
        return this.parReserveAlphaColor ? n5 + 1 : n5;
    }

    @Override
    public int lookup(int n2, int n3, int n4, int n5) {
        if (n5 < this.parTransparencyThreshold) {
            return 0;
        }
        return this.indexSearch(n4, n3, n2) + 1;
    }

    public void run() {
        if (this.done) {
            return;
        }
        this.initParams();
        this.setUpArrays();
        this.learn();
        this.fix();
        this.inxbuild();
        this.done = true;
    }

    public void setParAlphabiasshift(int n2) {
        this.parAlphabiasshift = n2;
    }

    public void setParBeta(double d2) {
        this.parBeta = d2;
    }

    public void setParGamma(double d2) {
        this.parGamma = d2;
    }

    public void setParMaxPixelsToSample(int n2) {
        this.parMaxPixelsToSample = n2;
    }

    public void setParNcolors(int n2) {
        this.parNcolors = n2;
    }

    public void setParNcycles(int n2) {
        this.parNcycles = n2;
    }

    public void setParRadiusbiasshift(int n2) {
        this.parRadiusbiasshift = n2;
    }

    public void setParRadiusdec(int n2) {
        this.parRadiusdec = n2;
    }

    public void setParReserveAlphaColor(boolean bl2) {
        this.parReserveAlphaColor = bl2;
    }

    public void setParTransparencyThreshold(int n2) {
        this.parTransparencyThreshold = n2;
    }

    protected void initGuard() {
        if (this.done) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("need to execute run() computation - fallback should be done prior in user-land");
        }
        this.run();
    }

    protected int indexSearch(int n2, int n3, int n4) {
        int n5 = 1000;
        int n6 = -1;
        int n7 = this.netindex[n3];
        int n8 = n7 - 1;
        while (n7 < this.parNcolors || n8 >= 0) {
            int n9;
            int n10;
            int[] nArray;
            if (n7 < this.parNcolors) {
                nArray = this.colormap[n7];
                n10 = nArray[1] - n3;
                if (n10 >= n5) {
                    n7 = this.parNcolors;
                } else {
                    if (n10 < 0) {
                        n10 = -n10;
                    }
                    if ((n9 = nArray[0] - n2) < 0) {
                        n9 = -n9;
                    }
                    if ((n10 += n9) < n5) {
                        n9 = nArray[2] - n4;
                        if (n9 < 0) {
                            n9 = -n9;
                        }
                        if ((n10 += n9) < n5) {
                            n5 = n10;
                            n6 = n7;
                        }
                    }
                    ++n7;
                }
            }
            if (n8 < 0) continue;
            nArray = this.colormap[n8];
            n10 = n3 - nArray[1];
            if (n10 >= n5) {
                n8 = -1;
                continue;
            }
            n10 = Math.abs(n10);
            n9 = nArray[0] - n2;
            if (n9 < 0) {
                n9 = -n9;
            }
            if ((n10 += n9) < n5) {
                n9 = nArray[2] - n4;
                if (n9 < 0) {
                    n9 = -n9;
                }
                if ((n10 += n9) < n5) {
                    n5 = n10;
                    n6 = n8;
                }
            }
            --n8;
        }
        return n6;
    }

    protected void setUpArrays() {
        this.network = new double[this.parNcolors][3];
        this.colormap = new int[this.parNcolors][4];
        this.bias = new double[this.parNcolors];
        this.freq = new double[this.parNcolors];
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 255.0;
        this.network[1][1] = 255.0;
        this.network[1][2] = 255.0;
        for (int i2 = 0; i2 < this.parNcolors; ++i2) {
            double[] dArray = this.network[i2];
            dArray[0] = 255.0 * (double)i2 / (double)this._parCutnetsize;
            dArray[1] = 255.0 * (double)i2 / (double)this._parCutnetsize;
            dArray[2] = 255.0 * (double)i2 / (double)this._parCutnetsize;
            this.freq[i2] = 1.0 / (double)this.parNcolors;
            this.bias[i2] = 0.0;
        }
    }

    private void alterneigh(double d2, int n2, int n3, double d3, double d4, double d5) {
        int n4;
        int n5 = n3 - n2;
        if (n5 < -1) {
            n5 = -1;
        }
        if ((n4 = n3 + n2) > this.parNcolors) {
            n4 = this.parNcolors;
        }
        int n6 = n3 + 1;
        int n7 = n3 - 1;
        int n8 = 0;
        while (n6 < n4 || n7 > n5) {
            double[] dArray;
            double d6 = d2 * (double)(n2 * n2 - n8 * n8) / (double)(n2 * n2);
            ++n8;
            if (n6 < n4) {
                dArray = this.network[n6];
                dArray[0] = dArray[0] - d6 * (dArray[0] - d3);
                dArray[1] = dArray[1] - d6 * (dArray[1] - d4);
                dArray[2] = dArray[2] - d6 * (dArray[2] - d5);
                ++n6;
            }
            if (n7 <= n5) continue;
            dArray = this.network[n7];
            dArray[0] = dArray[0] - d6 * (dArray[0] - d3);
            dArray[1] = dArray[1] - d6 * (dArray[1] - d4);
            dArray[2] = dArray[2] - d6 * (dArray[2] - d5);
            --n7;
        }
    }

    private void altersingle(double d2, int n2, double d3, double d4, double d5) {
        double[] dArray = this.network[n2];
        dArray[0] = dArray[0] - d2 * (dArray[0] - d3);
        dArray[1] = dArray[1] - d2 * (dArray[1] - d4);
        dArray[2] = dArray[2] - d2 * (dArray[2] - d5);
    }

    private int contest(double d2, double d3, double d4) {
        int n2;
        double d5;
        double d6 = d5 = 3.4028234663852886E38;
        int n3 = n2 = -1;
        for (int i2 = 0; i2 < this.parNcolors; ++i2) {
            double d7;
            double d8;
            double[] dArray = this.network[i2];
            double d9 = dArray[0] - d2;
            if (d9 < 0.0) {
                d9 = -d9;
            }
            if ((d8 = dArray[1] - d3) < 0.0) {
                d8 = -d8;
            }
            d9 += d8;
            d8 = dArray[2] - d4;
            if (d8 < 0.0) {
                d8 = -d8;
            }
            if ((d9 += d8) < d5) {
                d5 = d9;
                n2 = i2;
            }
            if ((d7 = d9 - this.bias[i2]) < d6) {
                d6 = d7;
                n3 = i2;
            }
            int n4 = i2;
            this.freq[n4] = this.freq[n4] - this.parBeta * this.freq[i2];
            int n5 = i2;
            this.bias[n5] = this.bias[n5] + this._parGammaBetta * this.freq[i2];
        }
        int n6 = n2;
        this.freq[n6] = this.freq[n6] + this.parBeta;
        int n7 = n2;
        this.bias[n7] = this.bias[n7] - this._parGammaBetta;
        return n3;
    }

    private void fix() {
        for (int i2 = 0; i2 < this.parNcolors; ++i2) {
            for (int i3 = 0; i3 < 3; ++i3) {
                int n2 = (int)(0.5 + this.network[i2][i3]);
                this.colormap[i2][i3] = n2 = Math.max(Math.min(255, n2), 0);
            }
            this.colormap[i2][3] = i2;
        }
    }

    private void initParams() {
        if (this.parReserveAlphaColor && this.parNcolors % 2 == 0) {
            --this.parNcolors;
        }
        this._parGammaBetta = this.parBeta * this.parGamma;
        this._parCutnetsize = this.parNcolors;
        this._parMaxnetpos = this.parNcolors - 1;
        int n2 = (this.parNcolors + 7) / 8;
        this._parRadiusbias = 1 << this.parRadiusbiasshift;
        this._parInitBiasRadius = n2 * this._parRadiusbias;
        this._parIinitalpha = 1 << this.parAlphabiasshift;
        this._parSamplefac = this.width * this.height / this.parMaxPixelsToSample;
        if (this._parSamplefac < 1) {
            this._parSamplefac = 1;
        } else if (this._parSamplefac > 30) {
            this._parSamplefac = 30;
        }
    }

    private void inxbuild() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.parNcolors; ++n2) {
            int n5;
            int[] nArray = this.colormap[n2];
            int[] nArray2 = null;
            int n6 = n2;
            int n7 = nArray[1];
            for (n5 = n2 + 1; n5 < this.parNcolors; ++n5) {
                nArray2 = this.colormap[n5];
                if (nArray2[1] >= n7) continue;
                n6 = n5;
                n7 = nArray2[1];
            }
            nArray2 = this.colormap[n6];
            if (n2 != n6) {
                n5 = nArray2[0];
                nArray2[0] = nArray[0];
                nArray[0] = n5;
                n5 = nArray2[1];
                nArray2[1] = nArray[1];
                nArray[1] = n5;
                n5 = nArray2[2];
                nArray2[2] = nArray[2];
                nArray[2] = n5;
                n5 = nArray2[3];
                nArray2[3] = nArray[3];
                nArray[3] = n5;
            }
            if (n7 == n3) continue;
            this.netindex[n3] = n4 + n2 >> 1;
            for (n5 = n3 + 1; n5 < n7; ++n5) {
                this.netindex[n5] = n2;
            }
            n3 = n7;
            n4 = n2;
        }
        this.netindex[n3] = n4 + this._parMaxnetpos >> 1;
        for (n2 = n3 + 1; n2 < 256; ++n2) {
            this.netindex[n2] = this._parMaxnetpos;
        }
    }

    private void learn() {
        int n2;
        int n3 = this._parInitBiasRadius;
        int n4 = 30 + (this._parSamplefac - 1) / 3;
        int n5 = this.width * this.height;
        int n6 = n5 / this._parSamplefac;
        if (n6 < 1000) {
            n6 = 1000;
        }
        if (n6 > n5) {
            n6 = n5;
        }
        if ((n2 = n6 / this.parNcycles) < 1) {
            n2 = 1;
        }
        int n7 = this._parIinitalpha;
        int n8 = (int)(Math.sqrt(n5 / n6) + 0.5);
        int n9 = (int)((double)n5 / ((double)n6 * (double)n8) + 0.5);
        n9 = Math.max(1, n9);
        int n10 = n3 >> this.parRadiusbiasshift;
        if (n10 <= 1) {
            n10 = 0;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument(n6).addArgument(n10).log("beginning 1D learning: samplepixels = {} rad = {}");
        }
        int n11 = 1;
        for (int i2 = 0; i2 < this.height; i2 += n9) {
            for (int i3 = 0; i3 < this.width; i3 += n8) {
                int n12;
                int n13 = this.pixelGetter.getPixel(i2, (i3 + i2) % this.width);
                int n14 = n12 = !this.parReserveAlphaColor ? 255 : n13 >> 24 & 0xFF;
                if (n12 < this.parTransparencyThreshold) continue;
                double d2 = n13 >> 16 & 0xFF;
                double d3 = n13 >> 8 & 0xFF;
                double d4 = n13 & 0xFF;
                int n15 = this.contest(d4, d3, d2);
                double d5 = 1.0 * (double)n7 / (double)this._parIinitalpha;
                this.altersingle(d5, n15, d4, d3, d2);
                if (n10 > 0) {
                    this.alterneigh(d5, n10, n15, d4, d3, d2);
                }
                if (++n11 % n2 != 0) continue;
                n7 -= n7 / n4;
                if ((n10 = (n3 -= n3 / this.parRadiusdec) >> this.parRadiusbiasshift) > 1) continue;
                n10 = 0;
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument(1.0 * (double)n7 / (double)this._parIinitalpha).log("finished 1D learning: final alpha = {}");
        }
    }

    public static interface PixelGetter {
        public int getPixel(int var1, int var2);
    }
}

