/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;

public final class MouseUtils {
    private MouseUtils() {
    }

    public static double mouseOutsideBoundaryBoxDistance(Bounds bounds, Point2D point2D) {
        if (bounds.contains(point2D)) {
            return 0.0;
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = d2 < bounds.getMinX() ? bounds.getMinX() - d2 : (d2 > bounds.getMaxX() ? d2 - bounds.getMaxX() : 0.0);
        double d5 = d3 < bounds.getMinY() ? bounds.getMinY() - d3 : (d3 > bounds.getMaxY() ? d3 - bounds.getMaxY() : 0.0);
        return Math.max(d4, d5);
    }

    public static double mouseInsideBoundaryBoxDistance(Bounds bounds, Point2D point2D) {
        if (!bounds.contains(point2D)) {
            return 0.0;
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = d2 > bounds.getMinX() && d2 < bounds.getMaxX() ? Math.min(d2 - bounds.getMinX(), bounds.getMaxX() - d2) : 0.0;
        double d5 = d3 > bounds.getMinY() && d3 < bounds.getMaxY() ? Math.min(d3 - bounds.getMinY(), bounds.getMaxY() - d3) : 0.0;
        return Math.min(d4, d5);
    }
}

