/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.layout;

import io.fair_acc.chartfx.axes.spi.AbstractAxis;
import io.fair_acc.chartfx.ui.geometry.Corner;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import io.fair_acc.dataset.utils.AssertUtils;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class ChartPane
extends Pane {
    private static final String CHART_ELEMENT = "chart-pane-element";
    private final DoubleArrayList cachedPrefSize = new DoubleArrayList();

    public static Object getLocation(Node node) {
        return FXUtils.getConstraint(node, CHART_ELEMENT);
    }

    public static void setSide(Node node, Side side) {
        AssertUtils.notNull("Side must not be null", side);
        side.applyPseudoClasses(node);
        FXUtils.setConstraint(node, CHART_ELEMENT, (Object)side);
    }

    public static void setCorner(Node node, Corner corner) {
        FXUtils.setConstraint(node, CHART_ELEMENT, (Object)corner);
    }

    public static void setCenter(Node node) {
        FXUtils.setConstraint(node, CHART_ELEMENT, null);
    }

    static void resizeRelocate(Node node, double d2, double d3, double d4, double d5) {
        if (node != null) {
            node.resizeRelocate(d2, d3, d4, d5);
        }
    }

    static double getPrefHeight(Node node, double d2) {
        if (node == null || !node.isVisible()) {
            return 0.0;
        }
        return node.prefHeight(d2);
    }

    static double getPrefWidth(Node node, double d2) {
        if (node == null || !node.isVisible()) {
            return 0.0;
        }
        return node.prefWidth(d2);
    }

    public ChartPane addSide(Side side, Node node, Node ... nodeArray) {
        this.getChildren().add((Object)node);
        ChartPane.setSide(node, side);
        for (Node node2 : nodeArray) {
            this.addSide(side, node2, new Node[0]);
        }
        return this;
    }

    public ChartPane addCorner(Corner corner, Node node, Node ... nodeArray) {
        this.getChildren().add((Object)node);
        ChartPane.setCorner(node, corner);
        for (Node node2 : nodeArray) {
            this.addCorner(corner, node2, new Node[0]);
        }
        return this;
    }

    public ChartPane addCenter(Node node, Node ... nodeArray) {
        this.getChildren().add((Object)node);
        ChartPane.setCenter(node);
        for (Node node2 : nodeArray) {
            this.addCenter(node2, new Node[0]);
        }
        return this;
    }

    public void remove(Node node, Node ... nodeArray) {
        this.getChildren().remove((Object)node);
        if (nodeArray.length > 0) {
            this.getChildren().removeAll((Object[])nodeArray);
        }
    }

    private void addNode(Object object, Node node) {
        this.getChildren().add((Object)node);
        node.getProperties().put((Object)CHART_ELEMENT, object);
        this.requestLayout();
    }

    private double estimateHeightOfAllHorizontalAxes() {
        double d2 = 0.0;
        for (Node node : this.getChildren()) {
            Object object;
            if (!node.isManaged() || !(node instanceof AbstractAxis) || (object = ChartPane.getLocation(node)) != Side.TOP && object != Side.BOTTOM) continue;
            AbstractAxis abstractAxis = (AbstractAxis)node;
            d2 += Math.max(0.0, abstractAxis.getHeight() > 0.0 ? abstractAxis.getHeight() : abstractAxis.getMinHeight());
        }
        return d2;
    }

    protected double computeMinWidth(double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            Object object = ChartPane.getLocation(node);
            if (object == null) {
                d4 = Math.max(d4, node.minWidth(d2));
                continue;
            }
            if (!(object instanceof Side)) continue;
            switch ((Side)((Object)object)) {
                case CENTER_HOR: 
                case CENTER_VER: 
                case TOP: 
                case BOTTOM: {
                    d4 = Math.max(d4, node.minWidth(d2));
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    d3 += node.minWidth(d2);
                }
            }
        }
        return d3 + d4;
    }

    protected double computeMinHeight(double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            Object object = ChartPane.getLocation(node);
            if (object == null) {
                d4 = Math.max(d4, node.minHeight(d2));
                continue;
            }
            if (!(object instanceof Side)) continue;
            switch ((Side)((Object)object)) {
                case CENTER_HOR: 
                case CENTER_VER: 
                case LEFT: 
                case RIGHT: {
                    d4 = Math.max(d4, node.minHeight(d2));
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    d3 += node.minHeight(d2);
                }
            }
        }
        return d3 + d4;
    }

    protected void layoutChildren() {
        double d2;
        double d3 = this.snappedLeftInset();
        double d4 = this.snappedTopInset();
        double d5 = this.snapSizeX(this.getWidth()) - d3 - this.snappedRightInset();
        double d6 = this.snapSizeY(this.getHeight()) - d4 - this.snappedBottomInset();
        this.cachedPrefSize.clear();
        this.cachedPrefSize.size(this.getChildren().size());
        double d7 = this.snapSizeY(d6 - this.estimateHeightOfAllHorizontalAxes());
        double d8 = 0.0;
        double d9 = 0.0;
        int n2 = 0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            Object object = ChartPane.getLocation(node);
            if (object instanceof Side) {
                switch ((Side)((Object)object)) {
                    case LEFT: {
                        d2 = this.snapSizeX(ChartPane.getPrefWidth(node, d7));
                        this.cachedPrefSize.set(n2, d2);
                        d8 += d2;
                        break;
                    }
                    case RIGHT: {
                        d2 = this.snapSizeX(ChartPane.getPrefWidth(node, d7));
                        this.cachedPrefSize.set(n2, d2);
                        d9 += d2;
                        break;
                    }
                    case CENTER_VER: {
                        d2 = this.snapSizeX(ChartPane.getPrefWidth(node, d7));
                        this.cachedPrefSize.set(n2, d2);
                    }
                }
            }
            ++n2;
        }
        double d10 = this.snapSizeX(d5 - d8 - d9);
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            Object object = ChartPane.getLocation(node);
            if (object instanceof Side) {
                switch ((Side)((Object)object)) {
                    case TOP: {
                        d2 = this.snapSizeY(ChartPane.getPrefHeight(node, d10));
                        this.cachedPrefSize.set(n2, d2);
                        n3 = (int)((double)n3 + d2);
                        break;
                    }
                    case BOTTOM: {
                        d2 = this.snapSizeY(ChartPane.getPrefHeight(node, d10));
                        this.cachedPrefSize.set(n2, d2);
                        n4 = (int)((double)n4 + d2);
                        break;
                    }
                    case CENTER_HOR: {
                        d2 = this.snapSizeY(ChartPane.getPrefHeight(node, d10));
                        this.cachedPrefSize.set(n2, d2);
                    }
                }
            }
            ++n2;
        }
        double d11 = this.snapSizeY(d6 - (double)n3 - (double)n4);
        double d12 = d3 + d8;
        double d13 = d4 + (double)n3;
        double d14 = d12 + d10;
        double d15 = d13 + d11;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        n2 = 0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            Object object = ChartPane.getLocation(node);
            d2 = this.cachedPrefSize.getDouble(n2++);
            if (object == null) {
                ChartPane.resizeRelocate(node, d12, d13, d10, d11);
                continue;
            }
            if (object instanceof Corner) {
                switch ((Corner)((Object)object)) {
                    case TOP_LEFT: {
                        ChartPane.resizeRelocate(node, d3, d4, d8, n3);
                        break;
                    }
                    case TOP_RIGHT: {
                        ChartPane.resizeRelocate(node, d14, d4, d9, n3);
                        break;
                    }
                    case BOTTOM_LEFT: {
                        ChartPane.resizeRelocate(node, d3, d15, d8, n4);
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        ChartPane.resizeRelocate(node, d14, d15, d9, n4);
                    }
                }
                continue;
            }
            if (!(object instanceof Side)) continue;
            switch ((Side)((Object)object)) {
                case TOP: {
                    ChartPane.resizeRelocate(node, d12, d4 + d18, d10, d2);
                    d18 += d2;
                    break;
                }
                case BOTTOM: {
                    ChartPane.resizeRelocate(node, d12, d15 + d19, d10, d2);
                    d19 += d2;
                    break;
                }
                case LEFT: {
                    ChartPane.resizeRelocate(node, d3 + d16, d13, d2, d11);
                    d16 += d2;
                    break;
                }
                case RIGHT: {
                    ChartPane.resizeRelocate(node, d14 + d17, d13, d2, d11);
                    d17 += d2;
                    break;
                }
                case CENTER_HOR: {
                    ChartPane.resizeRelocate(node, d12, this.snapSizeY(d13 + d11 / 2.0 - d2 / 2.0), d10, d2);
                    break;
                }
                case CENTER_VER: {
                    ChartPane.resizeRelocate(node, this.snapSizeX(d12 + d10 / 2.0 - d2 / 2.0), d13, d2, d11);
                }
            }
        }
    }
}

