/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui;

import java.util.HashMap;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.chart.Axis;

public final class ChartLayoutAnimator
extends AnimationTimer
implements EventHandler<ActionEvent> {
    private final Parent nodeToLayout;
    private final Map<Object, Animation> activeTimeLines = new HashMap<Object, Animation>();
    private final boolean isAxis;

    public ChartLayoutAnimator(Parent parent) {
        this.nodeToLayout = parent;
        this.isAxis = parent instanceof Axis;
    }

    public Object animate(Animation animation) {
        SequentialTransition sequentialTransition = new SequentialTransition();
        sequentialTransition.getChildren().add((Object)animation);
        sequentialTransition.setOnFinished((EventHandler)this);
        if (this.activeTimeLines.isEmpty()) {
            this.start();
        }
        this.activeTimeLines.put(sequentialTransition, (Animation)sequentialTransition);
        sequentialTransition.play();
        return sequentialTransition;
    }

    public Object animate(KeyFrame ... keyFrameArray) {
        Timeline timeline = new Timeline();
        timeline.setAutoReverse(false);
        timeline.setCycleCount(1);
        timeline.getKeyFrames().addAll((Object[])keyFrameArray);
        timeline.setOnFinished((EventHandler)this);
        if (this.activeTimeLines.isEmpty()) {
            this.start();
        }
        this.activeTimeLines.put(timeline, (Animation)timeline);
        timeline.play();
        return timeline;
    }

    public void handle(ActionEvent actionEvent) {
        this.activeTimeLines.remove(actionEvent.getSource());
        if (this.activeTimeLines.isEmpty()) {
            this.stop();
        }
        this.handle(0L);
    }

    public void handle(long l2) {
        if (this.isAxis) {
            ((Axis)this.nodeToLayout).requestAxisLayout();
        } else {
            this.nodeToLayout.requestLayout();
        }
    }

    public void stop(Object object) {
        Animation animation = this.activeTimeLines.remove(object);
        if (animation != null) {
            animation.stop();
        }
        if (this.activeTimeLines.isEmpty()) {
            this.stop();
        }
    }
}

