/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

public final class DashPatternStyle {
    private static final WeakHashMap<Integer, ImagePattern> dashHashMap = new WeakHashMap();

    private DashPatternStyle() {
    }

    private static Integer computeHash(Paint paint, double d2, boolean bl2, double[] dArray) {
        int n2 = 7;
        n2 = 31 * n2 + paint.hashCode();
        n2 = 31 * n2 + Double.hashCode(d2);
        n2 = 31 * n2 + Boolean.hashCode(bl2);
        n2 = dArray == null ? 31 * n2 + 3141 : 31 * n2 + Arrays.hashCode(dArray);
        return n2;
    }

    private static ImagePattern createDefaultHatch(Paint paint, double d2, boolean bl2, double[] dArray) {
        Integer n3 = DashPatternStyle.computeHash(paint, d2, bl2, dArray);
        return dashHashMap.computeIfAbsent(n3, n2 -> {
            double d3 = DashPatternStyle.getPatternLength(dArray);
            double d4 = bl2 ? d3 : d2;
            double d5 = bl2 ? d2 : d3;
            double d6 = (int)(d2 / 2.0);
            Pane pane = new Pane();
            pane.setPrefSize(d4, d5);
            Line line = bl2 ? new Line(0.0, d6, d3, d6) : new Line(d6, 0.0, d6, d3);
            line.setSmooth(false);
            line.setStroke(paint);
            if (dArray == null) {
                line.getStrokeDashArray().setAll((Object[])new Double[]{d3});
            } else {
                line.getStrokeDashArray().setAll((Collection)DoubleStream.of(dArray).boxed().collect(Collectors.toList()));
            }
            line.setStrokeWidth(d2);
            pane.getChildren().addAll((Object[])new Node[]{line});
            pane.setStyle("-fx-background-color: rgba(0, 0, 0, 0.0)");
            Scene scene = new Scene((Parent)pane);
            scene.setFill((Paint)Color.TRANSPARENT);
            WritableImage writableImage = pane.snapshot(null, null);
            return new ImagePattern((Image)writableImage, d4, 0.0, d4, d5, false);
        });
    }

    private static double getPatternLength(double[] dArray) {
        if (dArray == null || dArray.length <= 1) {
            return 1.0;
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += dArray[i2];
        }
        return d2;
    }

    public static void strokeDashedLine(GraphicsContext graphicsContext, double d2, double d3, double d4, double d5) {
        double d6;
        Paint paint = graphicsContext.getStroke();
        double d7 = Math.max(graphicsContext.getLineWidth(), 1.0);
        double d8 = d7 / 2.0;
        double[] dArray = graphicsContext.getLineDashes();
        double d9 = Math.abs(d4 - d2);
        boolean bl2 = d9 > (d6 = Math.abs(d5 - d3));
        graphicsContext.setFill((Paint)DashPatternStyle.createDefaultHatch(paint, d7, bl2, dArray));
        if (bl2) {
            graphicsContext.fillRect(d2, d3 - d8, d9, d7);
        } else {
            graphicsContext.fillRect(d2 - d8, d3, d7, d6);
        }
    }
}

