/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.utils;

import io.fair_acc.chartfx.Chart;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public final class ChartIconFactory {
    private static final String ICON_INFO = "I";
    private static final String ICON_WARN = "W";
    private static final String ICON_ERROR = "E";
    private static final Map<String, Color[]> colourMap = new HashMap<String, Color[]>();
    private static final int DEFAULT_HEIGHT = 32;
    public static Font iconFont;

    private ChartIconFactory() {
    }

    public static Node getErrorIcon() {
        return ChartIconFactory.getIcon(ICON_ERROR);
    }

    public static Node getErrorIcon(double d2) {
        return ChartIconFactory.getIcon(ICON_ERROR, d2);
    }

    private static Node getIcon(String string) {
        return ChartIconFactory.getIcon(string, 32.0);
    }

    public static Node getIcon(String string, double d2) {
        Group group = new Group();
        Text text = new Text(string);
        text.setFont(Font.font((String)"fair-chart-icons", (double)d2));
        text.setFill((Paint)colourMap.get(string)[0]);
        Text text2 = new Text(Character.toString(string.charAt(0) + '\u0001'));
        text2.setFont(Font.font((String)"fair-chart-icons", (double)d2));
        text2.setFill((Paint)colourMap.get(string)[1]);
        group.getChildren().addAll((Object[])new Node[]{text, text2});
        return group;
    }

    public static Node getInfoIcon() {
        return ChartIconFactory.getIcon(ICON_INFO);
    }

    public static Node getInfoIcon(double d2) {
        return ChartIconFactory.getIcon(ICON_INFO, d2);
    }

    public static Node getWarningIcon() {
        return ChartIconFactory.getIcon(ICON_WARN);
    }

    public static Node getWarningIcon(double d2) {
        return ChartIconFactory.getIcon(ICON_WARN, d2);
    }

    static {
        try (InputStream inputStream = Chart.class.getResourceAsStream("fonts/fair-chart-icons.ttf");){
            iconFont = Font.loadFont((InputStream)inputStream, (double)32.0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        colourMap.put(ICON_INFO, new Color[]{Color.rgb((int)0, (int)0, (int)200), Color.WHITE});
        colourMap.put(ICON_WARN, new Color[]{Color.rgb((int)255, (int)215, (int)0), Color.BLACK});
        colourMap.put(ICON_ERROR, new Color[]{Color.rgb((int)237, (int)28, (int)36), Color.WHITE});
    }
}

