/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.utils;

public final class BezierCurve {
    private BezierCurve() {
    }

    public static void calcCurveControlPoints(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, int n2) {
        int n3 = n2 - 1;
        if (n3 == 1) {
            dArray3[0] = (2.0 * dArray[0] + dArray[1]) / 3.0;
            dArray4[0] = (2.0 * dArray2[0] + dArray2[1]) / 3.0;
            dArray5[0] = 2.0 * dArray3[0] - dArray[0];
            dArray6[0] = 2.0 * dArray4[0] - dArray2[0];
            return;
        }
        double[] dArray7 = new double[n3];
        for (int i2 = 1; i2 < n3 - 1; ++i2) {
            dArray7[i2] = 4.0 * dArray[i2] + 2.0 * dArray[i2 + 1];
        }
        dArray7[0] = dArray[0] + 2.0 * dArray[1];
        dArray7[n3 - 1] = (8.0 * dArray[n3 - 1] + dArray[n3]) / 2.0;
        double[] dArray8 = BezierCurve.getFirstControlPoints(dArray7);
        for (int i3 = 1; i3 < n3 - 1; ++i3) {
            dArray7[i3] = 4.0 * dArray2[i3] + 2.0 * dArray2[i3 + 1];
        }
        dArray7[0] = dArray2[0] + 2.0 * dArray2[1];
        dArray7[n3 - 1] = (8.0 * dArray2[n3 - 1] + dArray2[n3]) / 2.0;
        double[] dArray9 = BezierCurve.getFirstControlPoints(dArray7);
        System.arraycopy(dArray8, 0, dArray3, 0, n3);
        System.arraycopy(dArray9, 0, dArray4, 0, n3);
        for (int i4 = 0; i4 < n3; ++i4) {
            if (i4 < n3 - 1) {
                dArray5[i4] = 2.0 * dArray[i4 + 1] - dArray8[i4 + 1];
                dArray6[i4] = 2.0 * dArray2[i4 + 1] - dArray9[i4 + 1];
                continue;
            }
            dArray5[i4] = (dArray[n3] + dArray8[n3 - 1]) / 2.0;
            dArray6[i4] = (dArray2[n3] + dArray9[n3 - 1]) / 2.0;
        }
    }

    private static double[] getFirstControlPoints(double[] dArray) {
        int n2;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double d2 = 2.0;
        dArray2[0] = dArray[0] / d2;
        for (n2 = 1; n2 < n3; ++n2) {
            dArray3[n2] = 1.0 / d2;
            d2 = (n2 < n3 - 1 ? 4.0 : 3.5) - dArray3[n2];
            dArray2[n2] = (dArray[n2] - dArray2[n2 - 1]) / d2;
        }
        for (n2 = 1; n2 < n3; ++n2) {
            int n4 = n3 - n2 - 1;
            dArray2[n4] = dArray2[n4] - dArray3[n3 - n2] * dArray2[n3 - n2];
        }
        return dArray2;
    }
}

