/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.marchingsquares;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.canvas.GraphicsContext;

public class GeneralPath {
    private final List<Segment> drawList = new ArrayList<Segment>();

    GeneralPath() {
        this.beginPath();
    }

    public final void beginPath() {
        this.drawList.add(new Segment(PathType.GC_BEGINPATH, 0.0, 0.0));
    }

    public void closePath() {
        this.drawList.add(new Segment(PathType.GC_CLOSEPATH, 0.0, 0.0));
    }

    public int draw(GraphicsContext graphicsContext) {
        int n2 = 0;
        for (Segment segment : this.drawList) {
            switch (segment.type) {
                case GC_LINETO: {
                    graphicsContext.lineTo(segment.x, segment.y);
                    ++n2;
                    break;
                }
                case GC_MOVETO: {
                    graphicsContext.moveTo(segment.x, segment.y);
                    ++n2;
                    break;
                }
                case GC_BEGINPATH: {
                    graphicsContext.beginPath();
                    break;
                }
                case GC_CLOSEPATH: {
                    graphicsContext.closePath();
                    graphicsContext.stroke();
                    break;
                }
            }
        }
        return n2;
    }

    public void lineTo(float f2, float f3) {
        this.drawList.add(new Segment(PathType.GC_LINETO, f2, f3));
    }

    public void moveTo(float f2, float f3) {
        this.drawList.add(new Segment(PathType.GC_MOVETO, f2, f3));
    }

    public int size() {
        return this.drawList.size();
    }

    private static class Segment {
        public double x;
        public double y;
        public PathType type;

        Segment(PathType pathType, double d2, double d3) {
            this.type = pathType;
            this.x = d2;
            this.y = d3;
        }
    }

    static enum PathType {
        GC_LINETO,
        GC_MOVETO,
        GC_BEGINPATH,
        GC_CLOSEPATH;

    }
}

