/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.hexagon;

import io.fair_acc.chartfx.renderer.spi.hexagon.Hexagon;
import io.fair_acc.chartfx.renderer.spi.hexagon.HexagonMap;
import io.fair_acc.chartfx.renderer.spi.hexagon.IHexagonCreator;
import java.util.Optional;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.paint.Color;

class MapGenerator {
    private final HexagonMap map;
    private final Image image;
    private final int mapWidth;
    private Double verticalRelation;
    private Double horizontalRelation;

    public MapGenerator(HexagonMap hexagonMap, Image image, int n2) {
        this.map = hexagonMap;
        this.image = image;
        this.mapWidth = n2;
    }

    public void generate(IHexagonCreator iHexagonCreator) {
        PixelReader pixelReader = this.image.getPixelReader();
        if (pixelReader == null) {
            return;
        }
        double d2 = this.image.getWidth();
        double d3 = this.image.getHeight();
        double d4 = this.map.getGraphicsHorizontalDistanceBetweenHexagons() * (double)this.mapWidth;
        this.horizontalRelation = d2 / d4;
        double d5 = d3 / this.horizontalRelation;
        int n2 = (int)(d5 / this.map.getGraphicsverticalDistanceBetweenHexagons());
        this.verticalRelation = d3 / (this.map.getGraphicsverticalDistanceBetweenHexagons() * (double)n2 + (double)(this.map.getGraphicsHexagonHeight() / 2));
        for (int i2 = 0; i2 < this.mapWidth; ++i2) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = i2 - (n3 - (n3 & 1)) / 2;
                int n5 = n3++;
                Hexagon hexagon = new Hexagon(n4, n5);
                hexagon.setMap(this.map);
                int n6 = (int)((double)(hexagon.getGraphicsXoffset() - this.map.graphicsXpadding) * this.horizontalRelation);
                int n7 = (int)((double)(hexagon.getGraphicsYoffset() - this.map.graphicsYpadding) * this.verticalRelation);
                Color color = pixelReader.getColor(n6, n7);
                iHexagonCreator.createHexagon(n4, n5, color, this.map);
            }
        }
    }

    public Optional<Double> getHorizontalRelation() {
        return this.horizontalRelation == null ? Optional.empty() : Optional.of(this.horizontalRelation);
    }

    public Optional<Double> getVerticalRelation() {
        return this.verticalRelation == null ? Optional.empty() : Optional.of(this.verticalRelation);
    }
}

