/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.hexagon;

import io.fair_acc.chartfx.renderer.spi.hexagon.HexagonMap;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GridPosition
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6932865381701419097L;
    protected final int q;
    protected final int r;

    public GridPosition(int n2, int n3) {
        this.q = n2;
        this.r = n3;
    }

    public GridPosition clone() throws CloneNotSupportedException {
        try {
            return (GridPosition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger(GridPosition.class.getName()).log(Level.SEVERE, null, cloneNotSupportedException);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().equals(this.getClass())) {
            GridPosition gridPosition = (GridPosition)object;
            return gridPosition.q == this.q && gridPosition.r == this.r;
        }
        return false;
    }

    public String getCoordinates() {
        String string = this.q + ", " + this.r;
        return string;
    }

    public HexagonMap.Direction getDirectionTo(GridPosition gridPosition) {
        if (this.equals(gridPosition)) {
            throw new IllegalArgumentException("Other position (" + gridPosition + ") cannot be same as this (" + this + ")");
        }
        GridPosition gridPosition2 = this.line(gridPosition).get(1);
        for (int i2 = 0; i2 < 6; ++i2) {
            if (!this.getNeighborPosition(GridPosition.getDirectionFromNumber(i2)).equals(gridPosition2)) continue;
            return GridPosition.getDirectionFromNumber(i2);
        }
        throw new InvalidParameterException("unknown position: " + gridPosition);
    }

    public int getDistance(GridPosition gridPosition) {
        return GridPosition.getDistance(this, gridPosition);
    }

    public GridPosition getNeighborPosition(HexagonMap.Direction direction) {
        int n2 = GridPosition.getNumberFromDirection(direction);
        int[][] nArrayArray = new int[][]{{0, -1}, {1, -1}, {1, 0}, {0, 1}, {-1, 1}, {-1, 0}};
        int[] nArray = nArrayArray[n2];
        return new GridPosition(this.q + nArray[0], this.r + nArray[1]);
    }

    public List<GridPosition> getPositionsInCircleArea(int n2) {
        ArrayList<GridPosition> arrayList = new ArrayList<GridPosition>();
        for (int i2 = 0; i2 <= n2; ++i2) {
            List<GridPosition> list = this.getPositionsOnCircleEdge(i2);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<GridPosition> getPositionsOnCircleEdge(int n2) {
        int n3;
        ArrayList<GridPosition> arrayList = new ArrayList<GridPosition>();
        if (n2 == 0) {
            arrayList.add(this);
            return arrayList;
        }
        GridPosition gridPosition = this;
        for (n3 = 0; n3 < n2; ++n3) {
            gridPosition = gridPosition.getNeighborPosition(HexagonMap.Direction.SOUTHWEST);
        }
        for (n3 = 0; n3 < 6; ++n3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    arrayList.add(gridPosition.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    Logger.getLogger(GridPosition.class.getName()).log(Level.SEVERE, null, cloneNotSupportedException);
                }
                gridPosition = gridPosition.getNeighborPosition(GridPosition.getDirectionFromNumber(n3));
            }
        }
        return arrayList;
    }

    public int getQ() {
        return this.q;
    }

    public int getR() {
        return this.r;
    }

    public int hashCode() {
        int n2 = 5;
        n2 = 97 * n2 + this.q;
        n2 = 97 * n2 + this.r;
        return n2;
    }

    public boolean isAdjacent(GridPosition gridPosition) {
        for (int i2 = 0; i2 < 6; ++i2) {
            GridPosition gridPosition2 = this.getNeighborPosition(GridPosition.getDirectionFromNumber(i2));
            if (!gridPosition.equals(gridPosition2)) continue;
            return true;
        }
        return false;
    }

    public List<GridPosition> line(GridPosition gridPosition) {
        ArrayList<GridPosition> arrayList = new ArrayList<GridPosition>();
        double d2 = GridPosition.getDistance(this, gridPosition);
        int n2 = 0;
        while ((double)n2 < d2) {
            double d3 = n2;
            double d4 = (double)this.q * (1.0 - d3 / d2) + (double)gridPosition.q * d3 / d2;
            double d5 = (double)this.r * (1.0 - d3 / d2) + (double)gridPosition.r * d3 / d2;
            GridPosition gridPosition2 = GridPosition.hexRound(d4, d5);
            arrayList.add(gridPosition2);
            ++n2;
        }
        arrayList.add(gridPosition);
        return arrayList;
    }

    public String toString() {
        return "GridPosition q=" + this.q + ", r=" + this.r;
    }

    public static HexagonMap.Direction getDirectionFromNumber(int n2) {
        switch (n2) {
            case 0: {
                return HexagonMap.Direction.NORTHWEST;
            }
            case 1: {
                return HexagonMap.Direction.NORTHEAST;
            }
            case 2: {
                return HexagonMap.Direction.EAST;
            }
            case 3: {
                return HexagonMap.Direction.SOUTHEAST;
            }
            case 4: {
                return HexagonMap.Direction.SOUTHWEST;
            }
            case 5: {
                return HexagonMap.Direction.WEST;
            }
        }
        throw new InvalidParameterException("unknown direction: " + n2);
    }

    public static int getDistance(GridPosition gridPosition, GridPosition gridPosition2) {
        return (Math.abs(gridPosition.q - gridPosition2.q) + Math.abs(gridPosition.r - gridPosition2.r) + Math.abs(gridPosition.q + gridPosition.r - gridPosition2.q - gridPosition2.r)) / 2;
    }

    private static int getNumberFromDirection(HexagonMap.Direction direction) {
        switch (direction) {
            case NORTHWEST: {
                return 0;
            }
            case NORTHEAST: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case SOUTHEAST: {
                return 3;
            }
            case SOUTHWEST: {
                return 4;
            }
            case WEST: {
                return 5;
            }
        }
        throw new InvalidParameterException("direction unknown: " + direction);
    }

    public static GridPosition hexRound(double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        double d6 = -d4 - d5;
        long l2 = Math.round(d4);
        long l3 = Math.round(d5);
        long l4 = Math.round(d6);
        double d7 = Math.abs((double)l2 - d4);
        double d8 = Math.abs((double)l3 - d5);
        double d9 = Math.abs((double)l4 - d6);
        if (d7 > d8 && d7 > d9) {
            l2 = -l3 - l4;
        } else if (d8 > d9) {
            l3 = -l2 - l4;
        } else {
            l4 = -l2 - l3;
        }
        return new GridPosition((int)l2, (int)l3);
    }
}

