/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.hexagon;

import io.fair_acc.chartfx.renderer.spi.hexagon.GridPosition;
import io.fair_acc.chartfx.renderer.spi.hexagon.Hexagon;
import io.fair_acc.chartfx.renderer.spi.hexagon.HexagonMap;
import io.fair_acc.chartfx.renderer.spi.hexagon.IPathInfoSupplier;
import io.fair_acc.chartfx.renderer.spi.hexagon.NoPathFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class GridCalculationsHelper {
    GridCalculationsHelper() {
    }

    private static Hexagon findHexagonWithLowestFscore(ArrayList<Hexagon> arrayList) {
        Hexagon hexagon = arrayList.get(0);
        int n2 = hexagon.aStarFscore;
        for (Hexagon hexagon2 : arrayList) {
            if (hexagon2.aStarFscore >= n2) continue;
            hexagon = hexagon2;
            n2 = hexagon2.aStarFscore;
        }
        return hexagon;
    }

    public static ArrayList<Hexagon> getHexagonsInRingArea(Hexagon hexagon, int n2, HexagonMap hexagonMap) {
        ArrayList<Hexagon> arrayList = new ArrayList<Hexagon>();
        for (GridPosition gridPosition : hexagon.position.getPositionsInCircleArea(n2)) {
            Hexagon hexagon2 = hexagonMap.getHexagon(gridPosition);
            if (hexagon2 == null) continue;
            arrayList.add(hexagon2);
        }
        return arrayList;
    }

    public static ArrayList<Hexagon> getHexagonsOnRingEdge(Hexagon hexagon, int n2, HexagonMap hexagonMap) {
        ArrayList<Hexagon> arrayList = new ArrayList<Hexagon>();
        for (GridPosition gridPosition : hexagon.position.getPositionsOnCircleEdge(n2)) {
            Hexagon hexagon2 = hexagonMap.getHexagon(gridPosition);
            if (hexagon2 == null) continue;
            arrayList.add(hexagon2);
        }
        return arrayList;
    }

    public static List<Hexagon> getLine(GridPosition gridPosition, GridPosition gridPosition2, HexagonMap hexagonMap) {
        ArrayList<Hexagon> arrayList = new ArrayList<Hexagon>();
        List<GridPosition> list = gridPosition.line(gridPosition2);
        for (GridPosition gridPosition3 : list) {
            Hexagon hexagon = hexagonMap.getHexagon(gridPosition3);
            if (hexagon == null) continue;
            arrayList.add(hexagon);
        }
        return arrayList;
    }

    public static ArrayList<Hexagon> getPathBetween(Hexagon hexagon, Hexagon hexagon2, IPathInfoSupplier iPathInfoSupplier) throws NoPathFoundException {
        ArrayList<Hexagon> arrayList = new ArrayList<Hexagon>();
        ArrayList<Hexagon> arrayList2 = new ArrayList<Hexagon>();
        arrayList2.add(hexagon);
        hexagon.aStarGscore = 0;
        hexagon.aStarFscore = hexagon.aStarGscore + GridPosition.getDistance(hexagon.position, hexagon2.position);
        while (!arrayList2.isEmpty()) {
            Hexagon hexagon3 = GridCalculationsHelper.findHexagonWithLowestFscore(arrayList2);
            if (hexagon3.position.equals(hexagon2.position)) {
                return GridCalculationsHelper.reconstructPath(hexagon, hexagon2);
            }
            arrayList2.remove((Object)hexagon3);
            arrayList.add(hexagon3);
            for (Hexagon hexagon4 : hexagon3.getNeighbours()) {
                if (iPathInfoSupplier.isBlockingPath(hexagon4) && !hexagon2.equals((Object)hexagon4) || arrayList.contains((Object)hexagon4)) continue;
                int n2 = hexagon3.aStarGscore + iPathInfoSupplier.getMovementCost(hexagon3, hexagon4);
                if (arrayList2.contains((Object)hexagon4) && n2 >= hexagon4.aStarGscore) continue;
                hexagon4.aStarCameFrom = hexagon3;
                hexagon4.aStarGscore = n2;
                hexagon4.aStarFscore = hexagon4.aStarGscore + GridPosition.getDistance(hexagon4.position, hexagon2.position);
                if (arrayList2.contains((Object)hexagon4)) continue;
                arrayList2.add(hexagon4);
            }
        }
        throw new NoPathFoundException("Can't find any path to the goal Hexagon");
    }

    public static List<Hexagon> getVisibleHexes(Hexagon hexagon, int n2, HexagonMap hexagonMap) {
        List<GridPosition> list = hexagon.position.getPositionsOnCircleEdge(n2);
        ArrayList<Hexagon> arrayList = new ArrayList<Hexagon>();
        block0: for (GridPosition gridPosition : list) {
            List<Hexagon> list2 = GridCalculationsHelper.getLine(hexagon.position, gridPosition, hexagonMap);
            for (Hexagon hexagon2 : list2) {
                arrayList.add(hexagon2);
                if (!hexagon2.isVisualObstacle()) continue;
                continue block0;
            }
        }
        return arrayList;
    }

    private static ArrayList<Hexagon> reconstructPath(Hexagon hexagon, Hexagon hexagon2) {
        ArrayList<Hexagon> arrayList = new ArrayList<Hexagon>();
        Hexagon hexagon3 = hexagon2;
        while (hexagon3 != hexagon) {
            arrayList.add(hexagon3);
            hexagon3 = hexagon3.aStarCameFrom;
        }
        Collections.reverse(arrayList);
        return arrayList;
    }
}

