/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.financial;

import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.FontMetrics;
import com.sun.javafx.tk.Toolkit;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.financial.AbstractFinancialRenderer;
import io.fair_acc.chartfx.renderer.spi.financial.FinancialDataSetNode;
import io.fair_acc.chartfx.renderer.spi.financial.service.OhlcvRendererEpData;
import io.fair_acc.chartfx.renderer.spi.financial.service.RendererPaintAfterEP;
import io.fair_acc.chartfx.renderer.spi.financial.service.RendererPaintAfterEPAware;
import io.fair_acc.chartfx.renderer.spi.financial.service.footprint.FootprintRendererAttributes;
import io.fair_acc.chartfx.renderer.spi.financial.service.footprint.NbColumnColorGroup;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.financial.api.attrs.AttributeModelAware;
import io.fair_acc.dataset.spi.financial.api.ohlcv.IOhlcvItem;
import io.fair_acc.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class FootprintRenderer
extends AbstractFinancialRenderer<FootprintRenderer>
implements Renderer,
RendererPaintAfterEPAware {
    private static final double FONT_RATIO = 13.0;
    private final boolean paintVolume;
    private final boolean paintPoc;
    private final boolean paintPullbackColumn;
    private final AbstractFinancialRenderer.FindAreaDistances findAreaDistances;
    private final IFootprintRenderedAPI footprintRenderedApi;
    private final FootprintRendererAttributes footprintAttrs;
    private final FontLoader fontLoader;
    private AttributeModelAware attrs;
    private IOhlcvItemAware itemAware;
    private boolean isEpAvailable;
    private Paint pocColor;
    private Paint footprintDefaultFontColor;
    private Paint footprintCrossLineColor;
    private Paint footprintBoxLongColor;
    private Paint fooprintBoxShortColor;
    private Paint footprintVolumeLongColor;
    private Paint footprintVolumeShortColor;
    private double[] distances;
    private int iMin;
    private int iMax;
    private double localBarWidth;
    private double barWidthHalf;
    private double ratio;
    private Font basicFont;
    private Font selectedFont;
    private double fontGap;
    private double basicGap;
    private float heightText;
    protected List<RendererPaintAfterEP> paintAfterEPS = new ArrayList<RendererPaintAfterEP>();

    public FootprintRenderer(IFootprintRenderedAPI iFootprintRenderedAPI, boolean bl2, boolean bl3, boolean bl4) {
        StyleUtil.addStyles(this, "footprint");
        this.footprintRenderedApi = iFootprintRenderedAPI;
        this.footprintAttrs = iFootprintRenderedAPI.getFootprintAttributes();
        this.paintVolume = bl2;
        this.paintPoc = bl3;
        this.paintPullbackColumn = bl4;
        this.findAreaDistances = bl2 ? new AbstractFinancialRenderer.XMinVolumeMaxAreaDistances() : new AbstractFinancialRenderer.XMinAreaDistances();
        this.fontLoader = Toolkit.getToolkit().getFontLoader();
    }

    public FootprintRenderer(IFootprintRenderedAPI iFootprintRenderedAPI) {
        this(iFootprintRenderedAPI, false, true, true);
    }

    public boolean isPaintVolume() {
        return this.paintVolume;
    }

    public boolean isPaintPoc() {
        return this.paintPoc;
    }

    public boolean isPaintPullbackColumn() {
        return this.paintPullbackColumn;
    }

    @Override
    public boolean drawLegendSymbol(DataSetNode dataSetNode, Canvas canvas) {
        int n2 = (int)canvas.getWidth();
        int n3 = (int)canvas.getHeight();
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.save();
        FinancialDataSetNode financialDataSetNode = (FinancialDataSetNode)dataSetNode;
        Paint paint = financialDataSetNode.getCandleLongColor();
        Paint paint2 = financialDataSetNode.getCandleShortColor();
        graphicsContext.setFill(paint);
        graphicsContext.setStroke(paint);
        graphicsContext.fillRect(1.0, 3.0, (double)n2 / 2.0 - 2.0, (double)n3 - 8.0);
        double d2 = (double)n2 / 4.0;
        graphicsContext.strokeLine(d2, 1.0, d2, (double)n3 - 2.0);
        graphicsContext.setFill(paint2);
        graphicsContext.setStroke(paint2);
        graphicsContext.fillRect((double)n2 / 2.0 + 2.0, 4.0, (double)n2 - 2.0, (double)n3 - 12.0);
        d2 = 3.0 * (double)n2 / 4.0 + 1.5;
        graphicsContext.strokeLine(d2, 1.0, d2, (double)n3 - 3.0);
        graphicsContext.restore();
        return true;
    }

    @Override
    protected FootprintRenderer getThis() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (dataSet.getDimension() < 7) {
            return;
        }
        this.attrs = null;
        if (dataSet instanceof AttributeModelAware) {
            this.attrs = (AttributeModelAware)((Object)dataSet);
        }
        this.itemAware = (IOhlcvItemAware)((Object)dataSet);
        this.isEpAvailable = !this.paintAfterEPS.isEmpty() || this.paintBarMarker != null;
        graphicsContext.save();
        FinancialDataSetNode financialDataSetNode = (FinancialDataSetNode)dataSetNode;
        graphicsContext.setLineWidth(financialDataSetNode.getLineWidth());
        graphicsContext.setLineDashes(financialDataSetNode.getLineDashes());
        Font font = this.footprintAttrs.getRequiredAttribute(FootprintRendererAttributes.BID_ASK_VOLUME_FONTS)[1];
        Font font2 = this.footprintAttrs.getRequiredAttribute(FootprintRendererAttributes.BID_ASK_VOLUME_FONTS)[2];
        this.pocColor = financialDataSetNode.getFootprintPocColor();
        this.footprintDefaultFontColor = financialDataSetNode.getFootprintDefaultFontColor();
        this.footprintCrossLineColor = financialDataSetNode.getFootprintCrossLineColor();
        this.footprintBoxLongColor = financialDataSetNode.getFootprintLongColor();
        this.fooprintBoxShortColor = financialDataSetNode.getFootprintShortColor();
        this.footprintVolumeLongColor = financialDataSetNode.getFootprintVolumeLongColor();
        this.footprintVolumeShortColor = financialDataSetNode.getFootprintVolumeShortColor();
        double d2 = financialDataSetNode.getBarWidthPercent();
        double d3 = financialDataSetNode.getPositionPaintMainRatio();
        if (dataSet.getDataCount() > 0) {
            this.iMin = dataSet.getIndex(0, this.xMin);
            if (this.iMin < 0) {
                this.iMin = 0;
            }
            this.iMax = Math.min(dataSet.getIndex(0, this.xMax) + 1, dataSet.getDataCount());
            this.distances = null;
            double d4 = 0.0;
            if (dataSetNode.getLocalIndex() == 0) {
                this.distances = this.findAreaDistances(this.findAreaDistances, dataSet, this.xAxis, this.yAxis, this.xMin, this.xMax);
                d4 = this.distances[0];
            }
            this.localBarWidth = d4 * d2;
            this.barWidthHalf = this.localBarWidth / 2.0;
            this.ratio = Math.pow(this.localBarWidth, 0.25) * d3;
            this.basicFont = this.getFontWithRatio(font, this.ratio);
            this.selectedFont = this.getFontWithRatio(font2, this.ratio);
            this.fontGap = this.getFontGap(5.0, this.ratio);
            this.basicGap = this.getFontGap(1.0, this.ratio);
            FontMetrics fontMetrics = this.getFontMetrics(this.basicFont);
            this.heightText = fontMetrics.getLeading() + fontMetrics.getAscent();
            for (int i2 = this.iMin; i2 < this.iMax; ++i2) {
                boolean bl2;
                double d5 = this.xAxis.getDisplayPosition(dataSet.get(0, i2));
                IOhlcvItem iOhlcvItem = this.itemAware.getItem(i2);
                IOhlcvItem iOhlcvItem2 = this.itemAware.getLastItem();
                boolean bl3 = bl2 = iOhlcvItem2 == null || iOhlcvItem2.getTimeStamp().equals(iOhlcvItem.getTimeStamp());
                if (!this.footprintRenderedApi.isFootprintAvailable(iOhlcvItem)) continue;
                Object object = this.footprintRenderedApi.getLock(iOhlcvItem);
                synchronized (object) {
                    IOhlcvItem iOhlcvItem3;
                    this.drawFootprintItem(graphicsContext, this.yAxis, financialDataSetNode, dataSet, i2, d5, iOhlcvItem, this.isEpAvailable, bl2, this.paintVolume);
                    if (bl2 && this.paintPullbackColumn && (iOhlcvItem3 = this.footprintRenderedApi.getPullbackColumn(iOhlcvItem)) != null) {
                        d5 = d5 + this.localBarWidth + this.barWidthHalf;
                        this.drawFootprintItem(graphicsContext, this.yAxis, financialDataSetNode, dataSet, i2, d5, iOhlcvItem3, false, true, false);
                    }
                    continue;
                }
            }
        }
        graphicsContext.restore();
        if (this.computeLocalRange()) {
            this.applyLocalYRange(dataSet, this.yAxis, this.xMin, this.xMax);
        }
    }

    private void drawFootprintItem(GraphicsContext graphicsContext, Axis axis, FinancialDataSetNode financialDataSetNode, DataSet dataSet, int n2, double d2, IOhlcvItem iOhlcvItem, boolean bl2, boolean bl3, boolean bl4) {
        double d3;
        double d4;
        double d5 = axis.getDisplayPosition(iOhlcvItem.getOpen());
        double d6 = axis.getDisplayPosition(iOhlcvItem.getHigh());
        double d7 = axis.getDisplayPosition(iOhlcvItem.getLow());
        double d8 = axis.getDisplayPosition(iOhlcvItem.getClose());
        double d9 = iOhlcvItem.getOpen();
        double d10 = iOhlcvItem.getClose();
        Collection<Double[]> collection = this.footprintRenderedApi.getPriceVolumeList(iOhlcvItem);
        double d11 = this.footprintRenderedApi.getPocPrice(iOhlcvItem);
        NbColumnColorGroup nbColumnColorGroup = this.footprintRenderedApi.getColumnColorGroup(iOhlcvItem);
        double d12 = d5 - d8;
        double d13 = d12 > 0.0 ? d8 : d5;
        OhlcvRendererEpData ohlcvRendererEpData = null;
        if (bl2) {
            ohlcvRendererEpData = new OhlcvRendererEpData();
            ohlcvRendererEpData.gc = graphicsContext;
            ohlcvRendererEpData.ds = dataSet;
            ohlcvRendererEpData.style = financialDataSetNode;
            ohlcvRendererEpData.attrs = this.attrs;
            ohlcvRendererEpData.ohlcvItemAware = this.itemAware;
            ohlcvRendererEpData.ohlcvItem = iOhlcvItem;
            ohlcvRendererEpData.index = n2;
            ohlcvRendererEpData.minIndex = this.iMin;
            ohlcvRendererEpData.maxIndex = this.iMax;
            ohlcvRendererEpData.barWidth = this.localBarWidth;
            ohlcvRendererEpData.barWidthHalf = this.barWidthHalf;
            ohlcvRendererEpData.xCenter = d2;
            ohlcvRendererEpData.yOpen = d5;
            ohlcvRendererEpData.yHigh = d6;
            ohlcvRendererEpData.yLow = d7;
            ohlcvRendererEpData.yClose = d8;
            ohlcvRendererEpData.yDiff = d12;
            ohlcvRendererEpData.yMin = d13;
        }
        if (bl4) {
            assert (this.distances != null);
            this.paintVolume(graphicsContext, dataSet, n2, this.footprintVolumeLongColor, this.footprintVolumeShortColor, axis, this.distances, this.localBarWidth, this.barWidthHalf, d2);
        }
        Paint paint = null;
        if (ohlcvRendererEpData != null) {
            paint = this.getPaintBarColor(ohlcvRendererEpData);
        }
        graphicsContext.setStroke(this.footprintCrossLineColor);
        graphicsContext.strokeLine(d2, d6 - (double)this.heightText / 2.0, d2, d7 + (double)this.heightText / 2.0);
        double d14 = -1.7976931348623157E308;
        for (Double[] doubleArray : collection) {
            double d15;
            d4 = doubleArray[0];
            d3 = doubleArray[1];
            double d16 = doubleArray[2];
            boolean bl5 = bl3 && d4 == d10;
            double d17 = Utils.computeTextWidth((Font)this.basicFont, (String)this.getFormattedVolume(d3), (double)0.0);
            double d18 = Utils.computeTextWidth((Font)this.selectedFont, (String)this.getFormattedVolume(d3), (double)0.0);
            double d19 = Utils.computeTextWidth((Font)this.basicFont, (String)this.getFormattedVolume(d16), (double)0.0);
            double d20 = Utils.computeTextWidth((Font)this.selectedFont, (String)this.getFormattedVolume(d16), (double)0.0);
            double d21 = bl5 ? d18 : d17;
            double d22 = d15 = bl5 ? d20 : d19;
            if (d17 > d14) {
                d14 = d17;
            }
            double d23 = d2 - d21 - this.fontGap;
            double d24 = d2 + this.fontGap;
            double d25 = axis.getDisplayPosition(d4) + (double)this.heightText / 2.0;
            if (this.paintPoc && d4 == d11) {
                graphicsContext.setStroke(this.pocColor);
                graphicsContext.setLineCap(StrokeLineCap.BUTT);
                graphicsContext.setLineJoin(StrokeLineJoin.MITER);
                graphicsContext.setMiterLimit(10.0);
                graphicsContext.setLineWidth(1.5);
                graphicsContext.strokeRect(d2 - d21 - this.fontGap - 2.0 * this.basicGap, d25 - (double)this.heightText - this.basicGap, d21 + d15 + 2.0 * this.fontGap + 2.0 * this.basicGap, (double)this.heightText + 4.0 * this.basicGap);
            }
            if (nbColumnColorGroup != null) {
                NbColumnColorGroup.FontColor fontColor = nbColumnColorGroup.fontColorMap.get(d4);
                graphicsContext.setFont(bl5 ? this.selectedFont : fontColor.bidFont);
                graphicsContext.setFont(new Font(this.calcFontSize(graphicsContext.getFont().getSize(), this.ratio)));
                graphicsContext.setFill((Paint)fontColor.bidColor);
                graphicsContext.fillText(this.getFormattedVolume(d3), d23, d25);
                graphicsContext.setFont(bl5 ? this.selectedFont : fontColor.askFont);
                graphicsContext.setFont(new Font(this.calcFontSize(graphicsContext.getFont().getSize(), this.ratio)));
                graphicsContext.setFill((Paint)fontColor.askColor);
                graphicsContext.fillText(this.getFormattedVolume(d16), d24, d25);
                continue;
            }
            graphicsContext.setFont(bl5 ? this.selectedFont : this.basicFont);
            graphicsContext.setFill(this.footprintDefaultFontColor);
            graphicsContext.fillText(this.getFormattedVolume(d3), d23, d25);
            graphicsContext.fillText(this.getFormattedVolume(d16), d24, d25);
        }
        for (Double[] doubleArray : collection) {
            d4 = doubleArray[0];
            d3 = axis.getDisplayPosition(d4) + (double)this.heightText / 2.0;
            if (!(d10 > d9 && d4 >= d9 && d4 <= d10) && (!(d10 <= d9) || !(d4 <= d9) || !(d4 >= d10))) continue;
            graphicsContext.setLineWidth(1.0);
            if (d10 > d9) {
                if (paint != null) {
                    graphicsContext.setFill(paint);
                } else {
                    graphicsContext.setFill(this.footprintBoxLongColor);
                }
            } else if (paint != null) {
                graphicsContext.setFill(paint);
            } else {
                graphicsContext.setFill(this.fooprintBoxShortColor);
            }
            graphicsContext.fillRect(d2 - d14 - this.fontGap - 10.0 * this.basicGap, d3 - (double)this.heightText, 4.0 * this.basicGap, (double)this.heightText);
        }
        if (bl2) {
            EpDataAddon epDataAddon = new EpDataAddon();
            epDataAddon.basicGap = this.basicGap;
            epDataAddon.fontGap = this.fontGap;
            epDataAddon.heightText = this.heightText;
            epDataAddon.maxWidthTextBid = d14;
            ohlcvRendererEpData.addon = epDataAddon;
            this.paintAfter(ohlcvRendererEpData);
        }
    }

    private String getFormattedVolume(double d2) {
        return String.format("%1.0f", d2);
    }

    private Font getFontWithRatio(Font font, double d2) {
        return Font.font((String)font.getFamily(), (FontWeight)FontWeight.findByName((String)font.getStyle()), (double)this.calcFontSize(font.getSize(), d2));
    }

    private double calcFontSize(double d2, double d3) {
        return d2 / 13.0 * d3;
    }

    private double getFontGap(double d2, double d3) {
        return d2 / 13.0 * d3;
    }

    private FontMetrics getFontMetrics(Font font) {
        return this.fontLoader.getFontMetrics(font);
    }

    protected void paintAfter(OhlcvRendererEpData ohlcvRendererEpData) {
        for (RendererPaintAfterEP rendererPaintAfterEP : this.paintAfterEPS) {
            rendererPaintAfterEP.paintAfter(ohlcvRendererEpData);
        }
    }

    @Override
    public void addPaintAfterEp(RendererPaintAfterEP rendererPaintAfterEP) {
        this.paintAfterEPS.add(rendererPaintAfterEP);
    }

    @Override
    public List<RendererPaintAfterEP> getPaintAfterEps() {
        return this.paintAfterEPS;
    }

    public static interface IFootprintRenderedAPI {
        public boolean isFootprintAvailable(IOhlcvItem var1);

        public FootprintRendererAttributes getFootprintAttributes();

        public Collection<Double[]> getPriceVolumeList(IOhlcvItem var1);

        public double getPocPrice(IOhlcvItem var1);

        public NbColumnColorGroup getColumnColorGroup(IOhlcvItem var1);

        public IOhlcvItem getPullbackColumn(IOhlcvItem var1);

        public Object getLock(IOhlcvItem var1);
    }

    public static class EpDataAddon {
        public double heightText;
        public double fontGap;
        public double basicGap;
        public double maxWidthTextBid;
    }
}

