/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.financial;

import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.financial.AbstractFinancialRenderer;
import io.fair_acc.chartfx.renderer.spi.financial.FinancialDataSetNode;
import io.fair_acc.chartfx.renderer.spi.financial.service.OhlcvRendererEpData;
import io.fair_acc.chartfx.renderer.spi.financial.service.RendererPaintAfterEP;
import io.fair_acc.chartfx.renderer.spi.financial.service.RendererPaintAfterEPAware;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.financial.api.attrs.AttributeModelAware;
import io.fair_acc.dataset.spi.financial.api.ohlcv.IOhlcvItemAware;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;

public class CandleStickRenderer
extends AbstractFinancialRenderer<CandleStickRenderer>
implements Renderer,
RendererPaintAfterEPAware {
    private final boolean paintVolume;
    private final AbstractFinancialRenderer.FindAreaDistances findAreaDistances;
    protected final List<RendererPaintAfterEP> paintAfterEPS = new ArrayList<RendererPaintAfterEP>();

    public CandleStickRenderer(boolean bl2) {
        StyleUtil.addStyles(this, "candlestick");
        this.paintVolume = bl2;
        this.findAreaDistances = bl2 ? new AbstractFinancialRenderer.XMinVolumeMaxAreaDistances() : new AbstractFinancialRenderer.XMinAreaDistances();
    }

    public CandleStickRenderer() {
        this(false);
    }

    public boolean isPaintVolume() {
        return this.paintVolume;
    }

    @Override
    public boolean drawLegendSymbol(DataSetNode dataSetNode, Canvas canvas) {
        int n2 = (int)canvas.getWidth();
        int n3 = (int)canvas.getHeight();
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.save();
        FinancialDataSetNode financialDataSetNode = (FinancialDataSetNode)dataSetNode;
        Paint paint = financialDataSetNode.getCandleLongColor();
        Paint paint2 = financialDataSetNode.getCandleShortColor();
        graphicsContext.setFill(paint);
        graphicsContext.setStroke(paint);
        graphicsContext.fillRect(1.0, 3.0, (double)n2 / 2.0 - 2.0, (double)n3 - 8.0);
        double d2 = (double)n2 / 4.0;
        graphicsContext.strokeLine(d2, 1.0, d2, (double)n3 - 2.0);
        graphicsContext.setFill(paint2);
        graphicsContext.setStroke(paint2);
        graphicsContext.fillRect((double)n2 / 2.0 + 2.0, 4.0, (double)n2 - 2.0, (double)n3 - 12.0);
        d2 = 3.0 * (double)n2 / 4.0 + 1.5;
        graphicsContext.strokeLine(d2, 1.0, d2, (double)n3 - 3.0);
        graphicsContext.restore();
        return true;
    }

    @Override
    protected CandleStickRenderer getThis() {
        return this;
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (dataSet.getDimension() < 7) {
            return;
        }
        AttributeModelAware attributeModelAware = null;
        if (dataSet instanceof AttributeModelAware) {
            attributeModelAware = (AttributeModelAware)((Object)dataSet);
        }
        IOhlcvItemAware iOhlcvItemAware = null;
        if (dataSet instanceof IOhlcvItemAware) {
            iOhlcvItemAware = (IOhlcvItemAware)((Object)dataSet);
        }
        boolean bl2 = !this.paintAfterEPS.isEmpty() || this.paintBarMarker != null;
        graphicsContext.save();
        FinancialDataSetNode financialDataSetNode = (FinancialDataSetNode)dataSetNode;
        graphicsContext.setLineWidth(financialDataSetNode.getLineWidth());
        graphicsContext.setLineDashes(financialDataSetNode.getLineDashes());
        Paint paint = financialDataSetNode.getCandleLongColor();
        Paint paint2 = financialDataSetNode.getCandleShortColor();
        Paint paint3 = financialDataSetNode.getCandleLongWickColor();
        Paint paint4 = financialDataSetNode.getCandleShortWickColor();
        Paint paint5 = financialDataSetNode.getCandleShadowColor();
        Paint paint6 = financialDataSetNode.getCandleVolumeLongColor();
        Paint paint7 = financialDataSetNode.getCandleVolumeShortColor();
        double d2 = financialDataSetNode.getBarWidthPercent();
        double d3 = financialDataSetNode.getShadowLineWidth();
        double d4 = financialDataSetNode.getShadowTransPercent();
        if (dataSet.getDataCount() > 0) {
            int n2 = dataSet.getIndex(0, this.xMin);
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = Math.min(dataSet.getIndex(0, this.xMax) + 1, dataSet.getDataCount());
            double[] dArray = null;
            double d5 = 0.0;
            if (dataSetNode.getLocalIndex() == 0) {
                dArray = this.findAreaDistances(this.findAreaDistances, dataSet, this.xAxis, this.yAxis, this.xMin, this.xMax);
                d5 = dArray[0];
            }
            double d6 = d5 * d2;
            double d7 = d6 / 2.0;
            for (int i2 = n2; i2 < n3; ++i2) {
                Paint paint8;
                double d8 = this.xAxis.getDisplayPosition(dataSet.get(0, i2));
                double d9 = this.yAxis.getDisplayPosition(dataSet.get(1, i2));
                double d10 = this.yAxis.getDisplayPosition(dataSet.get(2, i2));
                double d11 = this.yAxis.getDisplayPosition(dataSet.get(3, i2));
                double d12 = this.yAxis.getDisplayPosition(dataSet.get(4, i2));
                double d13 = d9 - d12;
                double d14 = d13 > 0.0 ? d12 : d9;
                OhlcvRendererEpData ohlcvRendererEpData = null;
                if (bl2) {
                    ohlcvRendererEpData = new OhlcvRendererEpData();
                    ohlcvRendererEpData.gc = graphicsContext;
                    ohlcvRendererEpData.ds = dataSet;
                    ohlcvRendererEpData.style = financialDataSetNode;
                    ohlcvRendererEpData.attrs = attributeModelAware;
                    ohlcvRendererEpData.ohlcvItemAware = iOhlcvItemAware;
                    ohlcvRendererEpData.ohlcvItem = iOhlcvItemAware != null ? iOhlcvItemAware.getItem(i2) : null;
                    ohlcvRendererEpData.index = i2;
                    ohlcvRendererEpData.minIndex = n2;
                    ohlcvRendererEpData.maxIndex = n3;
                    ohlcvRendererEpData.barWidth = d6;
                    ohlcvRendererEpData.barWidthHalf = d7;
                    ohlcvRendererEpData.xCenter = d8;
                    ohlcvRendererEpData.yOpen = d9;
                    ohlcvRendererEpData.yHigh = d10;
                    ohlcvRendererEpData.yLow = d11;
                    ohlcvRendererEpData.yClose = d12;
                    ohlcvRendererEpData.yDiff = d13;
                    ohlcvRendererEpData.yMin = d14;
                }
                if (this.paintVolume) {
                    assert (dArray != null);
                    this.paintVolume(graphicsContext, dataSet, i2, paint6, paint7, this.yAxis, dArray, d6, d7, d8);
                }
                if (paint5 != null) {
                    double d15 = graphicsContext.getLineWidth();
                    this.paintCandleShadow(graphicsContext, paint5, d3, d4, d6, d7, d8, d9, d12, d11, d10, d13, d14);
                    graphicsContext.setLineWidth(d15);
                }
                Paint paint9 = paint8 = ohlcvRendererEpData == null ? null : this.getPaintBarColor(ohlcvRendererEpData);
                if (d13 > 0.0) {
                    graphicsContext.setFill(Objects.requireNonNullElse(paint8, paint));
                    graphicsContext.setStroke(Objects.requireNonNullElse(paint8, paint3));
                } else {
                    d13 = Math.abs(d13);
                    graphicsContext.setFill(Objects.requireNonNullElse(paint8, paint2));
                    graphicsContext.setStroke(Objects.requireNonNullElse(paint8, paint4));
                }
                graphicsContext.strokeLine(d8, d11, d8, d13 > 0.0 ? d9 : d12);
                graphicsContext.strokeLine(d8, d10, d8, d13 > 0.0 ? d12 : d9);
                graphicsContext.fillRect(d8 - d7, d14, d6, d13);
                graphicsContext.strokeRect(d8 - d7, d14, d6, d13);
                if (this.paintAfterEPS.isEmpty()) continue;
                this.paintAfter(ohlcvRendererEpData);
            }
        }
        graphicsContext.restore();
        if (this.computeLocalRange()) {
            this.applyLocalYRange(dataSet, this.yAxis, this.xMin, this.xMax);
        }
    }

    protected void paintAfter(OhlcvRendererEpData ohlcvRendererEpData) {
        for (RendererPaintAfterEP rendererPaintAfterEP : this.paintAfterEPS) {
            rendererPaintAfterEP.paintAfter(ohlcvRendererEpData);
        }
    }

    protected void paintCandleShadow(GraphicsContext graphicsContext, Paint paint, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        double d13 = d3 * d5;
        graphicsContext.setLineWidth(d2);
        graphicsContext.setFill(paint);
        graphicsContext.setStroke(paint);
        graphicsContext.strokeLine(d6 + d13, d9 + d13, d6 + d13, d11 > 0.0 ? d7 + d13 : d8 + d13);
        graphicsContext.strokeLine(d6 + d13, d10 + d13, d6 + d13, d11 > 0.0 ? d8 + d13 : d7 + d13);
        graphicsContext.fillRect(d6 - d5 + d13, d12 + d13, d4, Math.abs(d11));
    }

    @Override
    public void addPaintAfterEp(RendererPaintAfterEP rendererPaintAfterEP) {
        this.paintAfterEPS.add(rendererPaintAfterEP);
    }

    @Override
    public List<RendererPaintAfterEP> getPaintAfterEps() {
        return this.paintAfterEPS;
    }
}

