/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.AbstractMetaDataRendererParameter;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetMetaData;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class MetaDataRenderer
extends AbstractMetaDataRendererParameter<MetaDataRenderer>
implements Renderer {
    protected BorderPane borderPane = new BorderPane();
    protected FlowPane messageBox = new FlowPane();
    protected HBox infoBox = new InfoHBox();
    protected HBox warningBox = new InfoHBox();
    protected HBox errorBox = new InfoHBox();
    protected final ObservableList<Axis> axesList = FXCollections.observableArrayList();
    protected Chart chart;
    protected List<String> oldInfoMessages;
    protected List<String> oldWarningMessages;
    protected List<String> oldErrorMessages;
    protected final BooleanProperty drawOnCanvas = new SimpleBooleanProperty(this, "drawOnCanvas", true){
        boolean oldValue;
        {
            this.oldValue = true;
        }

        public void set(boolean bl2) {
            if (this.oldValue == bl2) {
                return;
            }
            super.set(bl2);
            this.oldValue = bl2;
            MetaDataRenderer.this.updateInfoBoxLocation();
        }
    };
    protected final ObjectProperty<Side> infoBoxSide = new SimpleObjectProperty<Side>((Object)this, "infoBoxSide", Side.TOP){
        Side oldSide;
        {
            this.oldSide = null;
        }

        public void set(Side side) {
            if (side == null) {
                throw new InvalidParameterException("side must not be null");
            }
            if (this.oldSide != null && this.oldSide == side) {
                return;
            }
            super.set((Object)side);
            this.oldSide = side;
            MetaDataRenderer.this.updateInfoBoxLocation();
        }
    };

    public MetaDataRenderer(Chart chart) {
        this.chart = chart;
        this.updateCSS();
        this.messageBox.getChildren().addAll((Object[])new Node[]{this.errorBox, this.warningBox, this.infoBox});
        this.messageBox.setMouseTransparent(true);
        this.messageBox.setPrefWidth(1000.0);
        this.messageBox.setCache(true);
        chart.getCanvasForeground().getChildren().add((Object)this.borderPane);
        ChangeListener changeListener = (observableValue, number, number2) -> this.borderPane.setPrefSize(chart.getCanvasForeground().getWidth(), chart.getCanvas().getHeight());
        chart.getCanvas().widthProperty().addListener(changeListener);
        chart.getCanvas().heightProperty().addListener(changeListener);
        this.setInfoBoxSide(Side.TOP);
    }

    public BooleanProperty drawOnCanvasProperty() {
        return this.drawOnCanvas;
    }

    private List<String> extractMessages(List<DataSet> list, boolean bl2, MsgType msgType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DataSet dataSet : list) {
            if (!(dataSet instanceof DataSetMetaData)) continue;
            String string = dataSet.getName();
            DataSetMetaData dataSetMetaData = (DataSetMetaData)((Object)dataSet);
            for (String string2 : switch (msgType) {
                case MsgType.ERROR -> dataSetMetaData.getErrorList();
                case MsgType.WARNING -> dataSetMetaData.getWarningList();
                default -> dataSetMetaData.getInfoList();
            }) {
                if (bl2) {
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(string2 + " (" + string + ")");
            }
        }
        return arrayList;
    }

    @Override
    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    public BorderPane getBorderPaneOnCanvas() {
        return this.borderPane;
    }

    @Override
    public ObservableList<DataSet> getDatasets() {
        return FXCollections.observableArrayList();
    }

    @Override
    public ObservableList<DataSetNode> getDatasetNodes() {
        return FXCollections.emptyObservableList();
    }

    @Override
    public void updateAxisRange(Axis axis, AxisRange axisRange) {
    }

    protected List<DataSet> getDataSetsWithMetaData(List<DataSet> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSet dataSet : list) {
            if (!(dataSet instanceof DataSetMetaData)) continue;
            arrayList.add(dataSet);
        }
        return arrayList;
    }

    public HBox getErrorBox() {
        return this.errorBox;
    }

    public HBox getInfoBox() {
        return this.infoBox;
    }

    public final Side getInfoBoxSide() {
        return (Side)((Object)this.infoBoxSideProperty().get());
    }

    public FlowPane getMessageBox() {
        return this.messageBox;
    }

    @Override
    protected MetaDataRenderer getThis() {
        return this;
    }

    public HBox getWarningBox() {
        return this.warningBox;
    }

    public final ObjectProperty<Side> infoBoxSideProperty() {
        return this.infoBoxSide;
    }

    public boolean isDrawOnCanvas() {
        return this.drawOnCanvas.get();
    }

    @Override
    public void render() {
        MetaLabel metaLabel;
        VBox vBox;
        ArrayList<String> arrayList;
        long l2 = ProcessingProfiler.getTimeStamp();
        ObservableList<DataSet> observableList = this.chart.getAllDatasets();
        boolean bl2 = observableList.size() <= 1;
        List<DataSet> list = this.getDataSetsWithMetaData((List<DataSet>)observableList);
        ArrayList<String> arrayList2 = this.isShowInfoMessages() ? this.extractMessages(list, bl2, MsgType.INFO) : new ArrayList<String>();
        ArrayList<String> arrayList3 = this.isShowWarningMessages() ? this.extractMessages(list, bl2, MsgType.WARNING) : new ArrayList<String>();
        List<String> list2 = arrayList = this.isShowErrorMessages() ? this.extractMessages(list, bl2, MsgType.ERROR) : new ArrayList<String>();
        if (!arrayList2.equals(this.oldInfoMessages)) {
            this.oldInfoMessages = arrayList2;
            this.infoBox.getChildren().clear();
            if (!arrayList2.isEmpty()) {
                vBox = new VBox();
                this.infoBox.getChildren().addAll((Object[])new Node[]{this.iconInfo, vBox});
                for (String string : arrayList2) {
                    metaLabel = new MetaLabel(string);
                    vBox.getChildren().add((Object)metaLabel);
                }
            }
        }
        if (!arrayList3.equals(this.oldWarningMessages)) {
            this.oldWarningMessages = arrayList3;
            this.warningBox.getChildren().clear();
            if (!arrayList3.isEmpty()) {
                vBox = new VBox();
                this.warningBox.getChildren().addAll((Object[])new Node[]{this.iconWarning, vBox});
                for (String string : arrayList3) {
                    metaLabel = new MetaLabel(string);
                    vBox.getChildren().add((Object)metaLabel);
                }
            }
        }
        if (!arrayList.equals(this.oldErrorMessages)) {
            this.oldErrorMessages = arrayList;
            if (!arrayList.isEmpty()) {
                vBox = new VBox();
                for (String string : arrayList) {
                    metaLabel = new MetaLabel(string);
                    vBox.getChildren().add((Object)metaLabel);
                }
                this.errorBox.getChildren().setAll((Object[])new Node[]{this.iconError, vBox});
            } else {
                this.errorBox.getChildren().clear();
            }
        }
        ProcessingProfiler.getTimeDiff(l2);
    }

    public void setDrawOnCanvas(boolean bl2) {
        this.drawOnCanvas.set(bl2);
    }

    public final MetaDataRenderer setInfoBoxSide(Side side) {
        this.infoBoxSideProperty().set((Object)side);
        return this.getThis();
    }

    @Override
    public Renderer setShowInLegend(boolean bl2) {
        return this.getThis();
    }

    @Override
    public boolean showInLegend() {
        return false;
    }

    @Override
    public BooleanProperty showInLegendProperty() {
        return null;
    }

    protected void updateInfoBoxLocation() {
        Side side = this.getInfoBoxSide();
        this.borderPane.getChildren().remove((Object)this.messageBox);
        this.chart.getTitleLegendPane().getChildren().remove((Object)this.messageBox);
        if (this.isDrawOnCanvas()) {
            switch (side) {
                case RIGHT: {
                    this.messageBox.setMaxWidth(300.0);
                    this.messageBox.setPrefWidth(200.0);
                    this.borderPane.setRight((Node)this.messageBox);
                    break;
                }
                case LEFT: {
                    this.messageBox.setMaxWidth(300.0);
                    this.messageBox.setPrefWidth(200.0);
                    this.borderPane.setLeft((Node)this.messageBox);
                    break;
                }
                case BOTTOM: {
                    this.messageBox.setPrefWidth(1000.0);
                    this.messageBox.setMaxWidth(2000.0);
                    this.borderPane.setBottom((Node)this.messageBox);
                    break;
                }
                default: {
                    this.messageBox.setMaxWidth(2000.0);
                    this.messageBox.setPrefWidth(1000.0);
                    this.borderPane.setTop((Node)this.messageBox);
                    break;
                }
            }
        } else {
            this.chart.getTitleLegendPane().addSide(side, (Node)this.messageBox, new Node[0]);
        }
    }

    static class InfoHBox
    extends HBox {
        public InfoHBox() {
            this.setMouseTransparent(true);
            this.getChildren().addListener(change -> {
                if (this.getChildren().isEmpty()) {
                    this.setMinWidth(0.0);
                    this.setSpacing(0.0);
                    this.setPadding(Insets.EMPTY);
                } else {
                    this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                    this.setMinWidth(200.0);
                    this.setSpacing(5.0);
                }
            });
        }
    }

    protected static enum MsgType {
        INFO,
        WARNING,
        ERROR;

    }

    protected static class MetaLabel
    extends Label {
        public MetaLabel(String string) {
            super(string);
            this.setMouseTransparent(true);
            this.setMinSize(100.0, 20.0);
            this.setCache(true);
        }
    }
}

