/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.LineStyle;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.AbstractErrorDataSetRendererParameter;
import io.fair_acc.chartfx.renderer.spi.utils.BezierCurve;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.DataSetStyleParser;
import io.fair_acc.chartfx.utils.FastDoubleArrayCache;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.Histogram;
import io.fair_acc.dataset.spi.LimitedIndexedTreeDataSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;

public class HistogramRenderer
extends AbstractErrorDataSetRendererParameter<HistogramRenderer>
implements Renderer {
    private final BooleanProperty animate = new SimpleBooleanProperty((Object)this, "animate", false);
    private final BooleanProperty autoSorting = new SimpleBooleanProperty((Object)this, "autoSorting", true);
    private final BooleanProperty roundedCorner = new SimpleBooleanProperty((Object)this, "roundedCorner", true);
    private final IntegerProperty roundedCornerRadius = new SimpleIntegerProperty((Object)this, "roundedCornerRadius", 10);
    private final Map<String, Double> scaling = new ConcurrentHashMap<String, Double>();
    private final AnimationTimer timer = new MyTimer();
    private final DataSetStyleParser styleParser = DataSetStyleParser.newInstance();
    private static final FastDoubleArrayCache SHARED_ARRAYS = new FastDoubleArrayCache(6);

    public HistogramRenderer() {
        this.setPolyLineStyle(LineStyle.HISTOGRAM_FILLED);
        PropUtil.runOnChange(this::invalidateCanvas, new ObservableValue[]{this.animate, this.autoSorting, this.roundedCorner, this.roundedCornerRadius});
    }

    public BooleanProperty animateProperty() {
        return this.animate;
    }

    public BooleanProperty autoSortingProperty() {
        return this.autoSorting;
    }

    @Override
    public boolean drawLegendSymbol(DataSetNode dataSetNode, Canvas canvas) {
        int n2 = (int)canvas.getWidth();
        int n3 = (int)canvas.getHeight();
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.save();
        graphicsContext.setLineWidth(dataSetNode.getLineWidth());
        graphicsContext.setLineDashes(dataSetNode.getLineDashes());
        graphicsContext.setStroke(dataSetNode.getLineColor());
        graphicsContext.setFill(dataSetNode.getLineFillPattern());
        double d2 = (double)n3 / 2.0;
        graphicsContext.fillRect(1.0, 1.0, (double)n2 - 2.0, (double)n3 - 2.0);
        graphicsContext.strokeLine(1.0, d2, (double)n2 - 2.0, d2);
        graphicsContext.restore();
        return true;
    }

    public int getRoundedCornerRadius() {
        return this.roundedCornerRadiusProperty().get();
    }

    public boolean isAnimate() {
        return this.animateProperty().get();
    }

    public boolean isAutoSorting() {
        return this.autoSortingProperty().get();
    }

    public boolean isRoundedCorner() {
        return this.roundedCornerProperty().get();
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (!(dataSet instanceof Histogram) && this.isAutoSorting() && !HistogramRenderer.isDataSetSorted(dataSet, 0) && !HistogramRenderer.isDataSetSorted(dataSet, 1)) {
            LimitedIndexedTreeDataSet limitedIndexedTreeDataSet = new LimitedIndexedTreeDataSet(dataSet.getName(), Integer.MAX_VALUE);
            dataSet = limitedIndexedTreeDataSet.set(dataSet);
        }
        this.drawHistograms(graphicsContext, dataSetNode, dataSet);
        this.drawBars(graphicsContext, dataSetNode, dataSet, true);
        if (this.isAnimate()) {
            this.timer.start();
        }
    }

    public BooleanProperty roundedCornerProperty() {
        return this.roundedCorner;
    }

    public IntegerProperty roundedCornerRadiusProperty() {
        return this.roundedCornerRadius;
    }

    public void setAnimate(boolean bl2) {
        this.animateProperty().set(bl2);
    }

    public void setAutoSorting(boolean bl2) {
        this.autoSortingProperty().set(bl2);
    }

    public void setRoundedCorner(boolean bl2) {
        this.roundedCornerProperty().set(bl2);
    }

    public void setRoundedCornerRadius(int n2) {
        this.roundedCornerRadius.set(n2);
    }

    protected void drawBars(GraphicsContext graphicsContext, DataSetNode dataSetNode, DataSet dataSet, boolean bl2) {
        if (!this.isDrawBars()) {
            return;
        }
        double d2 = this.isAnimate() ? this.scaling.getOrDefault(dataSet.getName(), 1.0) : 1.0;
        boolean bl3 = HistogramRenderer.isVerticalDataSet(dataSet);
        double d3 = this.getBarWidthPercentage();
        double d4 = this.getBarWidth();
        int n2 = bl3 ? 1 : 0;
        int n3 = bl3 ? 0 : 1;
        Axis axis = bl3 ? this.yAxis : this.xAxis;
        Axis axis2 = bl3 ? this.xAxis : this.yAxis;
        int n4 = Math.max(0, dataSet.getIndex(n2, Math.min(axis.getMin(), axis.getMax())));
        int n5 = Math.min(dataSet.getDataCount(), dataSet.getIndex(n2, Math.max(axis.getMin(), axis.getMax()) + 1.0));
        int n6 = Math.abs(n5 - n4);
        double d5 = HistogramRenderer.getAxisMin(this.xAxis, this.yAxis, !bl3);
        boolean bl4 = dataSet instanceof Histogram;
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        graphicsContext.setFill(dataSetNode.getLineColor());
        for (int i2 = 0; i2 < n6; ++i2) {
            double d6;
            int n7 = n4 + i2;
            double d7 = this.isAnimate() ? Math.max(0.0, Math.min(1.0, d2 - (double)n7)) : 1.0;
            double d8 = axis2.getDisplayPosition(d7 * dataSet.get(n3, n7));
            double d9 = axis.getDisplayPosition(dataSet.get(n2, n7));
            double d10 = axis.getDisplayPosition(HistogramRenderer.getBinStart(dataSet, n2, n7));
            double d11 = axis.getDisplayPosition(HistogramRenderer.getBinStop(dataSet, n2, n7));
            double d12 = Math.max((double)this.getDashSize(), Math.abs(d11 - d10) / (this.isShiftBar() ? (double)this.getDatasets().size() : 1.0));
            double d13 = d12 * d3 / 100.0;
            double d14 = d6 = this.isDynamicBarWidth() ? 0.5 * d13 : d4;
            double d15 = this.getDatasets().size() == 1 ? 0.0 : (this.isDynamicBarWidth() ? d12 : (double)this.getShiftBarOffset()) * ((double)dataSetNode.getLocalIndex() - 0.25 * (double)this.getDatasets().size());
            double d16 = this.isShiftBar() ? d15 : 0.0;
            double d17 = bl4 ? d10 : d9 - d6 - d16;
            double d18 = bl4 ? d11 : d9 + d6 - d16;
            double d19 = this.isRoundedCorner() ? Math.max(0.0, Math.min((double)this.getRoundedCornerRadius(), 0.5 * d13)) : 0.0;
            boolean bl5 = this.styleParser.tryParse(dataSet.getStyle(n7));
            if (bl5) {
                graphicsContext.save();
                this.styleParser.getLineWidth().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setLineWidth(arg_0));
                this.styleParser.getLineDashes().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setLineDashes(arg_0));
                this.styleParser.getLineColor().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setStroke(arg_0));
                this.styleParser.getLineColor().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setFill(arg_0));
            }
            this.drawBar(graphicsContext, d17, d5, d18, d8, d19, bl3, bl2);
            if (!bl5) continue;
            graphicsContext.restore();
        }
        graphicsContext.restore();
    }

    protected void drawHistograms(GraphicsContext graphicsContext, DataSetNode dataSetNode, DataSet dataSet) {
        switch (this.getPolyLineStyle()) {
            case NONE: {
                return;
            }
            case AREA: {
                HistogramRenderer.drawPolyLineLine(graphicsContext, dataSetNode, dataSet, this.xAxis, this.yAxis, true);
                break;
            }
            case ZERO_ORDER_HOLDER: 
            case STAIR_CASE: {
                HistogramRenderer.drawPolyLineStairCase(graphicsContext, dataSetNode, dataSet, this.xAxis, this.yAxis, false);
                break;
            }
            case HISTOGRAM: {
                HistogramRenderer.drawPolyLineHistogram(graphicsContext, dataSetNode, dataSet, this.xAxis, this.yAxis, false);
                break;
            }
            case HISTOGRAM_FILLED: {
                HistogramRenderer.drawPolyLineHistogram(graphicsContext, dataSetNode, dataSet, this.xAxis, this.yAxis, true);
                break;
            }
            case BEZIER_CURVE: {
                HistogramRenderer.drawPolyLineHistogramBezier(graphicsContext, dataSetNode, dataSet, this.xAxis, this.yAxis, true);
                break;
            }
            default: {
                HistogramRenderer.drawPolyLineLine(graphicsContext, dataSetNode, dataSet, this.xAxis, this.yAxis, false);
            }
        }
    }

    protected static void drawPolyLineHistogram(GraphicsContext graphicsContext, DataSetNode dataSetNode, DataSet dataSet, Axis axis, Axis axis2, boolean bl2) {
        if (dataSet.getDataCount() == 0) {
            return;
        }
        boolean bl3 = HistogramRenderer.isVerticalDataSet(dataSet);
        int n2 = bl3 ? 1 : 0;
        int n3 = bl3 ? 0 : 1;
        Axis axis3 = bl3 ? axis2 : axis;
        Axis axis4 = bl3 ? axis : axis2;
        int n4 = Math.max(0, dataSet.getIndex(n2, Math.min(axis3.getMin(), axis3.getMax())));
        int n5 = Math.min(dataSet.getDataCount(), dataSet.getIndex(n2, Math.max(axis3.getMin(), axis3.getMax()) + 1.0));
        int n6 = Math.abs(n5 - n4);
        double[] dArray = SHARED_ARRAYS.getArray(0, 2 * (n6 + 1));
        double[] dArray2 = SHARED_ARRAYS.getArray(1, 2 * (n6 + 1));
        double d2 = HistogramRenderer.getAxisMin(axis, axis2, !bl3);
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = n4 + i2;
            double d3 = axis4.getDisplayPosition(dataSet.get(n3, n7));
            double d4 = axis3.getDisplayPosition(HistogramRenderer.getBinStart(dataSet, n2, n7));
            double d5 = axis3.getDisplayPosition(HistogramRenderer.getBinStop(dataSet, n2, n7));
            dArray[2 * i2 + 1] = d4;
            dArray2[2 * i2 + 1] = d3;
            dArray[2 * i2 + 2] = d5;
            dArray2[2 * i2 + 2] = d3;
        }
        dArray[0] = dArray[1];
        dArray2[0] = d2;
        dArray[2 * (n6 + 1) - 1] = dArray[2 * (n6 + 1) - 2];
        dArray2[2 * (n6 + 1) - 1] = d2;
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        HistogramRenderer.drawPolygon(graphicsContext, dArray, dArray2, bl2, bl3, 2 * n6 + 2);
        graphicsContext.restore();
    }

    protected static void drawPolyLineHistogramBezier(GraphicsContext graphicsContext, DataSetNode dataSetNode, DataSet dataSet, Axis axis, Axis axis2, boolean bl2) {
        int n2;
        boolean bl3 = HistogramRenderer.isVerticalDataSet(dataSet);
        int n3 = bl3 ? 1 : 0;
        Axis axis3 = bl3 ? axis2 : axis;
        int n4 = Math.max(0, dataSet.getIndex(n3, Math.min(axis3.getMin(), axis3.getMax())));
        int n5 = Math.min(dataSet.getDataCount(), dataSet.getIndex(n3, Math.max(axis3.getMin(), axis3.getMax()) + 1.0));
        int n6 = Math.min(n4, n5);
        int n7 = Math.abs(n5 - n4);
        if (n7 <= 2) {
            HistogramRenderer.drawPolyLineLine(graphicsContext, dataSetNode, dataSet, axis, axis2, bl2);
            return;
        }
        double[] dArray = SHARED_ARRAYS.getArray(0, n7);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n7);
        double[] dArray3 = SHARED_ARRAYS.getArray(2, n7);
        double[] dArray4 = SHARED_ARRAYS.getArray(3, n7);
        double[] dArray5 = SHARED_ARRAYS.getArray(4, n7);
        double[] dArray6 = SHARED_ARRAYS.getArray(5, n7);
        for (n2 = 0; n2 < n7; ++n2) {
            dArray5[n2] = axis.getDisplayPosition(dataSet.get(0, n6 + n2));
            dArray6[n2] = axis2.getDisplayPosition(dataSet.get(1, n6 + n2));
        }
        BezierCurve.calcCurveControlPoints(dArray5, dArray6, dArray, dArray2, dArray3, dArray4, n7);
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        graphicsContext.beginPath();
        for (n2 = 0; n2 < n7 - 1; ++n2) {
            double d2 = dArray5[n2];
            double d3 = dArray5[n2 + 1];
            double d4 = dArray6[n2];
            double d5 = dArray6[n2 + 1];
            double d6 = dArray[n2];
            double d7 = dArray2[n2];
            double d8 = dArray3[n2];
            double d9 = dArray4[n2];
            graphicsContext.moveTo(d2, d4);
            graphicsContext.bezierCurveTo(d6, d7, d8, d9, d3, d5);
        }
        graphicsContext.moveTo(dArray5[n7 - 1], dArray6[n7 - 1]);
        graphicsContext.closePath();
        graphicsContext.stroke();
        graphicsContext.restore();
    }

    protected static void drawPolyLineLine(GraphicsContext graphicsContext, DataSetNode dataSetNode, DataSet dataSet, Axis axis, Axis axis2, boolean bl2) {
        boolean bl3 = HistogramRenderer.isVerticalDataSet(dataSet);
        int n2 = bl3 ? 1 : 0;
        Axis axis3 = bl3 ? axis2 : axis;
        int n3 = Math.max(0, dataSet.getIndex(n2, Math.min(axis3.getMin(), axis3.getMax())));
        int n4 = Math.min(dataSet.getDataCount(), dataSet.getIndex(n2, Math.max(axis3.getMin(), axis3.getMax()) + 1.0));
        int n5 = Math.abs(n4 - n3);
        if (n5 == 0) {
            return;
        }
        graphicsContext.save();
        graphicsContext.beginPath();
        double d2 = axis.getDisplayPosition(dataSet.get(0, n3));
        double d3 = axis2.getDisplayPosition(dataSet.get(1, n3));
        graphicsContext.moveTo(d2, d3);
        boolean bl4 = true;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = n3 + 1; i2 < n4; ++i2) {
            d2 = axis.getDisplayPosition(dataSet.get(0, i2));
            d3 = axis2.getDisplayPosition(dataSet.get(1, i2));
            if (Double.isFinite(d2) && Double.isFinite(d3)) {
                if (!bl4) {
                    graphicsContext.moveTo(d2, d3);
                    bl4 = true;
                    continue;
                }
                graphicsContext.lineTo(d2, d3);
                d4 = d2;
                d5 = d3;
                bl4 = true;
                continue;
            }
            bl4 = false;
        }
        graphicsContext.moveTo(d4, d5);
        graphicsContext.closePath();
        if (bl2) {
            graphicsContext.setFill(dataSetNode.getLineColor());
            graphicsContext.fill();
        } else {
            dataSetNode.applyLineStrokeStyle(graphicsContext);
            graphicsContext.stroke();
        }
        graphicsContext.restore();
    }

    protected static void drawPolyLineStairCase(GraphicsContext graphicsContext, DataSetNode dataSetNode, DataSet dataSet, Axis axis, Axis axis2, boolean bl2) {
        boolean bl3 = HistogramRenderer.isVerticalDataSet(dataSet);
        int n2 = bl3 ? 1 : 0;
        int n3 = bl3 ? 0 : 1;
        Axis axis3 = bl3 ? axis2 : axis;
        Axis axis4 = bl3 ? axis : axis2;
        int n4 = Math.max(0, dataSet.getIndex(n2, Math.min(axis3.getMin(), axis3.getMax())));
        int n5 = Math.min(dataSet.getDataCount(), dataSet.getIndex(n2, Math.max(axis3.getMin(), axis3.getMax()) + 1.0));
        int n6 = Math.min(n4, n5);
        int n7 = Math.abs(n5 - n4);
        double d2 = HistogramRenderer.getAxisMin(axis, axis2, !bl3);
        if (n7 <= 0) {
            HistogramRenderer.drawPolyLineLine(graphicsContext, dataSetNode, dataSet, axis, axis2, bl2);
            return;
        }
        double[] dArray = SHARED_ARRAYS.getArray(0, 2 * n7);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, 2 * n7);
        for (int i2 = 0; i2 < n7 - 1; ++i2) {
            int n8 = i2 + n6;
            dArray[2 * i2] = axis3.getDisplayPosition(dataSet.get(n2, n8));
            dArray2[2 * i2] = axis4.getDisplayPosition(dataSet.get(n3, n8));
            dArray[2 * i2 + 1] = axis3.getDisplayPosition(dataSet.get(n2, n8 + 1));
            dArray2[2 * i2 + 1] = dArray2[2 * i2];
        }
        dArray[2 * (n7 - 1)] = axis3.getDisplayPosition(dataSet.get(n2, n6 + n7 - 1));
        dArray2[2 * (n7 - 1)] = axis4.getDisplayPosition(dataSet.get(n3, n6 + n7 - 1));
        dArray[2 * n7 - 1] = axis3.getDisplayPosition(d2);
        dArray2[2 * n7 - 1] = dArray2[2 * (n7 - 1)];
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        HistogramRenderer.drawPolygon(graphicsContext, dArray, dArray2, bl2, bl3, 2 * n7);
        graphicsContext.restore();
    }

    protected static void drawPolygon(GraphicsContext graphicsContext, double[] dArray, double[] dArray2, boolean bl2, boolean bl3, int n2) {
        if (bl2) {
            graphicsContext.setFill(graphicsContext.getStroke());
            if (bl3) {
                graphicsContext.fillPolygon(dArray2, dArray, n2);
            } else {
                graphicsContext.fillPolygon(dArray, dArray2, n2);
            }
            return;
        }
        if (bl3) {
            graphicsContext.strokePolyline(dArray2, dArray, n2);
        } else {
            graphicsContext.strokePolyline(dArray, dArray2, n2);
        }
    }

    protected static double estimateHalfBinWidth(DataSet dataSet, int n2, int n3) {
        boolean bl2;
        int n4 = dataSet.getDataCount();
        if (n4 == 0) {
            return 0.5;
        }
        if (n4 == 1) {
            return 0.5 * Math.abs(dataSet.get(n2, 1) - dataSet.get(n2, 0));
        }
        double d2 = dataSet.get(n2, n3);
        double d3 = n3 - 1 >= 0 ? Math.abs(d2 - dataSet.get(n2, n3 - 1)) : -1.0;
        double d4 = n3 + 1 < n4 ? Math.abs(dataSet.get(n2, n3 + 1)) - d2 : -1.0;
        boolean bl3 = d3 < 0.0;
        boolean bl4 = bl2 = d4 < 0.0;
        if (bl3 && bl2) {
            return 0.5;
        }
        if (bl3 || bl2) {
            return 0.5 * Math.max(d3, d4);
        }
        return 0.5 * Math.min(d3, d4);
    }

    protected static double getBinStart(DataSet dataSet, int n2, int n3) {
        if (dataSet instanceof Histogram) {
            return ((Histogram)dataSet).getBinLimits(n2, Histogram.Boundary.LOWER, n3 + 1);
        }
        return dataSet.get(n2, n3) - HistogramRenderer.estimateHalfBinWidth(dataSet, n2, n3);
    }

    protected static double getBinStop(DataSet dataSet, int n2, int n3) {
        if (dataSet instanceof Histogram) {
            return ((Histogram)dataSet).getBinLimits(n2, Histogram.Boundary.UPPER, n3 + 1);
        }
        return dataSet.get(n2, n3) + HistogramRenderer.estimateHalfBinWidth(dataSet, n2, n3);
    }

    @Override
    protected HistogramRenderer getThis() {
        return this;
    }

    protected static boolean isDataSetSorted(DataSet dataSet, int n2) {
        if (dataSet.getDataCount() < 2) {
            return true;
        }
        double d2 = dataSet.get(n2, 0);
        for (int i2 = 1; i2 < dataSet.getDataCount(); ++i2) {
            double d3 = dataSet.get(n2, i2);
            if (d3 < d2) {
                return false;
            }
            d2 = d3;
        }
        return true;
    }

    protected static boolean isVerticalDataSet(DataSet dataSet) {
        if (dataSet instanceof Histogram) {
            Histogram histogram = (Histogram)dataSet;
            return histogram.getBinCount(0) == 0 && histogram.getBinCount(1) > 0;
        }
        boolean bl2 = HistogramRenderer.isDataSetSorted(dataSet, 0);
        boolean bl3 = HistogramRenderer.isDataSetSorted(dataSet, 1);
        if (bl2 && bl3) {
            return false;
        }
        return bl3;
    }

    private void drawBar(GraphicsContext graphicsContext, double d2, double d3, double d4, double d5, double d6, boolean bl2, boolean bl3) {
        double d7;
        double d8 = bl2 ? d3 : d2;
        double d9 = bl2 ? d5 : d4;
        double d10 = bl2 ? d2 : d3;
        double d11 = d7 = bl2 ? d4 : d5;
        if (bl3) {
            graphicsContext.fillRoundRect(Math.min(d8, d9), Math.min(d10, d7), Math.abs(d9 - d8), Math.abs(d7 - d10), d6, d6);
        } else {
            graphicsContext.strokeRoundRect(Math.min(d8, d9), Math.min(d10, d7), Math.abs(d9 - d8), Math.abs(d7 - d10), d6, d6);
        }
    }

    private static double getAxisMin(Axis axis, Axis axis2, boolean bl2) {
        double d2 = Math.min(axis.getMin(), axis.getMax());
        double d3 = Math.min(axis2.getMin(), axis2.getMax());
        if (bl2) {
            if (axis2.isLogAxis()) {
                return axis2.isInvertedAxis() ? 0.0 : axis2.getLength();
            }
            return axis2.isInvertedAxis() ? Math.max(axis2.getDisplayPosition(0.0), axis2.getDisplayPosition(d3)) : Math.min(axis2.getDisplayPosition(0.0), axis2.getDisplayPosition(d3));
        }
        if (axis.isLogAxis()) {
            return axis.isInvertedAxis() ? axis.getLength() : 0.0;
        }
        return axis2.isInvertedAxis() ? Math.min(axis.getDisplayPosition(0.0), axis.getDisplayPosition(d2)) : Math.max(axis.getDisplayPosition(0.0), axis.getDisplayPosition(d2));
    }

    public static void trimCache() {
        SHARED_ARRAYS.trim();
    }

    private class MyTimer
    extends AnimationTimer {
        private MyTimer() {
        }

        public void handle(long l2) {
            if (!HistogramRenderer.this.isAnimate()) {
                this.stop();
                return;
            }
            for (DataSet dataSet : HistogramRenderer.this.getDatasets()) {
                Double d2 = HistogramRenderer.this.scaling.put(dataSet.getName(), Math.min(HistogramRenderer.this.scaling.computeIfAbsent(dataSet.getName(), string -> 0.0) + 0.05, (double)dataSet.getDataCount() + 1.0));
                if (d2 == null || !(d2 < (double)dataSet.getDataCount() + 1.0)) continue;
                HistogramRenderer.this.invalidateCanvas();
            }
        }
    }
}

