/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.marker.Marker;
import io.fair_acc.chartfx.renderer.ErrorStyle;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.RendererDataReducer;
import io.fair_acc.chartfx.renderer.spi.AbstractErrorDataSetRendererParameter;
import io.fair_acc.chartfx.renderer.spi.CachedDataPoints;
import io.fair_acc.chartfx.renderer.spi.utils.BezierCurve;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.DataSetStyleParser;
import io.fair_acc.chartfx.utils.FastDoubleArrayCache;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorDataSetRenderer
extends AbstractErrorDataSetRendererParameter<ErrorDataSetRenderer>
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorDataSetRenderer.class);
    private final DataSetStyleParser styleParser = DataSetStyleParser.newInstance();
    private static final FastDoubleArrayCache SHARED_ARRAYS = new FastDoubleArrayCache(4);
    private static final CachedDataPoints SHARED_POINTS_CACHE = new CachedDataPoints();

    public ErrorDataSetRenderer() {
        this(3);
    }

    public ErrorDataSetRenderer(int n2) {
        this.setDashSize(n2);
    }

    @Override
    public boolean drawLegendSymbol(DataSetNode dataSetNode, Canvas canvas) {
        int n2 = (int)canvas.getWidth();
        int n3 = (int)canvas.getHeight();
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.save();
        graphicsContext.setLineWidth(dataSetNode.getLineWidth());
        graphicsContext.setLineDashes(dataSetNode.getLineDashes());
        graphicsContext.setStroke(dataSetNode.getLineColor());
        if (this.getErrorType() == ErrorStyle.ERRORBARS) {
            double d2 = (double)n2 / 2.0;
            double d3 = (double)n3 / 2.0;
            if (this.getDashSize() > 2) {
                graphicsContext.strokeLine(d2 - 1.0, 1.0, d2 + 1.0, 1.0);
                graphicsContext.strokeLine(d2 - 1.0, (double)n3 - 2.0, d2 + 1.0, (double)n3 - 2.0);
                graphicsContext.strokeLine(d2, 1.0, d2, (double)n3 - 2.0);
            }
            graphicsContext.strokeLine(1.0, d3, (double)n2, d3);
        } else if (this.getErrorType() == ErrorStyle.ERRORSURFACE || this.getErrorType() == ErrorStyle.ERRORCOMBO) {
            double d4 = (double)n3 / 2.0;
            graphicsContext.setFill(dataSetNode.getLineFillPattern());
            graphicsContext.fillRect(1.0, 1.0, (double)n2 - 2.0, (double)n3 - 2.0);
            graphicsContext.strokeLine(1.0, d4, (double)n2 - 2.0, d4);
        } else {
            double d5 = (double)n2 / 2.0;
            double d6 = (double)n3 / 2.0;
            if (this.getDashSize() > 2) {
                graphicsContext.strokeLine(d5 - 1.0, 1.0, d5 + 1.0, 1.0);
                graphicsContext.strokeLine(d5 - 1.0, (double)n3 - 2.0, d5 + 1.0, (double)n3 - 2.0);
                graphicsContext.strokeLine(d5, 1.0, d5, (double)n3 - 2.0);
            }
            graphicsContext.strokeLine(1.0, d6, (double)n2 - 2.0, d6);
        }
        graphicsContext.restore();
        return true;
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        int n2;
        int n3;
        long l2 = ProcessingProfiler.getTimeStamp();
        if (this.isAssumeSortedData()) {
            n3 = Math.max(0, dataSet.getIndex(0, this.xMin) - 1);
            n2 = Math.min(dataSet.getIndex(0, this.xMax) + 2, dataSet.getDataCount());
        } else {
            n3 = 0;
            n2 = dataSet.getDataCount();
        }
        if (n2 - n3 <= 0) {
            return;
        }
        if (ProcessingProfiler.getDebugState()) {
            l2 = ProcessingProfiler.getTimeDiff(l2, "get min/max" + String.format(" from:%d to:%d", n3, n2));
        }
        boolean bl2 = true;
        CachedDataPoints cachedDataPoints = SHARED_POINTS_CACHE.resizeMin(n3, n2, dataSet.getDataCount(), true);
        if (ProcessingProfiler.getDebugState()) {
            l2 = ProcessingProfiler.getTimeDiff(l2, "get CachedPoints");
        }
        boolean bl3 = this.getChart().isPolarPlot();
        if (this.isParallelImplementation()) {
            cachedDataPoints.computeScreenCoordinatesInParallel(this.xAxis, this.yAxis, dataSet, dataSetNode, n3, n2, this.getErrorType(), bl3, this.isallowNaNs());
        } else {
            cachedDataPoints.computeScreenCoordinates(this.xAxis, this.yAxis, dataSet, dataSetNode, n3, n2, this.getErrorType(), bl3, this.isallowNaNs());
        }
        if (ProcessingProfiler.getDebugState()) {
            l2 = ProcessingProfiler.getTimeDiff(l2, "computeScreenCoordinates()");
        }
        cachedDataPoints.reduce((RendererDataReducer)this.rendererDataReducerProperty().get(), this.isReducePoints(), this.getMinRequiredReductionSize());
        this.drawChartComponents(graphicsContext, dataSetNode, cachedDataPoints);
        if (ProcessingProfiler.getDebugState()) {
            l2 = ProcessingProfiler.getTimeDiff(l2, "drawChartComponents()");
        }
    }

    protected void drawBars(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        if (!this.isDrawBars()) {
            return;
        }
        int n2 = Math.max(dataSetNode.getGlobalIndex(), 0);
        int n3 = Math.max(this.getDashSize(), cachedDataPoints.minDistanceX);
        double d2 = this.getBarWidthPercentage();
        double d3 = (double)n3 * d2 / 100.0;
        double d4 = this.getBarWidth();
        double d5 = this.isDynamicBarWidth() ? d3 : d4;
        double d6 = d5 / 2.0 - (double)(this.isShiftBar() ? n2 * this.getShiftBarOffset() : 0);
        graphicsContext.save();
        graphicsContext.setLineWidth(dataSetNode.getMarkerLineWidth());
        Paint paint = dataSetNode.getMarkerColor();
        graphicsContext.setStroke(paint);
        graphicsContext.setFill(paint);
        if (cachedDataPoints.polarPlot) {
            for (int i2 = 0; i2 < cachedDataPoints.actualDataCount; ++i2) {
                if (!cachedDataPoints.hasStyles || !this.styleParser.tryParse(cachedDataPoints.styles[i2])) {
                    graphicsContext.strokeLine(cachedDataPoints.xZero, cachedDataPoints.yZero, cachedDataPoints.xValues[i2], cachedDataPoints.yValues[i2]);
                    continue;
                }
                graphicsContext.save();
                this.styleParser.getMarkerColor().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setFill(arg_0));
                graphicsContext.setLineWidth(d6);
                graphicsContext.strokeLine(cachedDataPoints.xZero, cachedDataPoints.yZero, cachedDataPoints.xValues[i2], cachedDataPoints.yValues[i2]);
                graphicsContext.restore();
            }
        } else {
            for (int i3 = 0; i3 < cachedDataPoints.actualDataCount; ++i3) {
                double d7;
                double d8 = cachedDataPoints.yValues[i3] - cachedDataPoints.yZero;
                if (d8 > 0.0) {
                    d7 = cachedDataPoints.yZero;
                } else {
                    d7 = cachedDataPoints.yValues[i3];
                    d8 = Math.abs(d8);
                }
                if (!cachedDataPoints.hasStyles || !this.styleParser.tryParse(cachedDataPoints.styles[i3])) {
                    graphicsContext.fillRect(cachedDataPoints.xValues[i3] - d6, d7, d5, d8);
                    continue;
                }
                graphicsContext.save();
                this.styleParser.getMarkerColor().ifPresent(arg_0 -> ((GraphicsContext)graphicsContext).setFill(arg_0));
                graphicsContext.fillRect(cachedDataPoints.xValues[i3] - d6, d7, d5, d8);
                graphicsContext.restore();
            }
        }
        graphicsContext.restore();
    }

    protected void drawBubbles(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        if (!this.isDrawBubbles()) {
            return;
        }
        graphicsContext.save();
        graphicsContext.setFill(dataSetNode.getLineColor());
        double d2 = dataSetNode.getMarkerSize();
        if (cachedDataPoints.errorType[0] != DataSetError.ErrorType.NO_ERROR && cachedDataPoints.errorType[1] == DataSetError.ErrorType.NO_ERROR) {
            for (int i2 = 0; i2 < cachedDataPoints.actualDataCount; ++i2) {
                double d3 = Math.max(d2, cachedDataPoints.errorXPos[i2] - cachedDataPoints.errorXNeg[i2]);
                double d4 = cachedDataPoints.xValues[i2] - d3;
                double d5 = cachedDataPoints.yValues[i2] - d3;
                graphicsContext.fillOval(d4, d5, 2.0 * d3, 2.0 * d3);
            }
        } else if (cachedDataPoints.errorType[0] == DataSetError.ErrorType.NO_ERROR && cachedDataPoints.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
            for (int i3 = 0; i3 < cachedDataPoints.actualDataCount; ++i3) {
                double d6 = Math.max(d2, cachedDataPoints.errorYNeg[i3] - cachedDataPoints.errorYPos[i3]);
                double d7 = cachedDataPoints.xValues[i3] - d6;
                double d8 = cachedDataPoints.yValues[i3] - d6;
                graphicsContext.fillOval(d7, d8, 2.0 * d6, 2.0 * d6);
            }
        } else if (cachedDataPoints.errorType[0] != DataSetError.ErrorType.NO_ERROR && cachedDataPoints.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
            for (int i4 = 0; i4 < cachedDataPoints.actualDataCount; ++i4) {
                double d9 = Math.max(d2, cachedDataPoints.errorXPos[i4] - cachedDataPoints.errorXNeg[i4]);
                double d10 = Math.max(d2, cachedDataPoints.errorYNeg[i4] - cachedDataPoints.errorYPos[i4]);
                double d11 = cachedDataPoints.xValues[i4] - d9;
                double d12 = cachedDataPoints.yValues[i4] - d10;
                graphicsContext.fillOval(d11, d12, 2.0 * d9, 2.0 * d10);
            }
        } else {
            for (int i5 = 0; i5 < cachedDataPoints.actualDataCount; ++i5) {
                double d13 = cachedDataPoints.xValues[i5] - d2;
                double d14 = cachedDataPoints.yValues[i5] - d2;
                graphicsContext.fillOval(d13, d14, 2.0 * d2, 2.0 * d2);
            }
        }
        graphicsContext.restore();
    }

    protected void drawDefaultNoErrors(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        this.drawBars(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawPolyLine(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawMarker(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawBubbles(graphicsContext, dataSetNode, cachedDataPoints);
    }

    protected void drawErrorBars(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        long l2 = ProcessingProfiler.getTimeStamp();
        this.drawBars(graphicsContext, dataSetNode, cachedDataPoints);
        int n2 = this.getDashSize() / 2;
        graphicsContext.save();
        graphicsContext.setStroke(dataSetNode.getLineColor());
        graphicsContext.setLineWidth(dataSetNode.getLineWidth());
        for (int i2 = 0; i2 < cachedDataPoints.actualDataCount; ++i2) {
            if (cachedDataPoints.errorType[0] != DataSetError.ErrorType.NO_ERROR && cachedDataPoints.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
                graphicsContext.strokeLine(cachedDataPoints.xValues[i2], cachedDataPoints.errorYNeg[i2], cachedDataPoints.xValues[i2], cachedDataPoints.errorYPos[i2]);
                graphicsContext.strokeLine(cachedDataPoints.errorXNeg[i2], cachedDataPoints.yValues[i2], cachedDataPoints.errorXPos[i2], cachedDataPoints.yValues[i2]);
                graphicsContext.strokeLine(cachedDataPoints.xValues[i2] - (double)n2, cachedDataPoints.errorYNeg[i2], cachedDataPoints.xValues[i2] + (double)n2, cachedDataPoints.errorYNeg[i2]);
                graphicsContext.strokeLine(cachedDataPoints.xValues[i2] - (double)n2, cachedDataPoints.errorYPos[i2], cachedDataPoints.xValues[i2] + (double)n2, cachedDataPoints.errorYPos[i2]);
                graphicsContext.strokeLine(cachedDataPoints.errorXNeg[i2], cachedDataPoints.yValues[i2] - (double)n2, cachedDataPoints.errorXNeg[i2], cachedDataPoints.yValues[i2] + (double)n2);
                graphicsContext.strokeLine(cachedDataPoints.errorXPos[i2], cachedDataPoints.yValues[i2] - (double)n2, cachedDataPoints.errorXPos[i2], cachedDataPoints.yValues[i2] + (double)n2);
                continue;
            }
            if (cachedDataPoints.errorType[0] == DataSetError.ErrorType.NO_ERROR && cachedDataPoints.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
                graphicsContext.strokeLine(cachedDataPoints.xValues[i2], cachedDataPoints.errorYNeg[i2], cachedDataPoints.xValues[i2], cachedDataPoints.errorYPos[i2]);
                graphicsContext.strokeLine(cachedDataPoints.xValues[i2] - (double)n2, cachedDataPoints.errorYNeg[i2], cachedDataPoints.xValues[i2] + (double)n2, cachedDataPoints.errorYNeg[i2]);
                graphicsContext.strokeLine(cachedDataPoints.xValues[i2] - (double)n2, cachedDataPoints.errorYPos[i2], cachedDataPoints.xValues[i2] + (double)n2, cachedDataPoints.errorYPos[i2]);
                continue;
            }
            if (cachedDataPoints.errorType[0] == DataSetError.ErrorType.NO_ERROR || cachedDataPoints.errorType[1] != DataSetError.ErrorType.NO_ERROR) continue;
            graphicsContext.strokeLine(cachedDataPoints.errorXNeg[i2], cachedDataPoints.yValues[i2], cachedDataPoints.errorXPos[i2], cachedDataPoints.yValues[i2]);
            graphicsContext.strokeLine(cachedDataPoints.xValues[i2] - (double)n2, cachedDataPoints.errorYNeg[i2], cachedDataPoints.xValues[i2] + (double)n2, cachedDataPoints.errorYNeg[i2]);
            graphicsContext.strokeLine(cachedDataPoints.xValues[i2] - (double)n2, cachedDataPoints.errorYPos[i2], cachedDataPoints.xValues[i2] + (double)n2, cachedDataPoints.errorYPos[i2]);
        }
        graphicsContext.restore();
        this.drawPolyLine(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawMarker(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawBubbles(graphicsContext, dataSetNode, cachedDataPoints);
        ProcessingProfiler.getTimeDiff(l2);
    }

    protected void drawErrorSurface(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        long l2 = ProcessingProfiler.getTimeStamp();
        graphicsContext.setFill(dataSetNode.getLineFillPattern());
        int n2 = cachedDataPoints.actualDataCount;
        int n3 = 2 * n2;
        double[] dArray = SHARED_ARRAYS.getArray(0, n3);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n3);
        int n4 = n3 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = cachedDataPoints.xValues[i2];
            dArray2[i2] = cachedDataPoints.errorYNeg[i2];
            dArray[n4 - i2] = cachedDataPoints.xValues[i2];
            dArray2[n4 - i2] = cachedDataPoints.errorYPos[i2];
        }
        graphicsContext.setFillRule(FillRule.EVEN_ODD);
        graphicsContext.fillPolygon(dArray, dArray2, n3);
        this.drawPolyLine(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawBars(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawMarker(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawBubbles(graphicsContext, dataSetNode, cachedDataPoints);
        ProcessingProfiler.getTimeDiff(l2);
    }

    protected void drawErrorSurfaceNaNCompatible(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        long l2 = ProcessingProfiler.getTimeStamp();
        graphicsContext.setFill(dataSetNode.getLineFillPattern());
        graphicsContext.setFillRule(FillRule.EVEN_ODD);
        int n2 = cachedDataPoints.actualDataCount;
        int n3 = 2 * n2;
        double[] dArray = SHARED_ARRAYS.getArray(0, n3);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n3);
        int n4 = n3 - 1;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2 = cachedDataPoints.xValues[i2];
            double d3 = cachedDataPoints.errorYNeg[i2];
            double d4 = cachedDataPoints.errorYPos[i2];
            if (Double.isFinite(d3) && Double.isFinite(d4)) {
                dArray[n5] = d2;
                dArray2[n5] = d4;
                dArray[n4 - n5] = d2;
                dArray2[n4 - n5] = d3;
                ++n5;
                continue;
            }
            if (n5 == 0) continue;
            ErrorDataSetRenderer.compactVector(dArray, n3, n5);
            ErrorDataSetRenderer.compactVector(dArray2, n3, n5);
            graphicsContext.fillPolygon(dArray, dArray2, 2 * n5);
            n5 = 0;
        }
        if (n5 > 0) {
            ErrorDataSetRenderer.compactVector(dArray, n3, n5);
            ErrorDataSetRenderer.compactVector(dArray2, n3, n5);
            if (n5 > 4) {
                double d5 = dArray2[n5 - 1];
                dArray2[n5 - 1] = dArray2[n5];
                dArray2[n5] = d5;
            }
            graphicsContext.fillPolygon(dArray, dArray2, 2 * n5);
        }
        this.drawPolyLine(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawBars(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawMarker(graphicsContext, dataSetNode, cachedDataPoints);
        this.drawBubbles(graphicsContext, dataSetNode, cachedDataPoints);
        ProcessingProfiler.getTimeDiff(l2);
    }

    protected void drawMarker(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        if (!this.isDrawMarker() || dataSetNode.getMarkerSize() == 0.0 && !cachedDataPoints.hasStyles) {
            return;
        }
        graphicsContext.save();
        Marker marker = dataSetNode.getMarkerType();
        Paint paint = dataSetNode.getMarkerColor();
        double d2 = dataSetNode.getMarkerSize();
        graphicsContext.setLineWidth(dataSetNode.getMarkerLineWidth());
        graphicsContext.setStroke(paint);
        graphicsContext.setFill(paint);
        for (int i2 = 0; i2 < cachedDataPoints.actualDataCount; ++i2) {
            double d3 = cachedDataPoints.xValues[i2];
            double d4 = cachedDataPoints.yValues[i2];
            if (!cachedDataPoints.hasStyles || !this.styleParser.tryParse(cachedDataPoints.styles[i2])) {
                if (d2 == 0.0) continue;
                marker.draw(graphicsContext, d3, d4, d2);
                continue;
            }
            double d5 = this.styleParser.getMarkerSize().orElse(d2);
            if (d5 == 0.0) continue;
            Paint paint2 = this.styleParser.getMarkerColor().orElse(paint);
            Marker marker2 = this.styleParser.getMarkerType().orElse(marker);
            graphicsContext.save();
            graphicsContext.setFill(paint2);
            graphicsContext.setStroke(paint2);
            marker2.draw(graphicsContext, d3, d4, d5);
            graphicsContext.restore();
        }
        graphicsContext.restore();
    }

    protected void drawPolyLine(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        if (dataSetNode.getLineWidth() == 0.0) {
            return;
        }
        switch (this.getPolyLineStyle()) {
            case NONE: {
                return;
            }
            case AREA: {
                ErrorDataSetRenderer.drawPolyLineArea(graphicsContext, dataSetNode, cachedDataPoints);
                break;
            }
            case ZERO_ORDER_HOLDER: 
            case STAIR_CASE: {
                ErrorDataSetRenderer.drawPolyLineStairCase(graphicsContext, dataSetNode, cachedDataPoints);
                break;
            }
            case HISTOGRAM: {
                ErrorDataSetRenderer.drawPolyLineHistogram(graphicsContext, dataSetNode, cachedDataPoints);
                break;
            }
            case HISTOGRAM_FILLED: {
                ErrorDataSetRenderer.drawPolyLineHistogramFilled(graphicsContext, dataSetNode, cachedDataPoints);
                break;
            }
            case BEZIER_CURVE: {
                ErrorDataSetRenderer.drawPolyLineHistogramBezier(graphicsContext, dataSetNode, cachedDataPoints);
                break;
            }
            default: {
                ErrorDataSetRenderer.drawPolyLineLine(graphicsContext, dataSetNode, cachedDataPoints);
            }
        }
    }

    @Override
    protected ErrorDataSetRenderer getThis() {
        return this;
    }

    private void drawChartComponents(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        long l2 = ProcessingProfiler.getTimeStamp();
        switch (this.getErrorType()) {
            case ERRORBARS: {
                this.drawErrorBars(graphicsContext, dataSetNode, cachedDataPoints);
                break;
            }
            case ERRORSURFACE: {
                if (this.isallowNaNs()) {
                    this.drawErrorSurfaceNaNCompatible(graphicsContext, dataSetNode, cachedDataPoints);
                    break;
                }
                this.drawErrorSurface(graphicsContext, dataSetNode, cachedDataPoints);
                break;
            }
            case ERRORCOMBO: {
                if (cachedDataPoints.getMinXDistance() >= this.getDashSize() * 2) {
                    this.drawErrorBars(graphicsContext, dataSetNode, cachedDataPoints);
                    break;
                }
                if (this.isallowNaNs()) {
                    this.drawErrorSurfaceNaNCompatible(graphicsContext, dataSetNode, cachedDataPoints);
                    break;
                }
                this.drawErrorSurface(graphicsContext, dataSetNode, cachedDataPoints);
                break;
            }
            default: {
                this.drawDefaultNoErrors(graphicsContext, dataSetNode, cachedDataPoints);
            }
        }
        ProcessingProfiler.getTimeDiff(l2);
    }

    protected static void drawPolyLineArea(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        int n2 = cachedDataPoints.actualDataCount;
        if (n2 == 0) {
            return;
        }
        int n3 = n2 + 2;
        double[] dArray = SHARED_ARRAYS.getArray(0, n3);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n3);
        double d2 = cachedDataPoints.yZero;
        System.arraycopy(cachedDataPoints.xValues, 0, dArray, 0, n2);
        System.arraycopy(cachedDataPoints.yValues, 0, dArray2, 0, n2);
        dArray[n2] = cachedDataPoints.xValues[n2 - 1];
        dArray2[n2] = d2;
        dArray[n2 + 1] = cachedDataPoints.xValues[0];
        dArray2[n2 + 1] = d2;
        graphicsContext.save();
        graphicsContext.setFill(dataSetNode.getLineColor());
        graphicsContext.fillPolygon(dArray, dArray2, n3);
        graphicsContext.restore();
    }

    protected static void drawPolyLineHistogram(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        int n2;
        int n3 = cachedDataPoints.actualDataCount;
        if (n3 == 0) {
            return;
        }
        int n4 = 2 * (n3 + 1);
        double[] dArray = SHARED_ARRAYS.getArray(0, n4);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n4);
        double d2 = cachedDataPoints.xMax - cachedDataPoints.xMin;
        double d3 = n3 > 0 ? 0.5 * (cachedDataPoints.xValues[1] - cachedDataPoints.xValues[0]) : 0.5 * d2;
        dArray[0] = cachedDataPoints.xValues[0] - d3;
        dArray2[0] = cachedDataPoints.yZero;
        for (n2 = 0; n2 < n3; ++n2) {
            double d4 = cachedDataPoints.xValues[n2] - dArray[2 * n2];
            double d5 = d3 = n2 + 1 < n3 ? 0.5 * (cachedDataPoints.xValues[n2 + 1] - cachedDataPoints.xValues[n2]) : d4;
            if (n2 == 0) {
                d4 = d3;
            }
            dArray[2 * n2 + 1] = cachedDataPoints.xValues[n2] - d4;
            dArray2[2 * n2 + 1] = cachedDataPoints.yValues[n2];
            dArray[2 * n2 + 2] = cachedDataPoints.xValues[n2] + d3;
            dArray2[2 * n2 + 2] = cachedDataPoints.yValues[n2];
        }
        dArray[n4 - 1] = cachedDataPoints.xValues[n3 - 1] + d3;
        dArray2[n4 - 1] = cachedDataPoints.yZero;
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            double d6 = dArray[n2];
            double d7 = dArray[n2 + 1];
            double d8 = dArray2[n2];
            double d9 = dArray2[n2 + 1];
            graphicsContext.strokeLine(d6, d8, d7, d9);
        }
        graphicsContext.restore();
    }

    protected static void drawPolyLineHistogramBezier(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        int n2 = cachedDataPoints.actualDataCount;
        if (n2 < 2) {
            ErrorDataSetRenderer.drawPolyLineLine(graphicsContext, dataSetNode, cachedDataPoints);
            return;
        }
        double[] dArray = SHARED_ARRAYS.getArray(0, n2);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n2);
        double[] dArray3 = SHARED_ARRAYS.getArray(2, n2);
        double[] dArray4 = SHARED_ARRAYS.getArray(3, n2);
        BezierCurve.calcCurveControlPoints(cachedDataPoints.xValues, cachedDataPoints.yValues, dArray, dArray2, dArray3, dArray4, cachedDataPoints.actualDataCount);
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        graphicsContext.beginPath();
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            double d2 = cachedDataPoints.xValues[i2];
            double d3 = cachedDataPoints.xValues[i2 + 1];
            double d4 = cachedDataPoints.yValues[i2];
            double d5 = cachedDataPoints.yValues[i2 + 1];
            double d6 = dArray[i2];
            double d7 = dArray2[i2];
            double d8 = dArray3[i2];
            double d9 = dArray4[i2];
            graphicsContext.moveTo(d2, d4);
            graphicsContext.bezierCurveTo(d6, d7, d8, d9, d3, d5);
        }
        graphicsContext.moveTo(cachedDataPoints.xValues[n2 - 1], cachedDataPoints.yValues[n2 - 1]);
        graphicsContext.closePath();
        graphicsContext.stroke();
        graphicsContext.restore();
    }

    protected static void drawPolyLineHistogramFilled(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        int n2 = cachedDataPoints.actualDataCount;
        if (n2 == 0) {
            return;
        }
        int n3 = 2 * (n2 + 1);
        double[] dArray = SHARED_ARRAYS.getArray(0, n3);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n3);
        double d2 = cachedDataPoints.xMax - cachedDataPoints.xMin;
        double d3 = n2 > 0 ? 0.5 * (cachedDataPoints.xValues[1] - cachedDataPoints.xValues[0]) : 0.5 * d2;
        dArray[0] = cachedDataPoints.xValues[0] - d3;
        dArray2[0] = cachedDataPoints.yZero;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = cachedDataPoints.xValues[i2] - dArray[2 * i2];
            double d5 = d3 = i2 + 1 < n2 ? 0.5 * (cachedDataPoints.xValues[i2 + 1] - cachedDataPoints.xValues[i2]) : d4;
            if (i2 == 0) {
                d4 = d3;
            }
            dArray[2 * i2 + 1] = cachedDataPoints.xValues[i2] - d4;
            dArray2[2 * i2 + 1] = cachedDataPoints.yValues[i2];
            dArray[2 * i2 + 2] = cachedDataPoints.xValues[i2] + d3;
            dArray2[2 * i2 + 2] = cachedDataPoints.yValues[i2];
        }
        dArray[n3 - 1] = cachedDataPoints.xValues[n2 - 1] + d3;
        dArray2[n3 - 1] = cachedDataPoints.yZero;
        graphicsContext.save();
        graphicsContext.setFill(dataSetNode.getLineColor());
        graphicsContext.fillPolygon(dArray, dArray2, n3);
        graphicsContext.restore();
    }

    protected static void drawPolyLineLine(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        if (cachedDataPoints.allowForNaNs) {
            graphicsContext.beginPath();
            graphicsContext.moveTo(cachedDataPoints.xValues[0], cachedDataPoints.yValues[0]);
            boolean bl2 = true;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i2 = 0; i2 < cachedDataPoints.actualDataCount; ++i2) {
                double d4 = cachedDataPoints.xValues[i2];
                double d5 = cachedDataPoints.yValues[i2];
                if (Double.isFinite(d4) && Double.isFinite(d5)) {
                    if (!bl2) {
                        graphicsContext.moveTo(d4, d5);
                        bl2 = true;
                        continue;
                    }
                    graphicsContext.lineTo(d4, d5);
                    d2 = d4;
                    d3 = d5;
                    bl2 = true;
                    continue;
                }
                bl2 = false;
            }
            graphicsContext.moveTo(d2, d3);
            graphicsContext.closePath();
            graphicsContext.stroke();
        } else if (graphicsContext.getLineDashes() != null) {
            graphicsContext.strokePolyline(cachedDataPoints.xValues, cachedDataPoints.yValues, cachedDataPoints.actualDataCount);
        } else {
            for (int i3 = 0; i3 < cachedDataPoints.actualDataCount - 1; ++i3) {
                double d6 = cachedDataPoints.xValues[i3];
                double d7 = cachedDataPoints.xValues[i3 + 1];
                double d8 = cachedDataPoints.yValues[i3];
                double d9 = cachedDataPoints.yValues[i3 + 1];
                graphicsContext.strokeLine(d6, d8, d7, d9);
            }
        }
        graphicsContext.restore();
    }

    protected static void drawPolyLineStairCase(GraphicsContext graphicsContext, DataSetNode dataSetNode, CachedDataPoints cachedDataPoints) {
        int n2;
        int n3 = cachedDataPoints.actualDataCount;
        if (n3 == 0) {
            return;
        }
        int n4 = 2 * n3;
        double[] dArray = SHARED_ARRAYS.getArray(0, n4);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n4);
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            dArray[2 * n2] = cachedDataPoints.xValues[n2];
            dArray2[2 * n2] = cachedDataPoints.yValues[n2];
            dArray[2 * n2 + 1] = cachedDataPoints.xValues[n2 + 1];
            dArray2[2 * n2 + 1] = cachedDataPoints.yValues[n2];
        }
        dArray[n4 - 2] = cachedDataPoints.xValues[n3 - 1];
        dArray2[n4 - 2] = cachedDataPoints.yValues[n3 - 1];
        dArray[n4 - 1] = cachedDataPoints.xMax;
        dArray2[n4 - 1] = cachedDataPoints.yValues[n3 - 1];
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            double d2 = dArray[n2];
            double d3 = dArray[n2 + 1];
            double d4 = dArray2[n2];
            double d5 = dArray2[n2 + 1];
            graphicsContext.strokeLine(d2, d4, d3, d5);
        }
        graphicsContext.restore();
    }

    private static void compactVector(double[] dArray, int n2, int n3) {
        if (n3 >= 0) {
            System.arraycopy(dArray, n2 - n3, dArray, n3, n3);
        }
    }

    public static void trimCache() {
        SHARED_ARRAYS.trim();
        SHARED_POINTS_CACHE.trim();
    }
}

