/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.Measurable;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.CategoryAxis;
import io.fair_acc.chartfx.renderer.spi.AbstractRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.AssertUtils;
import java.security.InvalidParameterException;
import javafx.geometry.Orientation;
import javafx.scene.canvas.GraphicsContext;

public abstract class AbstractRendererXY<R extends AbstractRendererXY<R>>
extends AbstractRenderer<R>
implements Measurable {
    protected double xMin;
    protected double xMax;
    protected Axis xAxis;
    protected Axis yAxis;
    private DurationMeasure benchDrawAll = DurationMeasure.DISABLED;
    private DurationMeasure benchDrawOne = DurationMeasure.DISABLED;

    public AbstractRendererXY() {
        this.chartProperty().addListener((observableValue, chart, chart2) -> this.requireChartXY((Chart)chart2));
    }

    @Override
    public void setChart(Chart chart) {
        super.setChart(this.requireChartXY(chart));
    }

    private XYChart requireChartXY(Chart chart) {
        if (chart == null || chart instanceof XYChart) {
            return (XYChart)chart;
        }
        throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
    }

    @Override
    public XYChart getChart() {
        return (XYChart)super.getChart();
    }

    @Override
    public void render() {
        if (this.getDatasets().isEmpty()) {
            return;
        }
        this.benchDrawAll.start();
        this.updateCachedVariables();
        for (int i2 = this.getDatasetNodes().size() - 1; i2 >= 0; --i2) {
            DataSetNode dataSetNode = (DataSetNode)this.getDatasetNodes().get(i2);
            if (!dataSetNode.isVisible()) continue;
            this.benchDrawOne.start();
            this.render(this.getChart().getCanvas().getGraphicsContext2D(), dataSetNode.getDataSet(), dataSetNode);
            this.benchDrawOne.stop();
        }
        this.benchDrawAll.stop();
    }

    protected abstract void render(GraphicsContext var1, DataSet var2, DataSetNode var3);

    @Override
    public void updateAxes() {
        CategoryAxis categoryAxis;
        Axis axis;
        this.xAxis = this.ensureAxisInChart(this.getFirstAxis(Orientation.HORIZONTAL));
        this.yAxis = this.ensureAxisInChart(this.getFirstAxis(Orientation.VERTICAL));
        XYChart xYChart = AssertUtils.notNull("chart", this.getChart());
        if (this.xAxis == null) {
            this.xAxis = xYChart.getXAxis();
        }
        if (this.yAxis == null) {
            this.yAxis = xYChart.getYAxis();
        }
        if ((axis = this.xAxis) instanceof CategoryAxis) {
            categoryAxis = (CategoryAxis)axis;
            if (!this.getDatasets().isEmpty()) {
                categoryAxis.updateCategories((DataSet)this.getDatasets().get(0));
            }
        }
        if ((axis = this.yAxis) instanceof CategoryAxis) {
            categoryAxis = (CategoryAxis)axis;
            if (!this.getDatasets().isEmpty()) {
                categoryAxis.updateCategories((DataSet)this.getDatasets().get(0));
            }
        }
    }

    protected Axis ensureAxisInChart(Axis axis) {
        if (axis != null && !this.getChart().getAxes().contains((Object)axis)) {
            this.getChart().getAxes().add((Object)axis);
        }
        return axis;
    }

    @Override
    public void updateAxisRange(Axis axis, AxisRange axisRange) {
        if (axis == this.xAxis) {
            this.updateAxisRange(axisRange, 0);
        } else if (axis == this.yAxis) {
            this.updateAxisRange(axisRange, 1);
        }
    }

    protected void updateAxisRange(AxisRange axisRange, int n2) {
        for (DataSetNode dataSetNode : this.getDatasetNodes()) {
            if (!dataSetNode.isVisible()) continue;
            this.updateAxisRange(dataSetNode.getDataSet(), axisRange, n2);
        }
    }

    protected void updateAxisRange(DataSet dataSet, AxisRange axisRange, int n2) {
        AxisDescription axisDescription = dataSet.getAxisDescription(n2);
        if (!axisDescription.isDefined()) {
            dataSet.recomputeLimits(n2);
        }
        axisRange.add(axisDescription.getMin());
        axisRange.add(axisDescription.getMax());
    }

    protected void updateCachedVariables() {
        this.xMin = this.xAxis.getValueForDisplay(this.xAxis.isInvertedAxis() ? this.xAxis.getLength() : 0.0);
        this.xMax = this.xAxis.getValueForDisplay(this.xAxis.isInvertedAxis() ? 0.0 : this.xAxis.getLength());
    }

    @Override
    public void setRecorder(MeasurementRecorder measurementRecorder) {
        this.benchDrawAll = measurementRecorder.newDuration("xy-drawAll");
        this.benchDrawOne = measurementRecorder.newTraceDuration("xy-drawOne");
    }
}

