/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.datareduction;

import io.fair_acc.chartfx.renderer.RendererDataReducer;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import io.fair_acc.math.ArrayUtils;

public class RamanDouglasPeukerDataReducer
implements RendererDataReducer {
    private double epsilon = 0.1;

    public double[][] filter(double[][] dArray) {
        return this.ramerDouglasPeuckerFunction(dArray, 0, dArray.length - 1);
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    protected double[][] ramerDouglasPeuckerFunction(double[][] dArray, int n2, int n3) {
        double d2 = 0.0;
        int n4 = 0;
        double d3 = dArray[n3][0] - dArray[n2][0];
        double d4 = dArray[n3][1] - dArray[n2][1];
        double d5 = -(d4 * dArray[n2][0] - d3 * dArray[n2][1]);
        double d6 = Math.sqrt(Math.pow(d3, 2.0) + Math.pow(d4, 2.0));
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            double d7 = Math.abs(d4 * dArray[i2][0] - d3 * dArray[i2][1] + d5) / d6;
            if (!(d7 > d2)) continue;
            n4 = i2;
            d2 = d7;
        }
        if (d2 >= this.epsilon) {
            double[][] dArray2 = this.ramerDouglasPeuckerFunction(dArray, n2, n4);
            double[][] dArray3 = this.ramerDouglasPeuckerFunction(dArray, n4, n3);
            double[][] dArray4 = new double[dArray2.length - 1 + dArray3.length][2];
            System.arraycopy(dArray2, 0, dArray4, 0, dArray2.length - 1);
            System.arraycopy(dArray3, 0, dArray4, dArray2.length - 1, dArray3.length);
            return dArray4;
        }
        return new double[][]{dArray[n2], dArray[n3]};
    }

    @Override
    public int reducePoints(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, String[] stringArray, boolean[] blArray, int n2, int n3) {
        long l2 = ProcessingProfiler.getTimeStamp();
        double[][] dArray7 = new double[n3 - n2][2];
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            dArray7[n4][0] = dArray[i2];
            dArray7[n4][1] = dArray2[i2];
            ++n4;
        }
        double[][] dArray8 = this.ramerDouglasPeuckerFunction(dArray7, 0, dArray7.length - 1);
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double[] dArray9 = new double[dArray8.length];
        double[] dArray10 = new double[dArray8.length];
        for (int i3 = 0; i3 < dArray8.length; ++i3) {
            dArray9[i3] = dArray8[i3][0];
            dArray10[i3] = dArray8[i3][1];
            d2 = Math.min(d2, dArray10[i3]);
            d3 = Math.max(d3, dArray10[i3]);
        }
        double d4 = d3 - d2;
        if (d4 <= 0.0) {
            d4 = 1.0;
        }
        this.epsilon = 100.0 / d4;
        System.arraycopy(dArray9, 0, dArray, 0, dArray9.length);
        System.arraycopy(dArray10, 0, dArray2, 0, dArray10.length);
        ArrayUtils.fillArray(dArray5, this.epsilon);
        ArrayUtils.fillArray(dArray6, this.epsilon);
        ProcessingProfiler.getTimeDiff(l2, String.format("data reduction (from %d to %d)", n3 - n2, dArray9.length));
        return dArray9.length;
    }

    public void setEpsilon(double d2) {
        AssertUtils.gtEqThanZero("epsilon", d2);
        this.epsilon = d2;
    }
}

