/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements.utils;

import io.fair_acc.chartfx.plugins.measurements.utils.CheckedNumberTextField;
import io.fair_acc.chartfx.utils.FXUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class CheckedValueField
extends VBox {
    private static final String DEFAULT_FONT_DATASET = "Verdana Bold";
    private static final String DEFAULT_FONT = "Verdana Bold";
    private static final String DEFAULT_UNIT_FONT = "Verdana Bold";
    private static final int DEFAULT_FONT_SIZE = 550;
    private static final int DEFAULT_UNIT_FONT_SIZE = 300;
    private static final double FONT_SCALE = 3000.0;
    private static final int DEFAULT_MIN_FONT_SIZE = 18;
    private static final int DEFAULT_MIN_UNIT_FONT_SIZE = 14;
    private final DoubleProperty value = new SimpleDoubleProperty((Object)this, "value", Double.NaN);
    private final DoubleProperty minRange = new SimpleDoubleProperty((Object)this, "minRange", Double.NEGATIVE_INFINITY);
    private final DoubleProperty maxRange = new SimpleDoubleProperty((Object)this, "maxRange", Double.POSITIVE_INFINITY);
    private final Label valueLabel = new Label();
    private final Label unitLabel = new Label();
    protected final Label dataSetName = new Label();
    protected CheckedNumberTextField dataRangeMin = new CheckedNumberTextField(this.minRange.get());
    protected CheckedNumberTextField dataRangeMax = new CheckedNumberTextField(this.maxRange.get());
    protected final ChangeListener<Boolean> minRangeFocusLost = (observableValue, bl2, bl3) -> this.evaluateMinRangeText(true);
    protected final ChangeListener<Boolean> maxRangeFocusLost = (observableValue, bl2, bl3) -> this.evaluateMaxRangeText(true);
    protected final EventHandler<? super KeyEvent> minRangeTyped = keyEvent -> {
        if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
            this.evaluateMinRangeText(false);
        }
    };
    protected final EventHandler<? super KeyEvent> maxRangeTyped = keyEvent -> {
        if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
            this.evaluateMaxRangeText(false);
        }
    };
    protected final ChangeListener<Number> widthChangeListener = (observableValue, number, number2) -> {
        double d2 = Math.max(18.0, Math.min(550.0, number2.doubleValue() / 3000.0 * 550.0));
        double d3 = Math.max(14.0, Math.min(300.0, number2.doubleValue() / 3000.0 * 300.0));
        if (this.dataSetName.getFont().getSize() != d3) {
            this.dataSetName.setFont(Font.font((String)"Verdana Bold", (double)d3));
        }
        if (this.valueLabel.getFont().getSize() != d2) {
            this.valueLabel.setFont(Font.font((String)"Verdana Bold", (double)d2));
        }
        if (this.unitLabel.getFont().getSize() != d3) {
            this.unitLabel.setFont(Font.font((String)"Verdana Bold", (double)d3));
        }
    };

    public void evaluateMinRangeText(boolean bl2) {
        block2: {
            try {
                this.setMinRange(Double.parseDouble(this.dataRangeMin.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                if (!bl2) break block2;
                this.setMinRange(Double.NEGATIVE_INFINITY);
            }
        }
    }

    public void evaluateMaxRangeText(boolean bl2) {
        block2: {
            try {
                this.setMaxRange(Double.parseDouble(this.dataRangeMax.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                if (!bl2) break block2;
                this.setMaxRange(Double.POSITIVE_INFINITY);
            }
        }
    }

    public CheckedValueField() {
        this.setMouseTransparent(true);
        this.dataSetName.setText("");
        this.dataSetName.setPrefWidth(-1.0);
        this.dataSetName.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.dataSetName, Pos.TOP_LEFT));
        this.valueLabel.setText("");
        this.valueLabel.setFont(Font.font((String)"Verdana Bold", (double)18.0));
        this.valueLabel.setPrefWidth(-1.0);
        this.valueLabel.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.valueLabel, Pos.CENTER));
        this.unitLabel.setText("");
        this.unitLabel.setFont(Font.font((String)"Verdana Bold", (double)18.0));
        this.unitLabel.setPrefWidth(-1.0);
        this.unitLabel.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.unitLabel, Pos.TOP_RIGHT));
        this.dataRangeMax.focusedProperty().addListener(this.minRangeFocusLost);
        this.dataRangeMin.setOnKeyTyped(this.minRangeTyped);
        this.minRange.addListener((observableValue, number, number2) -> this.dataRangeMin.setText(number2.toString()));
        this.dataRangeMax.focusedProperty().addListener(this.maxRangeFocusLost);
        this.dataRangeMax.setOnKeyTyped(this.maxRangeTyped);
        this.maxRange.addListener((observableValue, number, number2) -> this.dataRangeMax.setText(number2.toString()));
        VBox.setVgrow((Node)this, (Priority)Priority.SOMETIMES);
    }

    public Label getDataSetName() {
        return this.dataSetName;
    }

    public double getMaxRange() {
        return this.maxRange.get();
    }

    public CheckedNumberTextField getMaxRangeTextField() {
        return this.dataRangeMax;
    }

    public double getMinRange() {
        return this.minRange.get();
    }

    public CheckedNumberTextField getMinRangeTextField() {
        return this.dataRangeMin;
    }

    public Label getUnitLabel() {
        return this.unitLabel;
    }

    public double getValue() {
        return this.value.get();
    }

    public Label getValueLabel() {
        return this.valueLabel;
    }

    public DoubleProperty maxRangeProperty() {
        return this.maxRange;
    }

    public DoubleProperty minRangeProperty() {
        return this.minRange;
    }

    public CheckedValueField resetRanges() {
        this.setMinRange(Double.NEGATIVE_INFINITY);
        this.setMaxRange(Double.POSITIVE_INFINITY);
        this.dataRangeMin.setText(Double.toString(this.getMinRange()));
        this.dataRangeMax.setText(Double.toString(this.getMaxRange()));
        return this;
    }

    public void setDataSetName(String string) {
        FXUtils.runFX(() -> this.dataSetName.setText(string));
    }

    public CheckedValueField setMaxRange(double d2) {
        this.maxRange.set(Double.isNaN(d2) ? Double.POSITIVE_INFINITY : d2);
        this.dataRangeMax.setText(Double.toString(this.getMaxRange()));
        return this;
    }

    public CheckedValueField setMinRange(double d2) {
        this.minRange.set(Double.isNaN(d2) ? Double.NEGATIVE_INFINITY : d2);
        this.dataRangeMin.setText(Double.toString(this.getMinRange()));
        return this;
    }

    public void setUnit(String string) {
        if (this.unitLabel.getText() == null || this.unitLabel.getText().equals(string)) {
            return;
        }
        this.unitLabel.setText(string);
    }

    public void setValue(double d2) {
        this.value.set(d2);
        this.valueLabel.setText(Double.toString(this.getValue()));
        this.setValueWarning(d2 < this.getMinRange() || d2 > this.getMaxRange());
    }

    public void setValue(double d2, String string) {
        if (d2 == this.getValue()) {
            return;
        }
        this.setValue(d2);
        this.getValueLabel().setText(string);
    }

    public void setValueToolTip(String string) {
        this.valueLabel.setTooltip(new Tooltip(string));
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    protected void setValueWarning(boolean bl2) {
        if (bl2) {
            this.valueLabel.setTextFill((Paint)Color.RED);
            this.unitLabel.setTextFill((Paint)Color.RED);
        } else {
            this.valueLabel.setTextFill((Paint)Color.BLACK);
            this.unitLabel.setTextFill((Paint)Color.BLACK);
        }
    }

    private static class MyHBox
    extends HBox {
        public MyHBox(Node node, Pos pos) {
            super(new Node[]{node});
            this.setAlignment(pos);
            VBox.setVgrow((Node)this, (Priority)Priority.SOMETIMES);
        }
    }
}

