/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisMode;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.axes.spi.format.DefaultTimeFormatter;
import io.fair_acc.chartfx.events.FxEventProcessor;
import io.fair_acc.chartfx.plugins.DataPointTooltip;
import io.fair_acc.chartfx.plugins.EditAxis;
import io.fair_acc.chartfx.plugins.ParameterMeasurements;
import io.fair_acc.chartfx.plugins.Screenshot;
import io.fair_acc.chartfx.plugins.TableViewer;
import io.fair_acc.chartfx.plugins.Zoomer;
import io.fair_acc.chartfx.plugins.measurements.AbstractChartMeasurement;
import io.fair_acc.chartfx.plugins.measurements.utils.ChartMeasurementSelector;
import io.fair_acc.chartfx.plugins.measurements.utils.CheckedNumberTextField;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.renderer.spi.MetaDataRenderer;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.utils.DragResizerUtil;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.StateListener;
import io.fair_acc.dataset.spi.LimitedIndexedTreeDataSet;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrendingMeasurements
extends AbstractChartMeasurement {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrendingMeasurements.class);
    private static final long DEFAULT_UPDATE_RATE_LIMIT = 40L;
    private static final int DEFAULT_BUFFER_CAPACITY = 10000;
    private static final double DEFAULT_BUFFER_LENGTH = 3600000.0;
    private final CheckBox graphBelowOtherDataSets = new CheckBox();
    private final ChartMeasurementSelector measurementSelector;
    private final List<CheckedNumberTextField> parameterFields = new ArrayList<CheckedNumberTextField>();
    private final BooleanProperty graphDetached = new SimpleBooleanProperty((Object)this, "graphDetached", false);
    protected final ButtonType buttonDetached = new ButtonType("Detached", ButtonBar.ButtonData.OK_DONE);
    protected final ObjectProperty<Chart> localChart = new SimpleObjectProperty((Object)this, "localChart", null);
    private final MeasurementType measType;
    private final DefaultNumericAxis xAxis = new DefaultNumericAxis("xAxis");
    private final DefaultNumericAxis yAxis = new DefaultNumericAxis("yAxis");
    private final ErrorDataSetRenderer renderer = new ErrorDataSetRenderer();
    private ExternalStage externalStage;
    protected final LimitedIndexedTreeDataSet trendingDataSet;
    protected final ChangeListener<Chart> localChartChangeListener = (observableValue, chart, chart2) -> {
        if (chart != null) {
            chart.getRenderers().remove((Object)this.renderer);
        }
        if (chart2 != null) {
            if (this.isGraphBelowOtherDataSets()) {
                chart2.getRenderers().add(0, (Object)this.renderer);
            } else {
                chart2.getRenderers().add((Object)this.renderer);
            }
        }
    };
    protected final ChangeListener<Chart> globalChartChangeListener = (observableValue, chart, chart2) -> {
        if (chart != null) {
            chart.getRenderers().remove((Object)this.renderer);
        }
        if (chart2 != null) {
            this.localChart.set(chart2);
            this.xAxis.forceRedraw();
            this.yAxis.forceRedraw();
        }
    };

    public TrendingMeasurements(ParameterMeasurements parameterMeasurements, MeasurementType measurementType) {
        super(parameterMeasurements, measurementType.toString(), measurementType.isVertical ? AxisMode.X : AxisMode.Y, measurementType.getRequiredSelectors(), MeasurementCategory.TRENDING.equals((Object)measurementType.getCategory()) ? 0 : measurementType.getRequiredDataSets());
        this.measType = measurementType;
        this.measurementSelector = new ChartMeasurementSelector(parameterMeasurements, this, measurementType.getRequiredDataSets());
        this.trendingDataSet = new LimitedIndexedTreeDataSet("uninitialised", 10000, 3600000.0);
        this.lastLayoutRow = TrendingMeasurements.shiftGridPaneRowOffset((List<Node>)this.measurementSelector.getChildren(), this.lastLayoutRow);
        this.gridPane.getChildren().addAll((Collection)this.measurementSelector.getChildren());
        switch (measurementType) {
            case TRENDING_SECONDS: {
                this.trendingDataSet.setSubtractOffset(true);
                break;
            }
            case TRENDING_TIMEOFDAY_UTC: {
                this.xAxis.setTimeAxis(true);
                break;
            }
            case TRENDING_TIMEOFDAY_LOCAL: {
                this.xAxis.setTimeAxis(true);
                DefaultTimeFormatter defaultTimeFormatter = (DefaultTimeFormatter)this.xAxis.getAxisLabelFormatter();
                defaultTimeFormatter.setTimeZoneOffset(OffsetDateTime.now().getOffset());
                break;
            }
        }
        this.xAxis.setAutoRanging(true);
        this.xAxis.setAutoUnitScaling(false);
        this.yAxis.setAutoRanging(true);
        this.yAxis.setAutoUnitScaling(true);
        this.renderer.getAxes().addAll((Object[])new Axis[]{this.xAxis, this.yAxis});
        this.renderer.getDatasets().add((Object)this.trendingDataSet);
        this.localChart.addListener(this.localChartChangeListener);
        this.getMeasurementPlugin().chartProperty().addListener(this.globalChartChangeListener);
        this.alert.getButtonTypes().add(1, (Object)this.buttonDetached);
        this.addGraphBelowItems();
        this.addParameterValueEditorItems();
        this.graphDetached.addListener((observableValue, bl2, bl3) -> {
            if (Boolean.TRUE.equals(bl3)) {
                this.externalStage = new ExternalStage();
            } else {
                if (this.externalStage == null) {
                    return;
                }
                this.externalStage.close();
                this.localChart.set((Object)this.getMeasurementPlugin().getChart());
            }
        });
        this.setTitle(measurementType.getName());
        this.getValueField().setMinRange(Double.NEGATIVE_INFINITY).setMaxRange(Double.POSITIVE_INFINITY);
        this.addMinMaxRangeFields();
    }

    public MeasurementType getMeasType() {
        return this.measType;
    }

    public BooleanProperty graphDetachedProperty() {
        return this.graphDetached;
    }

    public void handle() {
        if (this.getValueIndicatorsUser().size() < this.measType.requiredSelectors) {
            return;
        }
        long l2 = System.nanoTime();
        ObservableList<AbstractChartMeasurement> observableList = this.measurementSelector.getSelectedChartMeasurements();
        if (!observableList.isEmpty()) {
            AbstractChartMeasurement abstractChartMeasurement = (AbstractChartMeasurement)observableList.get(0);
            ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
            arrayList.add(abstractChartMeasurement.getDataSet());
            this.transformTrending(arrayList, this.trendingDataSet);
            if (arrayList.isEmpty() || arrayList.get(0) == null || arrayList.get(0).getDataCount() < 4) {
                this.trendingDataSet.clearMetaInfo();
                this.trendingDataSet.clearData();
                this.trendingDataSet.getWarningList().add(this.trendingDataSet.getName() + " - insufficient/no source data sets");
                return;
            }
            this.trendingDataSet.clearMetaInfo();
            DataSet dataSet = arrayList.get(0);
            dataSet.lock().readLockGuard(() -> {
                String string = dataSet.getAxisDescription(0).getName();
                String string2 = dataSet.getAxisDescription(0).getUnit();
                String string3 = dataSet.getAxisDescription(1).getName();
                String string4 = dataSet.getAxisDescription(1).getUnit();
                FXUtils.runFX(() -> this.xAxis.set(string, string2));
                FXUtils.runFX(() -> this.yAxis.set(string3, string4));
                switch (this.measType) {
                    case TRENDING_SECONDS: 
                    case TRENDING_TIMEOFDAY_UTC: 
                    case TRENDING_TIMEOFDAY_LOCAL: {
                        this.trendingDataSet.lock().writeLockGuard(() -> {
                            int n2;
                            double d2 = (double)System.currentTimeMillis() / 1000.0;
                            double d3 = this.parameterFields.isEmpty() ? 1.0 : Math.max(1.0, this.parameterFields.get(0).getValue());
                            int n3 = n2 = this.parameterFields.isEmpty() ? 1 : (int)Math.max(1.0, this.parameterFields.get(1).getValue());
                            if (this.trendingDataSet.getMaxQueueSize() != n2) {
                                this.trendingDataSet.setMaxQueueSize(n2);
                            }
                            if (this.trendingDataSet.getMaxLength() != d3) {
                                this.trendingDataSet.setMaxLength(d3);
                            }
                            FXUtils.runFX(() -> {
                                this.xAxis.set("time-of-day", new String[]{null});
                                this.yAxis.set(string3, string4);
                            });
                            AbstractChartMeasurement abstractChartMeasurement = this.measurementSelector.getSelectedChartMeasurement();
                            if (abstractChartMeasurement != null) {
                                this.trendingDataSet.setName(abstractChartMeasurement.getTitle());
                                this.trendingDataSet.add(d2, abstractChartMeasurement.valueProperty().get());
                            }
                        });
                        break;
                    }
                }
            });
        }
        long l3 = System.nanoTime();
        double d2 = TimeUnit.NANOSECONDS.toMillis(l3 - l2);
        ProcessingProfiler.getTimeDiff(l2, "computation duration of " + this.measType + " for dataSet" + this.trendingDataSet.getName());
        FXUtils.runFX(() -> {
            this.getValueField().setUnit("ms");
            this.getValueField().setValue(d2);
        });
    }

    @Override
    public void initialize() {
        this.getDataViewWindow().setContent((Node)this.getValueField());
        DragResizerUtil.makeResizable((Node)this.getValueField());
        Optional<ButtonType> optional = super.showConfigDialogue();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument(optional).log("config dialogue finished with result {}");
            LOGGER.atTrace().addArgument(this.getValueIndicators()).log("detected getValueIndicators() = {}");
            LOGGER.atTrace().addArgument(this.getValueIndicatorsUser()).log("detected getValueIndicatorsUser() = {}");
        }
        this.dataSetSelector.setDisable(true);
        this.measurementSelector.setDisable(true);
        int n2 = this.measurementSelector.getSelectedChartMeasurements().size();
        if (n2 < this.measType.getRequiredDataSets()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().addArgument((Object)this.measType).addArgument(n2).addArgument(this.measType.getRequiredDataSets()).log("insuffcient number ChartMeasurements for {} selected {} vs. needed {}");
            }
            this.removeAction();
        }
    }

    public boolean isGraphBelowOtherDataSets() {
        return this.graphBelowOtherDataSetsProperty().get();
    }

    public boolean isGraphDetached() {
        return this.graphDetachedProperty().get();
    }

    public void setGraphBelowOtherDataSets(boolean bl2) {
        this.graphBelowOtherDataSetsProperty().set(bl2);
    }

    public void setGraphDetached(boolean bl2) {
        this.graphDetachedProperty().set(bl2);
    }

    private void removeRendererFromOldChart() {
        Chart chart = (Chart)this.localChart.get();
        if (chart != null) {
            chart.getRenderers().remove((Object)this.renderer);
            chart.getAxes().removeAll(this.renderer.getAxes());
            chart.invalidate();
        }
    }

    protected void addGraphBelowItems() {
        String string = "whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets";
        Label label = new Label("draw below: ");
        label.setTooltip(new Tooltip("whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets"));
        GridPane.setConstraints((Node)label, (int)0, (int)this.lastLayoutRow);
        this.graphBelowOtherDataSets.setSelected(false);
        this.graphBelowOtherDataSets.setTooltip(new Tooltip("whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets"));
        GridPane.setConstraints((Node)this.graphBelowOtherDataSets, (int)1, (int)this.lastLayoutRow++);
        this.graphBelowOtherDataSets.selectedProperty().addListener((observableValue, bl2, bl3) -> {
            Chart chart = (Chart)this.localChart.get();
            if (chart == null) {
                return;
            }
            chart.getRenderers().remove((Object)this.renderer);
            if (Boolean.TRUE.equals(bl3)) {
                chart.getRenderers().add(0, (Object)this.renderer);
            } else {
                chart.getRenderers().add((Object)this.renderer);
            }
        });
        this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{label, this.graphBelowOtherDataSets});
    }

    protected void addParameterValueEditorItems() {
        if (this.measType.getControlParameterNames().isEmpty()) {
            return;
        }
        String string = "math function parameter - usually in units of the x-axis";
        for (String string2 : this.measType.getControlParameterNames()) {
            Label label = new Label(string2 + ": ");
            CheckedNumberTextField checkedNumberTextField = new CheckedNumberTextField(1.0);
            label.setTooltip(new Tooltip("math function parameter - usually in units of the x-axis"));
            GridPane.setConstraints((Node)label, (int)0, (int)this.lastLayoutRow);
            checkedNumberTextField.setTooltip(new Tooltip("math function parameter - usually in units of the x-axis"));
            GridPane.setConstraints((Node)checkedNumberTextField, (int)1, (int)this.lastLayoutRow++);
            this.parameterFields.add(checkedNumberTextField);
            this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{label, checkedNumberTextField});
        }
        switch (this.measType) {
            case TRENDING_SECONDS: 
            case TRENDING_TIMEOFDAY_UTC: 
            case TRENDING_TIMEOFDAY_LOCAL: {
                this.parameterFields.get(0).setText("600.0");
                this.parameterFields.get(1).setText("10000");
                Button button = new Button("reset history");
                button.setTooltip(new Tooltip("press to reset trending history"));
                button.setOnAction(actionEvent -> this.trendingDataSet.reset());
                GridPane.setConstraints((Node)button, (int)1, (int)this.lastLayoutRow++);
                this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{button});
                break;
            }
        }
    }

    @Override
    protected void defaultAction(Optional<ButtonType> optional) {
        boolean bl2;
        super.defaultAction(optional);
        boolean bl3 = bl2 = optional.isPresent() && optional.get().equals(this.buttonDetached);
        if (bl2 && !this.graphDetached.get()) {
            this.nominalAction();
            this.xAxis.setSide(Side.BOTTOM);
            this.yAxis.setSide(Side.LEFT);
            this.graphDetached.set(true);
        }
        this.initDataSets();
        if (!bl2 && this.getMeasurementPlugin().getChart() != null) {
            this.xAxis.setSide(Side.TOP);
            this.yAxis.setSide(Side.RIGHT);
            this.localChart.set((Object)this.getMeasurementPlugin().getChart());
        }
    }

    protected String getDataSetsAsStringList(List<DataSet> list) {
        return list.stream().map(DataSet::getName).collect(Collectors.joining(", ", "(", ")"));
    }

    protected BooleanProperty graphBelowOtherDataSetsProperty() {
        return this.graphBelowOtherDataSets.selectedProperty();
    }

    protected void initDataSets() {
        ObservableList<AbstractChartMeasurement> observableList = this.measurementSelector.getSelectedChartMeasurements();
        String string = "measurement";
        this.trendingDataSet.setName(this.measType.getName() + "measurement");
        InvalidationListener invalidationListener = observable -> {
            AbstractChartMeasurement abstractChartMeasurement = (AbstractChartMeasurement)observableList.get(0);
            BitState bitState = BitState.initDirty(abstractChartMeasurement, -1);
            abstractChartMeasurement.getBitState().addInvalidateListener(bitState);
            abstractChartMeasurement.valueProperty().addListener(bitState.onPropChange(-1)::set);
            FxEventProcessor.getInstance().addAction(bitState, this::handle);
        };
        observableList.addListener(invalidationListener);
        invalidationListener.invalidated(observableList);
    }

    @Override
    protected void nominalAction() {
        super.nominalAction();
        this.initDataSets();
        this.xAxis.setSide(Side.TOP);
        this.yAxis.setSide(Side.RIGHT);
        if (this.graphDetached.get() && this.externalStage != null && this.externalStage.getOnCloseRequest() != null) {
            this.externalStage.getOnCloseRequest().handle((Event)new WindowEvent((Window)this.externalStage, WindowEvent.WINDOW_CLOSE_REQUEST));
        }
        if (this.getMeasurementPlugin().getChart() != null) {
            this.localChart.set((Object)this.getMeasurementPlugin().getChart());
        }
        this.graphDetached.set(false);
    }

    @Override
    protected void removeAction() {
        super.removeAction();
        this.removeRendererFromOldChart();
    }

    protected void transformTrending(List<DataSet> list, LimitedIndexedTreeDataSet limitedIndexedTreeDataSet) {
        if (list.isEmpty() || list.get(0) == null || list.get(0).getDataCount() < 4) {
            limitedIndexedTreeDataSet.clearMetaInfo();
            limitedIndexedTreeDataSet.clearData();
            limitedIndexedTreeDataSet.getWarningList().add(limitedIndexedTreeDataSet.getName() + " - insufficient/no source data sets");
            return;
        }
        limitedIndexedTreeDataSet.clearMetaInfo();
        DataSet dataSet = list.get(0);
        dataSet.lock().readLockGuard(() -> {
            String string = dataSet.getAxisDescription(0).getName();
            String string2 = dataSet.getAxisDescription(0).getUnit();
            String string3 = dataSet.getAxisDescription(1).getName();
            String string4 = dataSet.getAxisDescription(1).getUnit();
            boolean bl2 = list.size() > 1;
            DataSet dataSet2 = bl2 ? (DataSet)list.get(1) : null;
            String string5 = bl2 ? dataSet2.getName() : "";
            FXUtils.runFX(() -> this.xAxis.set(string, string2));
            FXUtils.runFX(() -> this.yAxis.set(string3, string4));
            switch (this.measType) {
                case TRENDING_SECONDS: 
                case TRENDING_TIMEOFDAY_UTC: 
                case TRENDING_TIMEOFDAY_LOCAL: {
                    this.trendingDataSet.lock().writeLockGuard(() -> {
                        int n2;
                        double d2 = (double)System.currentTimeMillis() / 1000.0;
                        double d3 = this.parameterFields.isEmpty() ? 1.0 : Math.max(1.0, this.parameterFields.get(0).getValue());
                        int n3 = n2 = this.parameterFields.isEmpty() ? 1 : (int)Math.max(1.0, this.parameterFields.get(1).getValue());
                        if (this.trendingDataSet.getMaxQueueSize() != n2) {
                            this.trendingDataSet.setMaxQueueSize(n2);
                        }
                        if (this.trendingDataSet.getMaxLength() != d3) {
                            this.trendingDataSet.setMaxLength(d3);
                        }
                        FXUtils.runFX(() -> this.xAxis.set("time-of-day", new String[]{null}));
                        FXUtils.runFX(() -> this.yAxis.set(string3, string4));
                        AbstractChartMeasurement abstractChartMeasurement = this.measurementSelector.getSelectedChartMeasurement();
                        if (abstractChartMeasurement != null) {
                            this.trendingDataSet.setName(abstractChartMeasurement.getTitle());
                            this.trendingDataSet.add(d2, abstractChartMeasurement.valueProperty().get());
                        }
                    });
                    break;
                }
            }
        });
    }

    public static enum MeasurementType {
        TRENDING_SECONDS(true, MeasurementCategory.TRENDING, "trend in seconds", 0, 1, "length history [s]", "n data points []"),
        TRENDING_TIMEOFDAY_UTC(true, MeasurementCategory.TRENDING, "time-of-day trending [UTC]", 0, 1, "length history [s]", "n data points []"),
        TRENDING_TIMEOFDAY_LOCAL(true, MeasurementCategory.TRENDING, "time-of-day trending [local]", 0, 1, "length history [s]", "n data points []");

        private final String name;
        private final MeasurementCategory category;
        private final List<String> controlParameterNames = new ArrayList<String>();
        private final int requiredSelectors;
        private final int requiredDataSets;
        private final boolean isVertical;

        private MeasurementType(boolean bl2, MeasurementCategory measurementCategory, String string2) {
            this(bl2, measurementCategory, string2, 2, 1, new String[0]);
        }

        private MeasurementType(boolean bl2, MeasurementCategory measurementCategory, String string2, int n3, int n4, String ... stringArray) {
            this.isVertical = bl2;
            this.category = measurementCategory;
            this.name = string2;
            if (stringArray != null) {
                this.controlParameterNames.addAll(Arrays.asList(stringArray));
            }
            this.requiredSelectors = n3;
            this.requiredDataSets = n4;
        }

        public MeasurementCategory getCategory() {
            return this.category;
        }

        public List<String> getControlParameterNames() {
            return this.controlParameterNames;
        }

        public String getName() {
            return this.name;
        }

        public int getRequiredDataSets() {
            return this.requiredDataSets;
        }

        public int getRequiredSelectors() {
            return this.requiredSelectors;
        }

        public boolean isVerticalMeasurement() {
            return this.isVertical;
        }
    }

    public static enum MeasurementCategory {
        TRENDING("Trending");

        private final String name;

        private MeasurementCategory(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }

    protected class ExternalStage
    extends Stage {
        private final StateListener titleListener = (bitState, n2) -> FXUtils.runFX(() -> this.setTitle(TrendingMeasurements.this.trendingDataSet.getName()));

        public ExternalStage() {
            XYChart xYChart = new XYChart(TrendingMeasurements.this.xAxis, TrendingMeasurements.this.yAxis);
            xYChart.getRenderers().setAll((Object[])new Renderer[]{new MetaDataRenderer(xYChart)});
            xYChart.applyCss();
            xYChart.getPlugins().add((Object)new ParameterMeasurements());
            xYChart.getPlugins().add((Object)new Screenshot());
            xYChart.getPlugins().add((Object)new EditAxis());
            Zoomer zoomer = new Zoomer();
            zoomer.setUpdateTickUnit(true);
            zoomer.setAutoZoomEnabled(true);
            zoomer.setAddButtonsToToolBar(false);
            xYChart.getPlugins().add((Object)zoomer);
            xYChart.getPlugins().add((Object)new DataPointTooltip());
            xYChart.getPlugins().add((Object)new TableViewer());
            Scene scene = new Scene((Parent)xYChart, 640.0, 480.0);
            this.setScene(scene);
            FXUtils.runFX(() -> ((ExternalStage)this).show());
            FXUtils.runFX(() -> {
                TrendingMeasurements.this.localChart.set((Object)xYChart);
                TrendingMeasurements.this.xAxis.setSide(Side.BOTTOM);
                TrendingMeasurements.this.yAxis.setSide(Side.LEFT);
            });
            this.setOnCloseRequest(windowEvent -> {
                xYChart.getAxes().clear();
                TrendingMeasurements.this.xAxis.setSide(Side.TOP);
                TrendingMeasurements.this.yAxis.setSide(Side.RIGHT);
                TrendingMeasurements.this.graphDetached.set(false);
            });
        }
    }
}

