/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisMode;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.plugins.DataPointTooltip;
import io.fair_acc.chartfx.plugins.EditAxis;
import io.fair_acc.chartfx.plugins.ParameterMeasurements;
import io.fair_acc.chartfx.plugins.Screenshot;
import io.fair_acc.chartfx.plugins.TableViewer;
import io.fair_acc.chartfx.plugins.Zoomer;
import io.fair_acc.chartfx.plugins.measurements.AbstractChartMeasurement;
import io.fair_acc.chartfx.plugins.measurements.utils.ChartMeasurementSelector;
import io.fair_acc.chartfx.plugins.measurements.utils.CheckedNumberTextField;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.renderer.spi.MetaDataRenderer;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.utils.DragResizerUtil;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.Formatter;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.events.StateListener;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import io.fair_acc.math.DataSetMath;
import io.fair_acc.math.MathDataSet;
import io.fair_acc.math.MultiDimDataSetMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetMeasurements
extends AbstractChartMeasurement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetMeasurements.class);
    private static final long MIN_FFT_BINS = 4L;
    private static final long DEFAULT_UPDATE_RATE_LIMIT = 40L;
    private static final String FILTER_CONSTANT_VARIABLE = "filter constant";
    private static final String FREQUENCY = "frequency";
    private static final String MAG = "magnitude(";
    private static final String VALUE = "value";
    private final CheckBox graphBelowOtherDataSets = new CheckBox();
    private final ChartMeasurementSelector measurementSelector;
    private final List<CheckedNumberTextField> parameterFields = new ArrayList<CheckedNumberTextField>();
    private final BooleanProperty graphDetached = new SimpleBooleanProperty((Object)this, "graphDetached", false);
    protected final ButtonType buttonDetached = new ButtonType("Detached", ButtonBar.ButtonData.OK_DONE);
    protected final ObjectProperty<Chart> localChart = new SimpleObjectProperty((Object)this, "localChart", null);
    private final MeasurementType measType;
    private final DefaultNumericAxis xAxis = new DefaultNumericAxis("xAxis");
    private final DefaultNumericAxis yAxis = new DefaultNumericAxis("yAxis");
    private final ErrorDataSetRenderer renderer = new ErrorDataSetRenderer();
    private ExternalStage externalStage;
    private final MathDataSet mathDataSet;
    protected final ChangeListener<Chart> localChartChangeListener = (observableValue, chart, chart2) -> {
        if (chart != null) {
            chart.getRenderers().remove((Object)this.renderer);
        }
        if (chart2 != null) {
            if (this.isGraphBelowOtherDataSets()) {
                chart2.getRenderers().add(0, (Object)this.renderer);
            } else {
                chart2.getRenderers().add((Object)this.renderer);
            }
        }
    };
    protected final ChangeListener<Chart> globalChartChangeListener = (observableValue, chart, chart2) -> {
        if (chart != null) {
            chart.getRenderers().remove((Object)this.renderer);
        }
        if (chart2 != null) {
            this.localChart.set(chart2);
            this.xAxis.forceRedraw();
            this.yAxis.forceRedraw();
        }
    };

    public DataSetMeasurements(ParameterMeasurements parameterMeasurements, MeasurementType measurementType) {
        super(parameterMeasurements, measurementType.toString(), measurementType.isVertical ? AxisMode.X : AxisMode.Y, measurementType.getRequiredSelectors(), measurementType.getRequiredDataSets());
        this.measType = measurementType;
        this.measurementSelector = new ChartMeasurementSelector(parameterMeasurements, this, 0);
        this.mathDataSet = new MathDataSet(measurementType.getName(), this::transform, 40L, new DataSet[0]);
        this.xAxis.setAutoRanging(true);
        this.xAxis.setAutoUnitScaling(true);
        this.yAxis.setAutoRanging(true);
        this.yAxis.setAutoUnitScaling(true);
        this.renderer.getAxes().addAll((Object[])new Axis[]{this.xAxis, this.yAxis});
        this.renderer.getDatasets().add((Object)this.mathDataSet);
        this.localChart.addListener(this.localChartChangeListener);
        this.getMeasurementPlugin().chartProperty().addListener(this.globalChartChangeListener);
        this.alert.getButtonTypes().add(1, (Object)this.buttonDetached);
        this.addGraphBelowItems();
        this.addParameterValueEditorItems();
        this.graphDetached.addListener((observableValue, bl2, bl3) -> {
            if (Boolean.TRUE.equals(bl3)) {
                this.externalStage = new ExternalStage();
            } else {
                if (this.externalStage == null) {
                    return;
                }
                this.externalStage.close();
                this.localChart.set((Object)this.getMeasurementPlugin().getChart());
            }
        });
        this.setTitle(measurementType.getName());
        this.getValueField().setMinRange(Double.NEGATIVE_INFINITY).setMaxRange(Double.POSITIVE_INFINITY);
        this.addMinMaxRangeFields();
    }

    public MeasurementType getMeasType() {
        return this.measType;
    }

    public BooleanProperty graphDetachedProperty() {
        return this.graphDetached;
    }

    public void handle() {
        if (this.getValueIndicatorsUser().size() < this.measType.requiredSelectors) {
            return;
        }
        List<DataSet> list = this.mathDataSet.getSourceDataSets();
        String string = list.isEmpty() ? "(null)" : list.stream().map(DataSet::getName).collect(Collectors.joining(", ", "(", ")"));
        this.mathDataSet.triggerUpdate();
    }

    @Override
    public void initialize() {
        this.getDataViewWindow().setContent((Node)this.getValueField());
        DragResizerUtil.makeResizable((Node)this.getValueField());
        Optional<ButtonType> optional = super.showConfigDialogue();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument(optional).log("config dialogue finished with result {}");
            LOGGER.atTrace().addArgument(this.getValueIndicators()).log("detected getValueIndicators() = {}");
            LOGGER.atTrace().addArgument(this.getValueIndicatorsUser()).log("detected getValueIndicatorsUser() = {}");
        }
        this.dataSetSelector.setDisable(true);
        this.measurementSelector.setDisable(true);
        int n2 = this.mathDataSet.getSourceDataSets().size();
        if (this.mathDataSet.getSourceDataSets().size() < this.measType.getRequiredDataSets()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().addArgument((Object)this.measType).addArgument(n2).addArgument(this.measType.getRequiredDataSets()).log("insuffcient number DataSets for {} selected {} vs. needed {}");
            }
            this.removeAction();
        }
    }

    public boolean isGraphBelowOtherDataSets() {
        return this.graphBelowOtherDataSetsProperty().get();
    }

    public boolean isGraphDetached() {
        return this.graphDetachedProperty().get();
    }

    public void setGraphBelowOtherDataSets(boolean bl2) {
        this.graphBelowOtherDataSetsProperty().set(bl2);
    }

    public void setGraphDetached(boolean bl2) {
        this.graphDetachedProperty().set(bl2);
    }

    private void removeRendererFromOldChart() {
        Chart chart = (Chart)this.localChart.get();
        if (chart != null) {
            chart.getRenderers().remove((Object)this.renderer);
            chart.getAxes().removeAll(this.renderer.getAxes());
            chart.invalidate();
        }
    }

    protected void addGraphBelowItems() {
        String string = "whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets";
        Label label = new Label("draw below: ");
        label.setTooltip(new Tooltip("whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets"));
        GridPane.setConstraints((Node)label, (int)0, (int)this.lastLayoutRow);
        this.graphBelowOtherDataSets.setSelected(false);
        this.graphBelowOtherDataSets.setTooltip(new Tooltip("whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets"));
        GridPane.setConstraints((Node)this.graphBelowOtherDataSets, (int)1, (int)this.lastLayoutRow++);
        this.graphBelowOtherDataSets.selectedProperty().addListener((observableValue, bl2, bl3) -> {
            Chart chart = (Chart)this.localChart.get();
            if (chart == null) {
                return;
            }
            chart.getRenderers().remove((Object)this.renderer);
            if (Boolean.TRUE.equals(bl3)) {
                chart.getRenderers().add(0, (Object)this.renderer);
            } else {
                chart.getRenderers().add((Object)this.renderer);
            }
        });
        this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{label, this.graphBelowOtherDataSets});
    }

    protected void addParameterValueEditorItems() {
        if (this.measType.getControlParameterNames().isEmpty()) {
            return;
        }
        String string = "math function parameter - usually in units of the x-axis";
        for (String string2 : this.measType.getControlParameterNames()) {
            Label label = new Label(string2 + ": ");
            CheckedNumberTextField checkedNumberTextField = new CheckedNumberTextField(1.0);
            label.setTooltip(new Tooltip("math function parameter - usually in units of the x-axis"));
            GridPane.setConstraints((Node)label, (int)0, (int)this.lastLayoutRow);
            checkedNumberTextField.setTooltip(new Tooltip("math function parameter - usually in units of the x-axis"));
            GridPane.setConstraints((Node)checkedNumberTextField, (int)1, (int)this.lastLayoutRow++);
            this.parameterFields.add(checkedNumberTextField);
            this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{label, checkedNumberTextField});
        }
    }

    @Override
    protected void defaultAction(Optional<ButtonType> optional) {
        boolean bl2;
        super.defaultAction(optional);
        boolean bl3 = bl2 = optional.isPresent() && optional.get().equals(this.buttonDetached);
        if (bl2 && !this.graphDetached.get()) {
            this.nominalAction();
            this.xAxis.setSide(Side.BOTTOM);
            this.yAxis.setSide(Side.LEFT);
            this.graphDetached.set(true);
        }
        this.initDataSets();
        if (!bl2 && this.getMeasurementPlugin().getChart() != null) {
            this.xAxis.setSide(Side.TOP);
            this.yAxis.setSide(Side.RIGHT);
            this.localChart.set((Object)this.getMeasurementPlugin().getChart());
        }
        this.mathDataSet.triggerUpdate();
    }

    protected String getDataSetsAsStringList(List<DataSet> list) {
        return list.stream().map(DataSet::getName).collect(Collectors.joining(", ", "(", ")"));
    }

    protected BooleanProperty graphBelowOtherDataSetsProperty() {
        return this.graphBelowOtherDataSets.selectedProperty();
    }

    protected void initDataSets() {
        ObservableList<DataSet> observableList = this.dataSetSelector.getSelectedDataSets();
        String string = observableList.isEmpty() ? "(null)" : this.getDataSetsAsStringList((List<DataSet>)observableList);
        this.mathDataSet.setName(this.measType.getName() + string);
        this.mathDataSet.deregisterListener();
        this.mathDataSet.getSourceDataSets().clear();
        this.mathDataSet.getSourceDataSets().addAll((Collection<DataSet>)observableList);
        this.mathDataSet.registerListener();
        this.mathDataSet.triggerUpdate();
    }

    @Override
    protected void nominalAction() {
        super.nominalAction();
        this.initDataSets();
        this.xAxis.setSide(Side.TOP);
        this.yAxis.setSide(Side.RIGHT);
        if (this.graphDetached.get() && this.externalStage != null && this.externalStage.getOnCloseRequest() != null) {
            this.externalStage.getOnCloseRequest().handle((Event)new WindowEvent((Window)this.externalStage, WindowEvent.WINDOW_CLOSE_REQUEST));
        }
        if (this.getMeasurementPlugin().getChart() != null) {
            this.localChart.set((Object)this.getMeasurementPlugin().getChart());
        }
        this.graphDetached.set(false);
        if (this.mathDataSet != null) {
            this.mathDataSet.triggerUpdate();
        }
    }

    @Override
    protected void removeAction() {
        super.removeAction();
        this.removeRendererFromOldChart();
    }

    protected void transform(List<DataSet> list, MathDataSet mathDataSet) {
        long l2 = System.nanoTime();
        if (list.isEmpty() || list.get(0) == null || list.get(0).getDataCount() < 4) {
            mathDataSet.clearMetaInfo();
            mathDataSet.clearData();
            mathDataSet.getWarningList().add(mathDataSet.getName() + " - insufficient/no source data sets");
            return;
        }
        mathDataSet.clearMetaInfo();
        DataSet dataSet = list.get(0);
        dataSet.lock().readLockGuard(() -> {
            double d2 = this.requiredNumberOfIndicators >= 1 && !this.getValueIndicatorsUser().isEmpty() ? ((AbstractSingleValueIndicator)this.getValueIndicatorsUser().get(0)).getValue() : Double.NEGATIVE_INFINITY;
            double d3 = this.requiredNumberOfIndicators >= 2 && this.getValueIndicatorsUser().size() >= 2 ? ((AbstractSingleValueIndicator)this.getValueIndicatorsUser().get(1)).getValue() : Double.POSITIVE_INFINITY;
            double d4 = this.parameterFields.isEmpty() ? 1.0 : this.parameterFields.get(0).getValue();
            String string = dataSet.getName();
            String string2 = dataSet.getAxisDescription(0).getName();
            String string3 = dataSet.getAxisDescription(0).getUnit();
            String string4 = dataSet.getAxisDescription(1).getName();
            String string5 = dataSet.getAxisDescription(1).getUnit();
            boolean bl2 = list.size() > 1;
            DataSet dataSet2 = bl2 ? (DataSet)list.get(1) : null;
            String string6 = bl2 ? dataSet2.getName() : "";
            FXUtils.runFX(() -> this.xAxis.set(string2, string3));
            FXUtils.runFX(() -> this.yAxis.set(string4, string5));
            switch (this.measType) {
                case ADD_FUNCTIONS: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2211(" + string + " + " + string6 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, dataSet2, DataSetMath.MathOp.ADD, new Formatter[0]));
                    break;
                }
                case ADD_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2211(" + string + " + " + d4 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, d4, DataSetMath.MathOp.ADD, new Formatter[0]));
                    break;
                }
                case SUBTRACT_FUNCTIONS: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2206(" + string + " - " + string6 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, dataSet2, DataSetMath.MathOp.SUBTRACT, new Formatter[0]));
                    break;
                }
                case SUBTRACT_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2206(" + string + " - " + d4 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, d4, DataSetMath.MathOp.SUBTRACT, new Formatter[0]));
                    break;
                }
                case MULTIPLY_FUNCTIONS: {
                    FXUtils.runFX(() -> this.yAxis.set("\u220f(" + string + " * " + string6 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, dataSet2, DataSetMath.MathOp.MULTIPLY, new Formatter[0]));
                    break;
                }
                case MULTIPLY_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("\u220f(" + string + " * " + d4 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, d4, DataSetMath.MathOp.MULTIPLY, new Formatter[0]));
                    break;
                }
                case DIVIDE_FUNCTIONS: {
                    FXUtils.runFX(() -> this.yAxis.set("(" + string + " / " + string6 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, dataSet2, DataSetMath.MathOp.DIVIDE, new Formatter[0]));
                    break;
                }
                case DIVIDE_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("(" + string + " / " + d4 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, d4, DataSetMath.MathOp.DIVIDE, new Formatter[0]));
                    break;
                }
                case SUB_RANGE: {
                    FXUtils.runFX(() -> this.yAxis.set("sub-range(" + string + ")", string5));
                    mathDataSet.set(DataSetMath.getSubRange(dataSet, d2, d3, new Formatter[0]));
                    break;
                }
                case ADD_GAUSS_NOISE: {
                    FXUtils.runFX(() -> this.yAxis.set(string + " + " + d4 + " r.m.s. noise", string5));
                    mathDataSet.set(DataSetMath.addGaussianNoise(dataSet, d4, new Formatter[0]));
                    break;
                }
                case AVG_DATASET_FIR: {
                    FXUtils.runFX(() -> this.yAxis.set("<" + string + ", " + list.size() + " DataSets>", string5));
                    mathDataSet.set(DataSetMath.averageDataSetsFIR(list, (int)Math.floor(d4), new Formatter[0]));
                    break;
                }
                case SQUARE: {
                    FXUtils.runFX(() -> this.yAxis.set("(" + string + ")\u00b2", string5));
                    Platform.runLater(() -> mathDataSet.set(DataSetMath.sqrFunction(dataSet, 0.0, new Formatter[0])));
                    break;
                }
                case SQUARE_FULL: {
                    FXUtils.runFX(() -> this.yAxis.set("(" + string + ", " + string6 + ")\u00b2", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, dataSet2, DataSetMath.MathOp.SQR, new Formatter[0]));
                    break;
                }
                case SQUARE_ROOT: {
                    FXUtils.runFX(() -> this.yAxis.set("\u221a(" + string + ")", string5));
                    mathDataSet.set(DataSetMath.sqrtFunction(dataSet, 0.0, new Formatter[0]));
                    break;
                }
                case SQUARE_ROOT_FULL: {
                    FXUtils.runFX(() -> this.yAxis.set("\u221a(" + string + ", " + string6 + ")", string5));
                    mathDataSet.set(DataSetMath.mathFunction(dataSet, dataSet2, DataSetMath.MathOp.SQRT, new Formatter[0]));
                    break;
                }
                case INTEGRAL: {
                    FXUtils.runFX(() -> this.yAxis.set("\u222b(" + string + ")d" + string2, string3 + "*" + string5));
                    mathDataSet.set(DataSetMath.integrateFunction(dataSet, d2, d3, new Formatter[0]));
                    break;
                }
                case INTEGRAL_FULL: {
                    FXUtils.runFX(() -> this.yAxis.set("\u222b(" + string + ")d" + string2, string3 + "*" + string5));
                    mathDataSet.set(DataSetMath.integrateFunction(dataSet, new Formatter[0]));
                    break;
                }
                case DIFFERENTIATE: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2202(" + string + ")/\u2202" + string2, string3 + "*" + string5));
                    mathDataSet.set(DataSetMath.derivativeFunction(dataSet, new Formatter[0]));
                    break;
                }
                case DIFFERENTIATE_WITH_SCALLING: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2202(" + string + ")/\u2202" + string2, string3 + "*" + string5));
                    mathDataSet.set(DataSetMath.derivativeFunction(dataSet, d4, new Formatter[0]));
                    break;
                }
                case NORMALISE_TO_INTEGRAL: {
                    FXUtils.runFX(() -> this.yAxis.set("normalised(" + string + ")", "1"));
                    mathDataSet.set(DataSetMath.normalisedFunction(dataSet, new Formatter[0]));
                    break;
                }
                case NORMALISE_TO_INTEGRAL_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("normalised(" + string + ")", Double.toString(d4)));
                    mathDataSet.set(DataSetMath.normalisedFunction(dataSet, d4, new Formatter[0]));
                    break;
                }
                case FILTER_MEAN: {
                    FXUtils.runFX(() -> this.yAxis.set("<" + string + ", " + d4 + ">", string3));
                    mathDataSet.set(DataSetMath.filterFunction(dataSet, d4, DataSetMath.Filter.MEAN, new Formatter[0]));
                    break;
                }
                case FILTER_MEDIAN: {
                    FXUtils.runFX(() -> this.yAxis.set("median(" + string + ", " + d4 + ")", string3));
                    mathDataSet.set(DataSetMath.filterFunction(dataSet, Math.max(3.0, d4), DataSetMath.Filter.MEDIAN, new Formatter[0]));
                    break;
                }
                case FILTER_MIN: {
                    FXUtils.runFX(() -> this.yAxis.set("min(" + string + ", " + d4 + ")", string3));
                    mathDataSet.set(DataSetMath.filterFunction(dataSet, d4, DataSetMath.Filter.MIN, new Formatter[0]));
                    break;
                }
                case FILTER_MAX: {
                    FXUtils.runFX(() -> this.yAxis.set("max(" + string + ", " + d4 + ")", string3));
                    mathDataSet.set(DataSetMath.filterFunction(dataSet, d4, DataSetMath.Filter.MAX, new Formatter[0]));
                    break;
                }
                case FILTER_P2P: {
                    FXUtils.runFX(() -> this.yAxis.set("peak-to-peak(" + string + ", " + d4 + ")", string3));
                    mathDataSet.set(DataSetMath.filterFunction(dataSet, d4, DataSetMath.Filter.P2P, new Formatter[0]));
                    break;
                }
                case FILTER_RMS: {
                    FXUtils.runFX(() -> this.yAxis.set("rms(" + string + ", " + d4 + ")", string3));
                    mathDataSet.set(DataSetMath.filterFunction(dataSet, d4, DataSetMath.Filter.RMS, new Formatter[0]));
                    break;
                }
                case FILTER_GEOMMEAN: {
                    FXUtils.runFX(() -> this.yAxis.set("geo.-mean(" + string + ", " + d4 + ")", string3));
                    mathDataSet.set(DataSetMath.filterFunction(dataSet, d4, DataSetMath.Filter.GEOMMEAN, new Formatter[0]));
                    break;
                }
                case FILTER_LOWPASS_IIR: {
                    FXUtils.runFX(() -> this.yAxis.set("IIR-low-pass(" + string + ", " + d4 + ")", string3));
                    mathDataSet.set(DataSetMath.iirLowPassFilterFunction(dataSet, d4, new Formatter[0]));
                    break;
                }
                case DATASET_SLICE_X: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(0)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeSlice((GridDataSet)dataSet, mathDataSet, 0, d2, new Formatter[0]);
                    break;
                }
                case DATASET_SLICE_Y: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeSlice((GridDataSet)dataSet, mathDataSet, 1, d2, new Formatter[0]);
                    break;
                }
                case DATASET_MEAN_X: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMean((GridDataSet)dataSet, mathDataSet, 0, d2, d3, new Formatter[0]);
                    break;
                }
                case DATASET_MEAN_Y: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMean((GridDataSet)dataSet, mathDataSet, 1, d2, d3, new Formatter[0]);
                    break;
                }
                case DATASET_MIN_X: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMin((GridDataSet)dataSet, mathDataSet, 0, d2, d3, new Formatter[0]);
                    break;
                }
                case DATASET_MIN_Y: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMin((GridDataSet)dataSet, mathDataSet, 1, d2, d3, new Formatter[0]);
                    break;
                }
                case DATASET_MAX_X: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMax((GridDataSet)dataSet, mathDataSet, 0, d2, d3, new Formatter[0]);
                    break;
                }
                case DATASET_MAX_Y: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMax((GridDataSet)dataSet, mathDataSet, 1, d2, d3, new Formatter[0]);
                    break;
                }
                case DATASET_INTEGRAL_X: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeIntegral((GridDataSet)dataSet, mathDataSet, 0, d2, d3, new Formatter[0]);
                    break;
                }
                case DATASET_INTEGRAL_Y: {
                    if (!(dataSet instanceof GridDataSet) || dataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(dataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(dataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeIntegral((GridDataSet)dataSet, mathDataSet, 1, d2, d3, new Formatter[0]);
                    break;
                }
                case FFT_DB: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "dB"));
                    mathDataSet.set(DataSetMath.magnitudeSpectrumDecibel(dataSet));
                    break;
                }
                case FFT_DB_RANGED: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "dB"));
                    DataSet dataSet3 = DataSetMath.getSubRange(dataSet, d2, d3, new Formatter[0]);
                    if ((long)dataSet3.getDataCount() < 4L) break;
                    mathDataSet.set(DataSetMath.magnitudeSpectrumDecibel(dataSet3));
                    break;
                }
                case FFT_NORM_DB: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "dB"));
                    mathDataSet.set(DataSetMath.normalisedMagnitudeSpectrumDecibel(dataSet, new Formatter[0]));
                    break;
                }
                case FFT_NORM_DB_RANGED: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "dB"));
                    DataSet dataSet4 = DataSetMath.getSubRange(dataSet, d2, d3, new Formatter[0]);
                    if ((long)dataSet4.getDataCount() < 4L) break;
                    mathDataSet.set(DataSetMath.normalisedMagnitudeSpectrumDecibel(dataSet4, new Formatter[0]));
                    break;
                }
                case FFT_LIN: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", string5 + "/rtHz"));
                    mathDataSet.set(DataSetMath.magnitudeSpectrum(dataSet, new Formatter[0]));
                    break;
                }
                case FFT_LIN_RANGED: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "/rtHz"));
                    mathDataSet.set(DataSetMath.magnitudeSpectrum(DataSetMath.getSubRange(dataSet, d2, d3, new Formatter[0]), new Formatter[0]));
                    break;
                }
                case CONVERT_TO_DB: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "dB(" + string5 + ")"));
                    mathDataSet.set(DataSetMath.dbFunction(dataSet, new Formatter[0]));
                    break;
                }
                case CONVERT2_TO_DB: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "dB(" + string5 + ")"));
                    mathDataSet.set(DataSetMath.dbFunction(dataSet, dataSet2, new Formatter[0]));
                    break;
                }
                case CONVERT_FROM_DB: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "a.u."));
                    mathDataSet.set(DataSetMath.inversedbFunction(dataSet, new Formatter[0]));
                    break;
                }
                case CONVERT_TO_LOG10: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + ")", "log10"));
                    mathDataSet.set(DataSetMath.log10Function(dataSet, new Formatter[0]));
                    break;
                }
                case CONVERT2_TO_LOG10: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + string + " + " + string6 + ")", "log10"));
                    mathDataSet.set(DataSetMath.log10Function(dataSet, dataSet2, new Formatter[0]));
                    break;
                }
            }
        });
        long l3 = System.nanoTime();
        double d2 = TimeUnit.NANOSECONDS.toMillis(l3 - l2);
        ProcessingProfiler.getTimeDiff(l2, "computation duration of " + this.measType + " for dataSet" + mathDataSet.getName());
        FXUtils.runFX(() -> {
            this.getValueField().setUnit("ms");
            this.getValueField().setValue(d2);
        });
    }

    public static enum MeasurementType {
        ADD_FUNCTIONS(true, MeasurementCategory.MATH, "DataSet1+DataSet2", 0, 2, new String[0]),
        ADD_VALUE(true, MeasurementCategory.MATH, "DataSet1 + value", 0, 1, "value"),
        SUBTRACT_FUNCTIONS(true, MeasurementCategory.MATH, "DataSet1-DataSet2", 0, 2, new String[0]),
        SUBTRACT_VALUE(true, MeasurementCategory.MATH, "DataSet1 - value", 0, 1, "value"),
        MULTIPLY_FUNCTIONS(true, MeasurementCategory.MATH, "DataSet1*DataSet2", 0, 2, new String[0]),
        MULTIPLY_VALUE(true, MeasurementCategory.MATH, "DataSet1 * value", 0, 1, "value"),
        DIVIDE_FUNCTIONS(true, MeasurementCategory.MATH, "DataSet1/DataSet2", 0, 2, new String[0]),
        DIVIDE_VALUE(true, MeasurementCategory.MATH, "DataSet1 / value", 0, 1, "value"),
        SUB_RANGE(true, MeasurementCategory.MATH, "DataSet sub-range", 2, 1, new String[0]),
        ADD_GAUSS_NOISE(true, MeasurementCategory.MATH, "add gaussian noise", 0, 1, "r.m.s. noise"),
        AVG_DATASET_FIR(true, MeasurementCategory.MATH, "average data sets FIR"),
        SQUARE(true, MeasurementCategory.MATH_FUNCTION, "DataSet\u00b2", 0, 1, new String[0]),
        SQUARE_FULL(true, MeasurementCategory.MATH_FUNCTION, "(DataSet1+DataSet2)\u00b2", 0, 2, new String[0]),
        SQUARE_ROOT(true, MeasurementCategory.MATH_FUNCTION, "\u221aDataSet", 0, 1, new String[0]),
        SQUARE_ROOT_FULL(true, MeasurementCategory.MATH_FUNCTION, "\u221a(DataSet1+DataSet2)", 0, 2, new String[0]),
        INTEGRAL(true, MeasurementCategory.MATH_FUNCTION, "\u222bDataSet", 2, 1, new String[0]),
        INTEGRAL_FULL(true, MeasurementCategory.MATH_FUNCTION, "\u222bDataSet full range", 0, 1, new String[0]),
        DIFFERENTIATE(true, MeasurementCategory.MATH_FUNCTION, "\u2202DataSet"),
        DIFFERENTIATE_WITH_SCALLING(true, MeasurementCategory.MATH_FUNCTION, "\u2202DataSet with scalling"),
        NORMALISE_TO_INTEGRAL(true, MeasurementCategory.MATH_FUNCTION, "norm. to integral=1.0", 0, 1, new String[0]),
        NORMALISE_TO_INTEGRAL_VALUE(true, MeasurementCategory.MATH_FUNCTION, "integral value", 0, 1, "norm. to integral=value"),
        FILTER_MEAN(true, MeasurementCategory.FILTER, "LowPass", 0, 1, "filter constant"),
        FILTER_MEDIAN(true, MeasurementCategory.FILTER, "Median", 0, 1, "filter constant"),
        FILTER_MIN(true, MeasurementCategory.FILTER, "Min", 0, 1, "filter constant"),
        FILTER_MAX(true, MeasurementCategory.FILTER, "Max", 0, 1, "filter constant"),
        FILTER_P2P(true, MeasurementCategory.FILTER, "PeakToPeak", 0, 1, "filter constant"),
        FILTER_RMS(true, MeasurementCategory.FILTER, "RMS", 0, 1, "filter constant"),
        FILTER_GEOMMEAN(true, MeasurementCategory.FILTER, "GeometricMean", 0, 1, "filter constant"),
        FILTER_LOWPASS_IIR(true, MeasurementCategory.FILTER, "low-pass (IIR)", 0, 1, "filter constant"),
        DATASET_SLICE_X(false, MeasurementCategory.PROJECTION, "hor. Slice", 1, 1, new String[0]),
        DATASET_SLICE_Y(true, MeasurementCategory.PROJECTION, "ver. Slice", 1, 1, new String[0]),
        DATASET_MEAN_X(false, MeasurementCategory.PROJECTION, "hor. Mean-Projection", 2, 1, new String[0]),
        DATASET_MEAN_Y(true, MeasurementCategory.PROJECTION, "ver. Mean-Projection", 2, 1, new String[0]),
        DATASET_MIN_X(false, MeasurementCategory.PROJECTION, "hor. Min-Projection", 2, 1, new String[0]),
        DATASET_MIN_Y(true, MeasurementCategory.PROJECTION, "ver. Min-Projection", 2, 1, new String[0]),
        DATASET_MAX_X(false, MeasurementCategory.PROJECTION, "hor. Max-Projection", 2, 1, new String[0]),
        DATASET_MAX_Y(true, MeasurementCategory.PROJECTION, "ver. Max-Projection", 2, 1, new String[0]),
        DATASET_INTEGRAL_X(false, MeasurementCategory.PROJECTION, "hor. Integral-Projection", 2, 1, new String[0]),
        DATASET_INTEGRAL_Y(true, MeasurementCategory.PROJECTION, "ver. Integral-Projection", 2, 1, new String[0]),
        FFT_DB(true, MeasurementCategory.FOURIER, "FFT [dB]", 0, 1, new String[0]),
        FFT_DB_RANGED(true, MeasurementCategory.FOURIER, "FFT within range [dB]", 2, 1, new String[0]),
        FFT_NORM_DB(true, MeasurementCategory.FOURIER, "FFT - normalised frequency [dB]", 0, 1, new String[0]),
        FFT_NORM_DB_RANGED(true, MeasurementCategory.FOURIER, "FFT - norm. & ranged [dB]", 2, 1, new String[0]),
        FFT_LIN(true, MeasurementCategory.FOURIER, "FFT [lin]", 0, 1, new String[0]),
        FFT_LIN_RANGED(true, MeasurementCategory.FOURIER, "FFT within range [lin]", 2, 1, new String[0]),
        CONVERT_TO_DB(true, MeasurementCategory.FOURIER, "convert DataSet to dB", 0, 1, new String[0]),
        CONVERT2_TO_DB(true, MeasurementCategory.FOURIER, "convert sum of DataSets to dB", 0, 2, new String[0]),
        CONVERT_FROM_DB(true, MeasurementCategory.FOURIER, "convert DataSet from dB", 0, 1, new String[0]),
        CONVERT_TO_LOG10(true, MeasurementCategory.FOURIER, "convert DataSet to log10", 0, 1, new String[0]),
        CONVERT2_TO_LOG10(true, MeasurementCategory.FOURIER, "convert sum of DataSets to log10", 0, 2, new String[0]);

        private final String name;
        private final MeasurementCategory category;
        private final List<String> controlParameterNames = new ArrayList<String>();
        private final int requiredSelectors;
        private final int requiredDataSets;
        private final boolean isVertical;

        private MeasurementType(boolean bl2, MeasurementCategory measurementCategory, String string2) {
            this(bl2, measurementCategory, string2, 2, 1, new String[0]);
        }

        private MeasurementType(boolean bl2, MeasurementCategory measurementCategory, String string2, int n3, int n4, String ... stringArray) {
            this.isVertical = bl2;
            this.category = measurementCategory;
            this.name = string2;
            if (stringArray != null) {
                this.controlParameterNames.addAll(Arrays.asList(stringArray));
            }
            this.requiredSelectors = n3;
            this.requiredDataSets = n4;
        }

        public MeasurementCategory getCategory() {
            return this.category;
        }

        public List<String> getControlParameterNames() {
            return this.controlParameterNames;
        }

        public String getName() {
            return this.name;
        }

        public int getRequiredDataSets() {
            return this.requiredDataSets;
        }

        public int getRequiredSelectors() {
            return this.requiredSelectors;
        }

        public boolean isVerticalMeasurement() {
            return this.isVertical;
        }
    }

    protected class ExternalStage
    extends Stage {
        private final StateListener titleListener = (bitState, n2) -> FXUtils.runFX(() -> this.setTitle(DataSetMeasurements.this.mathDataSet.getName()));

        public ExternalStage() {
            XYChart xYChart = new XYChart(DataSetMeasurements.this.xAxis, DataSetMeasurements.this.yAxis);
            xYChart.getRenderers().setAll((Object[])new Renderer[]{new MetaDataRenderer(xYChart)});
            xYChart.applyCss();
            xYChart.getPlugins().add((Object)new ParameterMeasurements());
            xYChart.getPlugins().add((Object)new Screenshot());
            xYChart.getPlugins().add((Object)new EditAxis());
            Zoomer zoomer = new Zoomer();
            zoomer.setUpdateTickUnit(true);
            zoomer.setAutoZoomEnabled(true);
            zoomer.setAddButtonsToToolBar(false);
            xYChart.getPlugins().add((Object)zoomer);
            xYChart.getPlugins().add((Object)new DataPointTooltip());
            xYChart.getPlugins().add((Object)new TableViewer());
            Scene scene = new Scene((Parent)xYChart, 640.0, 480.0);
            this.setScene(scene);
            FXUtils.runFX(() -> ((ExternalStage)this).show());
            FXUtils.runFX(() -> {
                DataSetMeasurements.this.localChart.set((Object)xYChart);
                DataSetMeasurements.this.xAxis.setSide(Side.BOTTOM);
                DataSetMeasurements.this.yAxis.setSide(Side.LEFT);
            });
            this.setOnCloseRequest(windowEvent -> {
                xYChart.getAxes().clear();
                DataSetMeasurements.this.xAxis.setSide(Side.TOP);
                DataSetMeasurements.this.yAxis.setSide(Side.RIGHT);
                DataSetMeasurements.this.graphDetached.set(false);
            });
        }
    }

    public static enum MeasurementCategory {
        MATH("Math - Basic"),
        MATH_FUNCTION("Math - Functions"),
        FILTER("DataSet Filtering"),
        PROJECTION("DataSet Projections"),
        FOURIER("Spectral Transforms");

        private final String name;

        private MeasurementCategory(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }
}

