/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements;

import impl.org.controlsfx.skin.DecorationPane;
import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisMode;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.plugins.AbstractValueIndicator;
import io.fair_acc.chartfx.plugins.ParameterMeasurements;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.plugins.YValueIndicator;
import io.fair_acc.chartfx.plugins.measurements.utils.CheckedValueField;
import io.fair_acc.chartfx.plugins.measurements.utils.DataSetSelector;
import io.fair_acc.chartfx.plugins.measurements.utils.ValueIndicatorSelector;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.utils.MouseUtils;
import io.fair_acc.chartfx.viewer.DataViewWindow;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.EventSource;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChartMeasurement
implements EventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractChartMeasurement.class);
    private final BitState state = BitState.initDirty(this);
    private static final int MIN_DRAG_BORDER_WIDTH = 30;
    protected static final double DEFAULT_MIN = Double.NEGATIVE_INFINITY;
    protected static final double DEFAULT_MAX = Double.POSITIVE_INFINITY;
    protected static final long DEFAULT_UPDATE_RATE_LIMIT = 40L;
    protected static final int SMALL_FORMAT_THRESHOLD = 3;
    private static final String FORMAT_SMALL_SCALE = "0.###";
    private static final String FORMAT_LARGE_SCALE = "0.##E0";
    public static final int DEFAULT_SMALL_AXIS = 6;
    protected final DecimalFormat formatterSmall = new DecimalFormat("0.###");
    protected final DecimalFormat formatterLarge = new DecimalFormat("0.##E0");
    private final CheckedValueField valueField = new CheckedValueField();
    private final StringProperty title = new SimpleStringProperty((Object)this, "title", null);
    private final ObjectProperty<DataSet> dataSet = new SimpleObjectProperty((Object)this, "dataSet", null);
    private final DataViewWindow dataViewWindow = new DataViewWindow("not initialised", (Node)new Label("content to be filled"), DataViewWindow.WindowDecoration.FRAME);
    protected final Alert alert;
    protected final ButtonType buttonOK = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
    protected final ButtonType buttonDefault = new ButtonType("Defaults", ButtonBar.ButtonData.OK_DONE);
    protected final ButtonType buttonRemove = new ButtonType("Remove", ButtonBar.ButtonData.RIGHT);
    protected final DataSetSelector dataSetSelector;
    protected final ValueIndicatorSelector valueIndicatorSelector;
    protected int lastLayoutRow;
    protected final int requiredNumberOfIndicators;
    protected final int requiredNumberOfDataSets;
    protected final GridPane gridPane = new GridPane();
    private final ParameterMeasurements plugin;
    private final String measurementName;
    protected final AxisMode axisMode;
    private final EventHandler<? super MouseEvent> mouseHandler = mouseEvent -> {
        Bounds bounds = this.dataViewWindow.localToScreen(this.dataViewWindow.getBoundsInLocal());
        Point2D point2D = new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY());
        double d2 = MouseUtils.mouseInsideBoundaryBoxDistance(bounds, point2D);
        if (MouseButton.SECONDARY == mouseEvent.getButton() && d2 > 30.0 && mouseEvent.getClickCount() < 2) {
            this.showConfigDialogue();
            return;
        }
        if (MouseButton.SECONDARY == mouseEvent.getButton() && mouseEvent.getClickCount() >= 2) {
            this.dataViewWindow.setMinWidth(-1.0);
            this.dataViewWindow.setMinHeight(-1.0);
            this.dataViewWindow.setPrefWidth(-1.0);
            this.dataViewWindow.setPrefHeight(-1.0);
        }
    };
    private final ChangeListener<? super DataSet> dataSetChangeListener = (observableValue, dataSet, dataSet2) -> {
        if (dataSet != null) {
            dataSet.removeListener(this);
        }
        if (dataSet2 == null) {
            this.getValueField().setDataSetName("<unknown data set>");
        } else {
            dataSet2.addListener(this);
            this.getValueField().setDataSetName("<" + dataSet2.getName() + ">");
        }
    };
    private final ListChangeListener<? super AbstractSingleValueIndicator> valueIndicatorsUserChangeListener = change -> {
        while (change.next()) {
            change.getRemoved().forEach(abstractSingleValueIndicator -> abstractSingleValueIndicator.removeListener(this));
            change.getAddedSubList().forEach(abstractSingleValueIndicator -> abstractSingleValueIndicator.addListener(this));
        }
    };

    public AbstractChartMeasurement(ParameterMeasurements parameterMeasurements, String string, AxisMode axisMode, int n2, int n3) {
        if (parameterMeasurements == null) {
            throw new IllegalArgumentException("plugin is null");
        }
        this.plugin = parameterMeasurements;
        this.measurementName = string;
        this.axisMode = axisMode;
        this.requiredNumberOfIndicators = n2;
        this.requiredNumberOfDataSets = n3;
        parameterMeasurements.getChartMeasurements().add((Object)this);
        this.alert = new Alert(Alert.AlertType.CONFIRMATION);
        this.alert.setTitle("Measurement Config Dialog");
        this.alert.setHeaderText("Please, select data set and/or other parameters:");
        this.alert.initModality(Modality.APPLICATION_MODAL);
        DecorationPane decorationPane = new DecorationPane();
        decorationPane.getChildren().add((Object)this.gridPane);
        this.alert.getDialogPane().setContent((Node)decorationPane);
        this.alert.getButtonTypes().setAll((Object[])new ButtonType[]{this.buttonOK, this.buttonDefault, this.buttonRemove});
        this.alert.setOnCloseRequest(dialogEvent -> this.alert.close());
        this.dataSetSelector = new DataSetSelector(parameterMeasurements, n3);
        if (this.dataSetSelector.getNumberDataSets() >= 1) {
            this.lastLayoutRow = AbstractChartMeasurement.shiftGridPaneRowOffset((List<Node>)this.dataSetSelector.getChildren(), this.lastLayoutRow);
            this.gridPane.getChildren().addAll((Collection)this.dataSetSelector.getChildren());
        }
        this.valueIndicatorSelector = new ValueIndicatorSelector(parameterMeasurements, axisMode, n2);
        this.lastLayoutRow = AbstractChartMeasurement.shiftGridPaneRowOffset((List<Node>)this.valueIndicatorSelector.getChildren(), this.lastLayoutRow);
        this.gridPane.getChildren().addAll((Collection)this.valueIndicatorSelector.getChildren());
        this.valueField.setMouseTransparent(true);
        GridPane.setVgrow((Node)this.dataViewWindow, (Priority)Priority.NEVER);
        this.dataViewWindow.setOnMouseClicked(this.mouseHandler);
        this.getValueIndicatorsUser().addListener(this.valueIndicatorsUserChangeListener);
        this.dataViewWindow.nameProperty().bindBidirectional((Property)this.title);
        this.setTitle(this.getClass().getSimpleName());
        this.dataSet.addListener(this.dataSetChangeListener);
        this.dataSetChangeListener.changed(this.dataSet, null, null);
        this.getMeasurementPlugin().getDataView().getVisibleChildren().add((Object)this.dataViewWindow);
    }

    public ObjectProperty<DataSet> dataSetProperty() {
        return this.dataSet;
    }

    public DataSet getDataSet() {
        return (DataSet)this.dataSetProperty().get();
    }

    public DataViewWindow getDataViewWindow() {
        return this.dataViewWindow;
    }

    public ParameterMeasurements getMeasurementPlugin() {
        return this.plugin;
    }

    public String getTitle() {
        return (String)this.titleProperty().get();
    }

    public CheckedValueField getValueField() {
        return this.valueField;
    }

    public ObservableList<AbstractSingleValueIndicator> getValueIndicators() {
        return this.valueIndicatorSelector.getValueIndicators();
    }

    public ObservableList<AbstractSingleValueIndicator> getValueIndicatorsUser() {
        return this.valueIndicatorSelector.getValueIndicatorsUser();
    }

    public abstract void initialize();

    public void setDataSet(DataSet dataSet) {
        this.dataSetProperty().set((Object)dataSet);
    }

    public void setTitle(String string) {
        this.titleProperty().set((Object)string);
    }

    public Optional<ButtonType> showConfigDialogue() {
        Optional optional;
        if (this.alert.isShowing()) {
            return Optional.empty();
        }
        if (this.getMeasurementPlugin() != null && this.getMeasurementPlugin().getChart() != null && this.getMeasurementPlugin().getChart().getScene() != null) {
            optional = (Stage)this.getMeasurementPlugin().getChart().getScene().getWindow();
            this.alert.setX(optional.getX() + optional.getWidth() / 5.0);
            this.alert.setY(optional.getY() + optional.getHeight() / 5.0);
        }
        if ((optional = this.alert.showAndWait()).isEmpty() || ((ButtonType)optional.get()).getButtonData() == null) {
            this.defaultAction(optional);
            this.alert.close();
            return Optional.empty();
        }
        if (((ButtonType)optional.get()).equals(this.buttonOK)) {
            this.nominalAction();
        } else if (((ButtonType)optional.get()).equals(this.buttonRemove)) {
            this.removeAction();
        } else {
            this.defaultAction(optional);
        }
        this.alert.close();
        return optional;
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    @Override
    public BitState getBitState() {
        return this.state;
    }

    public DoubleProperty valueProperty() {
        return this.valueField.valueProperty();
    }

    protected void addMinMaxRangeFields() {
        Label label = new Label("Min. Range: ");
        GridPane.setConstraints((Node)label, (int)0, (int)this.lastLayoutRow);
        GridPane.setConstraints((Node)this.getValueField().getMinRangeTextField(), (int)1, (int)this.lastLayoutRow);
        Label label2 = new Label(" " + this.getValueField().getMinRange());
        this.getValueField().minRangeProperty().addListener((observableValue, number, number2) -> label2.setText(" " + number2.toString()));
        GridPane.setConstraints((Node)label2, (int)2, (int)this.lastLayoutRow);
        this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{label, this.getValueField().getMinRangeTextField(), label2});
        ++this.lastLayoutRow;
        Label label3 = new Label("Max. Range: ");
        GridPane.setConstraints((Node)label3, (int)0, (int)this.lastLayoutRow);
        GridPane.setConstraints((Node)this.getValueField().getMaxRangeTextField(), (int)1, (int)this.lastLayoutRow);
        Label label4 = new Label(" " + this.getValueField().getMaxRange());
        this.getValueField().maxRangeProperty().addListener((observableValue, number, number2) -> label4.setText(" " + number2.toString()));
        GridPane.setConstraints((Node)label4, (int)2, (int)this.lastLayoutRow);
        this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{label3, this.getValueField().getMaxRangeTextField(), label4});
    }

    protected void defaultAction(Optional<ButtonType> optional) {
        this.setDataSet(null);
        this.getValueField().resetRanges();
        this.updateSlider();
    }

    protected GridPane getDialogContentBox() {
        return this.gridPane;
    }

    protected void nominalAction() {
        this.valueField.evaluateMinRangeText(true);
        this.valueField.evaluateMaxRangeText(true);
        this.setDataSet(this.dataSetSelector.getSelectedDataSet());
        this.updateSlider();
    }

    protected void removeAction() {
        ArrayList arrayList = new ArrayList();
        this.getValueIndicatorsUser().forEach(abstractSingleValueIndicator -> {
            if (!abstractSingleValueIndicator.isAutoRemove()) {
                return;
            }
            boolean bl2 = this.plugin.getChartMeasurements().stream().anyMatch(abstractChartMeasurement -> abstractChartMeasurement != this && abstractChartMeasurement.getValueIndicatorsUser().contains(abstractSingleValueIndicator));
            if (!bl2) {
                arrayList.add(abstractSingleValueIndicator);
            }
        });
        this.plugin.getChart().getPlugins().removeAll(arrayList);
        this.getMeasurementPlugin().getChartMeasurements().remove((Object)this);
        this.getMeasurementPlugin().getDataView().getChildren().remove((Object)this.dataViewWindow);
        this.getMeasurementPlugin().getDataView().getVisibleChildren().remove((Object)this.dataViewWindow);
        this.getMeasurementPlugin().getDataView().getUndockedChildren().remove((Object)this.dataViewWindow);
        this.getValueIndicatorsUser().removeListener(this.valueIndicatorsUserChangeListener);
        this.removeSliderChangeListener();
    }

    protected void removeSliderChangeListener() {
        Chart chart = this.getMeasurementPlugin().getChart();
        if (chart == null) {
            return;
        }
        List<AbstractSingleValueIndicator> list = chart.getPlugins().stream().filter(chartPlugin -> chartPlugin instanceof AbstractSingleValueIndicator).map(chartPlugin -> (AbstractSingleValueIndicator)chartPlugin).collect(Collectors.toList());
        list.forEach(abstractSingleValueIndicator -> {
            abstractSingleValueIndicator.removeListener(this);
            this.getValueIndicatorsUser().remove(abstractSingleValueIndicator);
        });
    }

    protected void updateSlider() {
        if (!this.valueIndicatorSelector.isReuseIndicators()) {
            this.getValueIndicatorsUser().clear();
        }
        for (int i2 = 0; i2 < this.requiredNumberOfIndicators; ++i2) {
            this.updateSlider(i2);
        }
    }

    protected AbstractSingleValueIndicator updateSlider(int n2) {
        AbstractValueIndicator abstractValueIndicator;
        ObservableList<AbstractSingleValueIndicator> observableList = this.getValueIndicatorsUser();
        boolean bl2 = this.valueIndicatorSelector.isReuseIndicators();
        int n3 = observableList.size();
        AbstractValueIndicator abstractValueIndicator2 = abstractValueIndicator = bl2 && n3 >= n2 + 1 ? (AbstractSingleValueIndicator)observableList.get(n2) : null;
        if (abstractValueIndicator == null) {
            Chart chart = this.getMeasurementPlugin().getChart();
            Axis axis = AbstractChartMeasurement.getFirstAxisForDataSet(chart, this.getDataSet(), this.axisMode == AxisMode.X);
            double d2 = axis.getMin();
            double d3 = axis.getMax();
            double d4 = 0.5 * Math.abs(d3 - d2);
            double d5 = Math.min(d2, d3);
            abstractValueIndicator = this.axisMode == AxisMode.X ? new XValueIndicator(axis, d5) : new YValueIndicator(axis, d5);
            abstractValueIndicator.setText(this.measurementName + "#" + n2);
            ((AbstractSingleValueIndicator)abstractValueIndicator).setValue(d5 + ((double)n2 + 0.5) * d4);
            ((AbstractSingleValueIndicator)abstractValueIndicator).setAutoRemove(true);
            this.getValueIndicatorsUser().add((Object)abstractValueIndicator);
            this.getMeasurementPlugin().getChart().getPlugins().add((Object)abstractValueIndicator);
        }
        if (!abstractValueIndicator.getBitState().getChangeListeners().contains(this)) {
            abstractValueIndicator.addListener(this);
        }
        return abstractValueIndicator;
    }

    protected static Axis getFirstAxisForDataSet(Chart chart, DataSet dataSet, boolean bl2) {
        if (dataSet == null) {
            return chart.getFirstAxis(bl2 ? Orientation.HORIZONTAL : Orientation.VERTICAL);
        }
        for (Renderer renderer : chart.getRenderers()) {
            if (!renderer.getDatasets().contains((Object)dataSet)) continue;
            for (Axis axis : renderer.getAxes()) {
                if ((!axis.getSide().isHorizontal() || !bl2) && (!axis.getSide().isVertical() || bl2)) continue;
                return axis;
            }
        }
        return chart.getFirstAxis(bl2 ? Orientation.HORIZONTAL : Orientation.VERTICAL);
    }

    protected static int shiftGridPaneRowOffset(List<Node> list, int n2) {
        int n3 = 0;
        for (Node node : list) {
            Integer n4 = GridPane.getRowIndex((Node)node);
            if (n4 == null) {
                LOGGER.atWarn().addArgument(node).addArgument(n2).log("node {} has not a GridPane::rowIndex being set -> set to {}");
                GridPane.setRowIndex((Node)node, (Integer)n2);
                continue;
            }
            n3 = Math.max(n3, n4);
            GridPane.setRowIndex((Node)node, (Integer)(n4 + n2));
        }
        return n2 + n3 + 1;
    }

    public boolean onWorkerThread() {
        return false;
    }
}

