/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.plugins.ValueIndicator;
import io.fair_acc.chartfx.ui.geometry.Side;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class YValueIndicator
extends AbstractSingleValueIndicator
implements ValueIndicator {
    public YValueIndicator(Axis axis, double d2) {
        this(axis, d2, null);
    }

    public YValueIndicator(Axis axis, double d2, String string) {
        super(axis, d2, string);
        this.setLabelHorizontalAnchor(HPos.RIGHT);
        this.setLabelPosition(0.975);
        this.pickLine.setOnMouseDragged(this::handleDragMouseEvent);
        this.triangle.setOnMouseDragged(this::handleDragMouseEvent);
        this.label.setOnMouseDragged(this::handleDragMouseEvent);
    }

    protected void handleDragMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEditable()) {
            return;
        }
        Point2D point2D = this.getChart().getPlotArea().sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        double d2 = this.getAxis().getValueForDisplay(point2D.getY() - this.dragDelta.y);
        if (this.getAxis().isValueOnAxis(d2)) {
            this.valueProperty().set(d2);
        }
        mouseEvent.consume();
        this.runPostLayout();
    }

    @Override
    public void runPostLayout() {
        double d2;
        if (this.getChart() == null) {
            return;
        }
        Bounds bounds = this.getChart().getCanvas().getBoundsInLocal();
        double d3 = bounds.getMinX();
        double d4 = bounds.getMaxX();
        double d5 = bounds.getMinY();
        double d6 = bounds.getMaxY();
        double d7 = d5 + this.getAxis().getDisplayPosition(this.getValue());
        if (this.getAxis().getSide().equals((Object)Side.RIGHT)) {
            d2 = this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(0.0, 0.0)).getX() + 2.0;
            this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, 8.0, 8.0, 8.0, -8.0});
        } else {
            d2 = this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(this.getAxis().getWidth(), 0.0)).getX() - 2.0;
            this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, -8.0, 8.0, -8.0, -8.0});
        }
        double d8 = this.getChart().getPlotForeground().sceneToLocal(this.getChart().getCanvas().localToScene(0.0, d7)).getY();
        if (d7 < d5 || d7 > d6) {
            this.getChartChildren().clear();
        } else {
            this.layoutLine(d3, d7, d4, d7);
            this.layoutMarker(d2, d8, d3, d7);
            this.layoutLabel((Bounds)new BoundingBox(d3, d7, d4 - d3, 0.0), this.getLabelPosition(), 0.5);
        }
    }

    @Override
    public void updateStyleClass() {
        this.setStyleClasses((Node)this.label, "y-", "value-indicator-label");
        this.setStyleClasses((Node)this.line, "y-", "value-indicator-line");
        this.setStyleClasses((Node)this.triangle, "x-", "value-indicator-marker");
    }
}

