/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.utils.WriteFxImage;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.DataSetUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Screenshot
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Screenshot.class);
    private static final String ICON_CAMERA = "fas-camera-retro:20";
    private static final String ICON_CLIPBOARD = "far-clipboard:20";
    private static final String ICON_CLIPBOARD_SMALL = "far-clipboard:11";
    private static final String ICON_FILE = "fa-files-o:20";
    private static final String ICON_FILE_SMALL = "fa-files-o:11";
    private static final String ICON_WRENCH = "fa-wrench:20";
    private final HBox screenshotButtons = this.getScreenshotInteractorBar();
    private final StringProperty pattern = new SimpleStringProperty((Object)this, "pattern", "");
    private final StringProperty directory = new SimpleStringProperty((Object)this, "directory", System.getProperty("user.home"));
    private boolean toFile = false;

    public Screenshot() {
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                chart.getToolBar().getChildren().remove((Object)this.screenshotButtons);
            }
            if (chart2 != null && this.isAddButtonsToToolBar()) {
                chart2.getToolBar().getChildren().add((Object)this.screenshotButtons);
            }
        });
    }

    public StringProperty patternProperty() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.patternProperty().set((Object)string);
    }

    public String getPattern() {
        return (String)this.patternProperty().get();
    }

    public StringProperty directoryProperty() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directoryProperty().set((Object)string);
    }

    public String getDirectory() {
        return (String)this.directoryProperty().get();
    }

    public HBox getScreenshotInteractorBar() {
        HBox hBox = new HBox();
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        SplitMenuButton splitMenuButton = new SplitMenuButton();
        splitMenuButton.setGraphic((Node)new HBox(0.1, new Node[]{new FontIcon(ICON_CAMERA), new FontIcon(ICON_CLIPBOARD_SMALL)}));
        splitMenuButton.setOnAction(actionEvent -> {
            if (this.toFile) {
                this.screenshotToFile(true);
            } else {
                this.screenshotToClipboard();
            }
        });
        MenuItem menuItem = new MenuItem("Screenshot to clipboard", (Node)new FontIcon(ICON_CLIPBOARD));
        menuItem.setOnAction(actionEvent -> {
            this.toFile = false;
            splitMenuButton.setGraphic((Node)new HBox(0.1, new Node[]{new FontIcon(ICON_CAMERA), new FontIcon(ICON_CLIPBOARD_SMALL)}));
            splitMenuButton.setTooltip(new Tooltip("Copy screenshot of plot to Clipboard"));
            this.screenshotToClipboard();
        });
        MenuItem menuItem2 = new MenuItem("Screenshot to file", (Node)new FontIcon(ICON_FILE));
        menuItem2.setOnAction(actionEvent -> {
            this.toFile = true;
            splitMenuButton.setGraphic((Node)new HBox(0.1, new Node[]{new FontIcon(ICON_CAMERA), new FontIcon(ICON_FILE_SMALL)}));
            splitMenuButton.setTooltip(new Tooltip("Save plot as image"));
            this.screenshotToFile(true);
        });
        MenuItem menuItem3 = new MenuItem("Screenshot settings", (Node)new FontIcon(ICON_WRENCH));
        menuItem3.setOnAction(actionEvent -> {
            ScreenshotDialog screenshotDialog = new ScreenshotDialog();
            screenshotDialog.showAndWait().filter(buttonType -> buttonType == ButtonType.OK).ifPresent(buttonType -> {
                this.directory.set((Object)screenshotDialog.getDirectory());
                this.pattern.set((Object)screenshotDialog.getPattern());
            });
        });
        splitMenuButton.getItems().addAll((Object[])new MenuItem[]{menuItem, menuItem2, new SeparatorMenuItem(), menuItem3});
        hBox.getChildren().addAll((Object[])new Node[]{separator, splitMenuButton});
        return hBox;
    }

    public void screenshotToClipboard() {
        Image image = this.getScreenshot();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putImage(image);
        clipboard.setContent((Map)clipboardContent);
        LOGGER.atInfo().log("Copied screenshot to clipboard");
    }

    public void screenshotToFile(boolean bl2) {
        File file;
        Image image = this.getScreenshot();
        File file2 = file = bl2 ? this.showFileDialog(this.generateScreenshotName()) : new File(this.getDirectory(), this.generateScreenshotName());
        if (file == null) {
            return;
        }
        Screenshot.saveImage(image, file);
        LOGGER.atInfo().addArgument(file.getName()).log("Saved screenshot to {}");
    }

    public String generateScreenshotName() {
        String string = !this.getPattern().isEmpty() ? (this.getChart().getAllDatasets().isEmpty() ? DataSetUtils.getFileName(null, this.getPattern()) : DataSetUtils.getFileName((DataSet)this.getChart().getAllDatasets().get(0), this.getPattern())) : (this.getChart().getTitle() != null && !this.getChart().getTitle().isBlank() ? this.getChart().getTitle() : (!this.getChart().getAllDatasets().isEmpty() && ((DataSet)this.getChart().getAllDatasets().get(0)).getName() != null && !((DataSet)this.getChart().getAllDatasets().get(0)).getName().isBlank() ? ((DataSet)this.getChart().getAllDatasets().get(0)).getName() : (this.getChart().getId() != null && !this.getChart().getId().isBlank() ? this.getChart().getId() : "UnknownChart")));
        return string;
    }

    public Image getScreenshot() {
        SnapshotParameters snapshotParameters = new SnapshotParameters();
        boolean bl2 = this.getChart().getToolBar().isVisible();
        this.getChart().getToolBar().setVisible(false);
        WritableImage writableImage = this.getChart().snapshot(snapshotParameters, null);
        this.getChart().getToolBar().setVisible(bl2);
        return writableImage;
    }

    private static void saveImage(Image image, File file) {
        try {
            WriteFxImage.savePng(image, file);
        }
        catch (IOException iOException) {
            LOGGER.atError().addArgument(file.getName()).log("Error saving screenshot to {}");
        }
    }

    private File showFileDialog(String string) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("PNG-Image", new String[]{"*.png"})});
        fileChooser.setInitialDirectory(new File((String)this.directory.get()));
        fileChooser.setInitialFileName(string);
        File file = fileChooser.showSaveDialog(this.getChart().getScene().getWindow());
        if (file != null && !this.directory.isBound()) {
            this.directory.set((Object)file.getParent());
        }
        return file;
    }

    protected class ScreenshotDialog
    extends Alert {
        private final TextField dirTextbox;
        private final TextField patternTextbox;

        public ScreenshotDialog() {
            super(Alert.AlertType.CONFIRMATION, "Screenshot Settings", new ButtonType[0]);
            GridPane gridPane = new GridPane();
            this.dirTextbox = new TextField((String)Screenshot.this.directory.get());
            gridPane.add((Node)new Label("directory: "), 0, 0);
            gridPane.add((Node)this.dirTextbox, 1, 0);
            Button button = new Button("choose...");
            gridPane.add((Node)button, 2, 0);
            this.patternTextbox = new TextField((String)Screenshot.this.pattern.get());
            gridPane.add((Node)new Label("pattern: "), 0, 1);
            gridPane.add((Node)this.patternTextbox, 1, 1, 2, 1);
            this.patternTextbox.setTooltip(new Tooltip("Pattern:\n {datafield;type;format} style placeholders.\nDatafield:\n - systemTime: current system time\n - dataSetName\n - xMin, xMax, yMin, yMax\n - metadata field\ntype:\n - string(default)\n - date\n - int long\n - float/double\nformat:\n - date: e.g. yyyyMMdd_HHmmss\n - numeric data: printf formats e.g. %d, %e"));
            button.setOnAction(actionEvent -> {
                DirectoryChooser directoryChooser = new DirectoryChooser();
                File file = new File(this.dirTextbox.getText());
                if (!file.isDirectory()) {
                    file = new File((String)Screenshot.this.directory.get());
                }
                if (!file.isDirectory()) {
                    file = new File(System.getProperty("user.home"));
                }
                directoryChooser.setInitialDirectory(file);
                File file2 = directoryChooser.showDialog(Screenshot.this.getChart().getScene().getWindow());
                if (file2 != null) {
                    this.dirTextbox.setText(file2.getPath());
                }
            });
            this.getDialogPane().setContent((Node)gridPane);
        }

        public String getPattern() {
            return this.patternTextbox.getText();
        }

        public String getDirectory() {
            return this.dirTextbox.getText();
        }
    }
}

