/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.bench.Measurable;
import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.dataset.spi.utils.Tuple;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChartPlugin
implements Measurable.EmptyDefault {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartPlugin.class);
    private final ObservableList<Node> chartChildren = FXCollections.observableArrayList();
    private final List<Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>>> mouseEventHandlers = new LinkedList<Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>>>();
    private final ObjectProperty<Chart> chart = new SimpleObjectProperty((Object)this, "chart");
    private final BooleanProperty addButtonsToToolBar = new SimpleBooleanProperty((Object)this, "addButtonsToToolBar", true);

    protected ChartPlugin() {
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                this.removeEventHandlers((Node)chart.getPlotArea());
                this.removeEventHandlers((Node)chart.getPlotBackground());
            }
            if (chart2 != null) {
                this.addEventHandlers((Node)chart2.getPlotArea());
                this.addEventHandlers((Node)chart2.getPlotBackground());
            }
        });
    }

    public final BooleanProperty addButtonsToToolBarProperty() {
        return this.addButtonsToToolBar;
    }

    private <T extends InputEvent> void addEventHandlers(Node node) {
        if (node == null) {
            return;
        }
        for (Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>> pair : this.mouseEventHandlers) {
            EventType eventType = (EventType)pair.getKey();
            EventHandler eventHandler = (EventHandler)pair.getValue();
            node.addEventHandler(eventType, eventHandler);
            node.sceneProperty().addListener((observableValue, scene, scene2) -> {
                if (scene == scene2) {
                    return;
                }
                if (scene != null) {
                    scene.removeEventHandler(eventType, eventHandler);
                }
                if (scene2 != null) {
                    scene2.addEventHandler(eventType, eventHandler);
                }
            });
        }
    }

    public final ObjectProperty<Chart> chartProperty() {
        return this.chart;
    }

    public final Chart getChart() {
        return (Chart)this.chartProperty().get();
    }

    public final ObservableList<Node> getChartChildren() {
        return this.chartChildren;
    }

    protected final Point2D getLocationInPlotArea(MouseEvent mouseEvent) {
        Point2D point2D = new Point2D(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        Chart chart = this.getChart();
        if (!(chart instanceof XYChart)) {
            return null;
        }
        XYChart xYChart = (XYChart)chart;
        double d2 = ((Node)xYChart.getXAxis()).sceneToLocal(point2D).getX();
        double d3 = ((Node)xYChart.getYAxis()).sceneToLocal(point2D).getY();
        return new Point2D(d2, d3);
    }

    protected boolean isMouseEventWithinCanvas(MouseEvent mouseEvent) {
        Canvas canvas = this.getChart().getCanvas();
        Point2D point2D = canvas.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        return canvas.getBoundsInLocal().contains(point2D);
    }

    protected boolean isMouseEventWithinCanvas(ScrollEvent scrollEvent) {
        Canvas canvas = this.getChart().getCanvas();
        Point2D point2D = canvas.sceneToLocal(scrollEvent.getSceneX(), scrollEvent.getSceneY());
        return canvas.getBoundsInLocal().contains(point2D);
    }

    public final boolean isAddButtonsToToolBar() {
        return this.addButtonsToToolBarProperty().get();
    }

    public void runPreLayout() {
    }

    public void layoutChildren() {
    }

    public void runPostLayout() {
    }

    protected final <T extends InputEvent> void registerInputEventHandler(EventType<T> eventType, EventHandler<T> eventHandler) {
        this.mouseEventHandlers.add((Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>>)new Pair(eventType, eventHandler));
    }

    private <T extends InputEvent> void removeEventHandlers(Node node) {
        if (node == null) {
            return;
        }
        for (Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>> pair : this.mouseEventHandlers) {
            EventType eventType = (EventType)pair.getKey();
            EventHandler eventHandler = (EventHandler)pair.getValue();
            node.removeEventHandler(eventType, eventHandler);
            if (node.getScene() == null) continue;
            node.getScene().removeEventFilter(eventType, eventHandler);
        }
    }

    public final void setAddButtonsToToolBar(boolean bl2) {
        this.addButtonsToToolBarProperty().set(bl2);
    }

    public final void setChart(Chart chart) {
        this.chartProperty().set((Object)chart);
    }

    protected final Tuple<Number, Number> toDataPoint(Axis axis, Point2D point2D) {
        Chart chart = this.getChart();
        if (!(chart instanceof XYChart)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().addArgument(chart).log("chart '{}' is not of type XYChart returning null");
            }
            return null;
        }
        XYChart xYChart = (XYChart)chart;
        return new Tuple<Number, Number>(xYChart.getXAxis().getValueForDisplay(point2D.getX()), axis.getValueForDisplay(point2D.getY()));
    }

    protected final Point2D toDisplayPoint(Axis axis, double d2, double d3) {
        return new Point2D(((XYChart)this.getChart()).getXAxis().getDisplayPosition(d2), axis.getDisplayPosition(d3));
    }
}

