/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.bench;

import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.bench.TimeMeasure;
import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.bench.CircularDoubleDataSet2D;
import io.fair_acc.chartfx.bench.HdrHistogramDataSet;
import io.fair_acc.chartfx.bench.PercentileAxis;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.CrosshairIndicator;
import io.fair_acc.chartfx.plugins.Zoomer;
import io.fair_acc.chartfx.renderer.LineStyle;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tooltip;
import javafx.stage.Stage;
import org.kordamp.ikonli.javafx.FontIcon;

public class LiveDisplayRecorder
implements MeasurementRecorder {
    final Renderer timeSeriesRenderer;
    final Renderer percentileRenderer;
    final List<Runnable> updateActions = new ArrayList<Runnable>();
    final List<Runnable> clearActions = new ArrayList<Runnable>();
    final BitState state = BitState.initClean(this);
    private long nanoStartOffset = System.nanoTime();
    private static final int defaultCapacity = 3600;

    public static LiveDisplayRecorder showInNewStage(String string) {
        return LiveDisplayRecorder.createChart(string, parent -> {
            Stage stage = new Stage();
            stage.setScene(new Scene(parent));
            stage.show();
        });
    }

    public static LiveDisplayRecorder createChart(String string, Consumer<Parent> consumer) {
        XYChart xYChart = new XYChart(LiveDisplayRecorder.createTimeAxisX(), LiveDisplayRecorder.createValueAxisY());
        xYChart.setTitle(string);
        xYChart.getPlugins().addAll((Object[])LiveDisplayRecorder.createPlugins());
        xYChart.getLegend().getNode().setVisible(false);
        xYChart.getLegend().getNode().setManaged(false);
        ErrorDataSetRenderer errorDataSetRenderer = new ErrorDataSetRenderer();
        errorDataSetRenderer.setDrawMarker(true);
        errorDataSetRenderer.setPolyLineStyle(LineStyle.NONE);
        errorDataSetRenderer.setPointReduction(false);
        errorDataSetRenderer.setAllowNaNs(false);
        xYChart.getRenderers().setAll((Object[])new Renderer[]{errorDataSetRenderer});
        XYChart xYChart2 = new XYChart(LiveDisplayRecorder.createPercentileAxisX(), LiveDisplayRecorder.createValueAxisY());
        xYChart2.getPlugins().addAll((Object[])LiveDisplayRecorder.createPlugins());
        ErrorDataSetRenderer errorDataSetRenderer2 = new ErrorDataSetRenderer();
        errorDataSetRenderer2.setDrawMarker(false);
        errorDataSetRenderer2.setPolyLineStyle(LineStyle.NORMAL);
        errorDataSetRenderer2.setPointReduction(false);
        errorDataSetRenderer2.setAllowNaNs(false);
        xYChart2.getRenderers().setAll((Object[])new Renderer[]{errorDataSetRenderer2});
        LiveDisplayRecorder liveDisplayRecorder = new LiveDisplayRecorder(errorDataSetRenderer, errorDataSetRenderer2);
        Button button = new Button("clear");
        button.setMaxWidth(Double.MAX_VALUE);
        button.setOnAction(actionEvent -> liveDisplayRecorder.clear());
        Button button2 = new Button(null, (Node)new FontIcon("fa-trash:22"));
        button2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button2.setTooltip(new Tooltip("clears existing data"));
        button2.setOnAction(actionEvent -> liveDisplayRecorder.clear());
        xYChart2.getToolBar().getChildren().add((Object)button2);
        SplitPane splitPane = new SplitPane(new Node[]{xYChart, xYChart2});
        splitPane.setOrientation(Orientation.VERTICAL);
        consumer.accept((Parent)splitPane);
        return liveDisplayRecorder;
    }

    private static DefaultNumericAxis createTimeAxisX() {
        DefaultNumericAxis defaultNumericAxis = new DefaultNumericAxis();
        defaultNumericAxis.setTimeAxis(true);
        defaultNumericAxis.setName("time");
        defaultNumericAxis.setTimeAxis(false);
        defaultNumericAxis.setUnit("s");
        return defaultNumericAxis;
    }

    private static DefaultNumericAxis createValueAxisY() {
        DefaultNumericAxis defaultNumericAxis = new DefaultNumericAxis();
        defaultNumericAxis.setForceZeroInRange(true);
        defaultNumericAxis.setName("value");
        defaultNumericAxis.setUnit("s");
        defaultNumericAxis.setAutoUnitScaling(true);
        return defaultNumericAxis;
    }

    private static DefaultNumericAxis createPercentileAxisX() {
        PercentileAxis percentileAxis = new PercentileAxis();
        percentileAxis.setName("percentile");
        percentileAxis.setUnit("%");
        return percentileAxis;
    }

    private static ChartPlugin[] createPlugins() {
        Zoomer zoomer = new Zoomer();
        zoomer.setAddButtonsToToolBar(false);
        zoomer.setAnimated(false);
        zoomer.setSliderVisible(false);
        zoomer.setAutoZoomEnabled(true);
        CrosshairIndicator crosshairIndicator = new CrosshairIndicator();
        return new ChartPlugin[]{zoomer};
    }

    public LiveDisplayRecorder(AbstractRendererXY<?> abstractRendererXY, AbstractRendererXY<?> abstractRendererXY2) {
        this.timeSeriesRenderer = abstractRendererXY;
        this.percentileRenderer = abstractRendererXY2;
        Runnable runnable = () -> {
            for (Runnable runnable : this.updateActions) {
                runnable.run();
            }
            this.state.clear();
            Optional.ofNullable(abstractRendererXY.getChart()).ifPresent(Chart::invalidate);
            Optional.ofNullable(abstractRendererXY2.getChart()).ifPresent(Chart::invalidate);
        };
        this.state.addChangeListener((bitState, n2) -> Platform.runLater((Runnable)runnable));
    }

    public void clear() {
        this.nanoStartOffset = System.nanoTime();
        this.clearActions.forEach(Runnable::run);
    }

    @Override
    public TimeMeasure newTime(String string, IntSupplier intSupplier) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(10);
        DoubleArrayList doubleArrayList2 = new DoubleArrayList(10);
        TimeMeasure timeMeasure = (timeUnit, l2) -> {
            doubleArrayList.add((double)(System.nanoTime() - this.nanoStartOffset) * 1.0E-9);
            doubleArrayList2.add((double)timeUnit.toNanos(l2) * 1.0E-9);
            this.state.setDirty(ChartBits.DataSetDataAdded, new IntSupplier[0]);
        };
        CircularDoubleDataSet2D circularDoubleDataSet2D = new CircularDoubleDataSet2D(string, 3600);
        HdrHistogramDataSet hdrHistogramDataSet = new HdrHistogramDataSet(string);
        this.updateActions.add(() -> {
            for (int i2 = 0; i2 < doubleArrayList.size(); ++i2) {
                circularDoubleDataSet2D.add(doubleArrayList.getDouble(i2), doubleArrayList2.getDouble(i2));
                hdrHistogramDataSet.add(doubleArrayList2.getDouble(i2));
            }
            hdrHistogramDataSet.convertHistogramToXY();
            doubleArrayList.clear();
            doubleArrayList2.clear();
        });
        this.clearActions.add(() -> {
            circularDoubleDataSet2D.clear();
            hdrHistogramDataSet.clear();
            hdrHistogramDataSet.convertHistogramToXY();
            doubleArrayList.clear();
            doubleArrayList2.clear();
        });
        DataSetNode dataSetNode = this.timeSeriesRenderer.addDataSet(circularDoubleDataSet2D);
        DataSetNode dataSetNode2 = this.percentileRenderer.addDataSet(hdrHistogramDataSet);
        dataSetNode2.visibleProperty().bindBidirectional((Property)dataSetNode.visibleProperty());
        return timeMeasure;
    }
}

