/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi.format;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisLabelFormatter;
import io.fair_acc.chartfx.axes.TickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.format.DefaultTickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.format.FormatterLabelCache;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.StringConverter;

public abstract class AbstractFormatter
extends StringConverter<Number>
implements AxisLabelFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private final ObjectProperty<TickUnitSupplier> tickUnitSupplier = new SimpleObjectProperty((Object)this, "tickUnitSupplier", (Object)DEFAULT_TICK_UNIT_SUPPLIER);
    protected FormatterLabelCache labelCache = new FormatterLabelCache();
    protected final DoubleArrayList majorTickMarks = new DoubleArrayList();
    protected double unitScaling;
    protected double rangeMin = 0.0;
    protected double rangeMax = 1.0;
    protected double localSchmidtTriggerThreshold = 0.01;
    protected DoubleProperty schmittTriggerThreshold = new SimpleDoubleProperty(this, "schmittTriggerThreshold", this.localSchmidtTriggerThreshold){

        public void set(double d2) {
            super.set(Math.abs(d2));
        }
    };

    public AbstractFormatter() {
    }

    public AbstractFormatter(Axis axis) {
        this();
        if (axis == null) {
            return;
        }
    }

    protected double getLogRange() {
        double d2 = this.getRange();
        return d2 > 0.0 ? Math.log10(d2) : 1.0;
    }

    protected double getRange() {
        return Math.abs(this.rangeMax - this.rangeMin);
    }

    @Override
    public TickUnitSupplier getTickUnitSupplier() {
        return (TickUnitSupplier)this.tickUnitSupplierProperty().get();
    }

    protected abstract void rangeUpdated();

    public DoubleProperty schmittTriggerThresholdProperty() {
        return this.schmittTriggerThreshold;
    }

    @Override
    public void setTickUnitSupplier(TickUnitSupplier tickUnitSupplier) {
        this.tickUnitSupplierProperty().set((Object)tickUnitSupplier);
    }

    @Override
    public ObjectProperty<TickUnitSupplier> tickUnitSupplierProperty() {
        return this.tickUnitSupplier;
    }

    @Override
    public void updateFormatter(DoubleArrayList doubleArrayList, double d2) {
        this.majorTickMarks.setAll(doubleArrayList);
        this.unitScaling = d2;
        this.rangeMin = Double.MAX_VALUE;
        this.rangeMax = -1.7976931348623157E308;
        for (int i2 = 0; i2 < this.majorTickMarks.size(); ++i2) {
            double d3 = this.majorTickMarks.getDouble(i2);
            if (!Double.isFinite(d3)) continue;
            this.rangeMin = Math.min(this.rangeMin, d3);
            this.rangeMax = Math.max(this.rangeMax, d3);
        }
        this.rangeMin /= d2;
        this.rangeMax /= d2;
        this.rangeUpdated();
    }
}

