/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.ui.css.TextStyle;
import io.fair_acc.chartfx.ui.geometry.Side;
import java.util.Objects;
import javafx.geometry.Bounds;

public class TickMark {
    private double tickValue = Double.NaN;
    private String text = "";
    private double height = Double.NaN;
    private double width = Double.NaN;
    private double tickPosition = Double.NaN;
    private boolean visible = true;
    private final TextStyle style;
    private long usedStyle = -1L;

    public TickMark(TextStyle textStyle) {
        this.style = textStyle;
    }

    public void setValue(double d2, String string) {
        if (!Objects.equals(string, this.text)) {
            this.height = -1.0;
            this.width = -1.0;
        }
        this.tickValue = d2;
        this.text = string;
    }

    private void updateTextSize() {
        if (this.usedStyle != this.style.getChangeCounter() || this.height < 0.0) {
            if (this.text == null || this.text.isEmpty()) {
                this.height = 0.0;
                this.width = 0.0;
            } else {
                this.style.setText(this.text);
                Bounds bounds = this.style.getBoundsInParent();
                this.height = bounds.getHeight();
                this.width = bounds.getWidth();
            }
            this.usedStyle = this.style.getChangeCounter();
        }
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public double getValue() {
        return this.tickValue;
    }

    public String getText() {
        return this.text;
    }

    public double getHeight() {
        this.updateTextSize();
        return this.height;
    }

    public double getWidth() {
        this.updateTextSize();
        return this.width;
    }

    public double getPosition() {
        return this.tickPosition;
    }

    public void setPosition(double d2) {
        this.tickPosition = d2;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
    }

    @Deprecated
    TickMark(Side side, double d2, double d3, double d4, String string) {
        this(new TextStyle(new String[0]));
        this.setValue(d2, string);
        this.style.setRotate(d4);
        this.tickPosition = d3;
    }

    public double getRotation() {
        return this.style.getRotate();
    }

    @Deprecated
    void setValue(double d2) {
        this.tickValue = d2;
    }
}

