/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisTransform;
import io.fair_acc.chartfx.axes.LogAxisType;
import io.fair_acc.chartfx.axes.TickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.AbstractAxis;
import io.fair_acc.chartfx.axes.spi.AbstractAxisParameter;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.format.DefaultTickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.transforms.DefaultAxisTransform;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.spi.DataRange;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.beans.property.DoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OscilloscopeAxis
extends AbstractAxis
implements Axis {
    private static final Logger LOGGER = LoggerFactory.getLogger(OscilloscopeAxis.class);
    private static final CssPropertyFactory<OscilloscopeAxis> CSS = new CssPropertyFactory(AbstractAxisParameter.getClassCssMetaData());
    private static final int DEFAULT_RANGE_LENGTH = 1;
    private static final int TICK_COUNT = 10;
    public static final SortedSet<Number> DEFAULT_MULTIPLIERS1 = Collections.unmodifiableSortedSet(new TreeSet<Number>(Arrays.asList(1.0, 2.0, 5.0)));
    public static final SortedSet<Number> DEFAULT_MULTIPLIERS2 = Collections.unmodifiableSortedSet(new TreeSet<Number>(Arrays.asList(1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5)));
    private final transient DefaultAxisTransform axisTransform = new DefaultAxisTransform(this);
    private transient TickUnitSupplier tickUnitSupplier = new DefaultTickUnitSupplier(DEFAULT_MULTIPLIERS1);
    private final transient DataRange clampedRange = new DataRange();
    private final transient DataRange minRange = new DataRange();
    private final transient DataRange maxRange = new DataRange();
    private final StyleableDoubleProperty axisZeroPosition = CSS.createDoubleProperty(this, "axisZeroPosition", 0.5, true, (d2, d3) -> Math.max(0.0, Math.min(d3, 1.0)), this::requestAxisLayout);
    private final StyleableDoubleProperty axisZeroValue = CSS.createDoubleProperty(this, "axisZeroValue", 0.0, true, null, this::requestAxisLayout);
    private final transient Cache cache = new Cache();
    protected boolean isUpdating;
    private boolean computingRange = false;

    public OscilloscopeAxis(String string) {
        this(string, 0.0, 0.0, 5.0);
    }

    public OscilloscopeAxis(String string, double d4, double d5, double d6) {
        super(d4, d5);
        this.setName(string);
        if (d4 >= d5) {
            this.setAutoRanging(true);
        }
        this.setTickUnit(d6);
        this.setMinorTickCount(10);
        this.isUpdating = false;
    }

    public OscilloscopeAxis(String string, String string2) {
        this(string, 0.0, 0.0, 5.0);
        this.setUnit(string2);
    }

    public DoubleProperty axisZeroValueProperty() {
        return this.axisZeroValue;
    }

    public DoubleProperty centerAxisZeroPositionProperty() {
        return this.axisZeroPosition;
    }

    @Override
    public double computePreferredTickUnit(double d2) {
        double d3;
        DataRange dataRange = this.getClampedRange();
        double d4 = this.getAxisZeroValue();
        double d5 = this.getAxisZeroPosition();
        if (d5 == 0.0) {
            d3 = OscilloscopeAxis.getEffectiveRange(d4, dataRange.getMax()) / 10.0;
        } else if (d5 == 1.0) {
            d3 = OscilloscopeAxis.getEffectiveRange(dataRange.getMin(), d4) / 10.0;
        } else {
            double d6 = d5 * 10.0;
            double d7 = (1.0 - d5) * 10.0;
            double d8 = OscilloscopeAxis.getEffectiveRange(dataRange.getMin(), d4) / d6;
            double d9 = OscilloscopeAxis.getEffectiveRange(d4, dataRange.getMax()) / d7;
            d3 = Math.max(d8, d9);
        }
        return this.tickUnitSupplier.computeTickUnit(d3);
    }

    @Override
    public AxisTransform getAxisTransform() {
        return this.axisTransform;
    }

    public double getAxisZeroPosition() {
        return this.centerAxisZeroPositionProperty().get();
    }

    public double getAxisZeroValue() {
        return this.axisZeroValueProperty().get();
    }

    public DataRange getClampedRange() {
        if (!this.computingRange) {
            this.computingRange = true;
            this.recomputeClampedRange();
            this.computingRange = false;
        }
        return this.clampedRange;
    }

    @Override
    public LogAxisType getLogAxisType() {
        return LogAxisType.LINEAR_SCALE;
    }

    public DataRange getMaxRange() {
        return this.maxRange;
    }

    public DataRange getMinRange() {
        return this.minRange;
    }

    public TickUnitSupplier getTickUnitSupplier() {
        return this.tickUnitSupplier;
    }

    @Override
    public double getValueForDisplay(double d2) {
        if (this.isInvertedAxis) {
            return this.cache.localCurrentLowerBound + (this.cache.offset - d2 - this.cache.localOffset) / this.cache.localScale;
        }
        return this.cache.localCurrentLowerBound + (d2 - this.cache.localOffset) / this.cache.localScale;
    }

    @Override
    public boolean isLogAxis() {
        return false;
    }

    public void setAxisZeroPosition(double d2) {
        this.centerAxisZeroPositionProperty().set(d2);
    }

    public void setAxisZeroValue(double d2) {
        this.axisZeroValueProperty().set(d2);
    }

    public void setTickUnitSupplier(TickUnitSupplier tickUnitSupplier) {
        this.tickUnitSupplier = tickUnitSupplier;
        this.invalidate();
    }

    @Override
    protected void calculateMajorTickValues(AxisRange axisRange, DoubleArrayList doubleArrayList) {
        if (axisRange.getMin() == axisRange.getMax() || axisRange.getTickUnit() <= 0.0) {
            doubleArrayList.add(axisRange.getMin());
            return;
        }
        double d2 = Math.ceil(axisRange.getMin() / axisRange.getTickUnit()) * axisRange.getTickUnit();
        if (d2 + axisRange.getTickUnit() == d2) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("major ticks numerically not resolvable");
            }
            return;
        }
        int n2 = this.getMaxMajorTickLabelCount();
        for (double d3 = d2; d3 <= axisRange.getMax() && doubleArrayList.size() <= n2; d3 += axisRange.getTickUnit()) {
            doubleArrayList.add(d3);
        }
    }

    @Override
    protected void calculateMinorTickValues(DoubleArrayList doubleArrayList) {
        if (this.getMinorTickCount() <= 0 || this.getTickUnit() <= 0.0) {
            return;
        }
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = this.getTickUnit();
        double d5 = Math.ceil(d2 / d4) * d4;
        double d6 = d4 / (double)this.getMinorTickCount();
        int n2 = this.getMaxMajorTickLabelCount();
        int n3 = this.getMaxMajorTickLabelCount() * this.getMinorTickCount();
        int n4 = 0;
        for (double d7 = d5 - d4; d7 < d3 && n4 < n2 && d7 + d4 != d7; ++n4, d7 += d4) {
            double d8 = d7 + d4;
            for (double d9 = d7 + d6; d9 < d8 && doubleArrayList.size() < n3 && d9 != d7; d9 += d6) {
                if (!(d9 >= d2) || !(d9 <= d3)) continue;
                doubleArrayList.add(d9);
            }
        }
    }

    @Override
    public boolean set(double d2, double d3) {
        if (this.cache == null) {
            return super.set(d2, d3);
        }
        AxisRange axisRange = this.computeRange(d2, d3, this.getLength(), 0.0);
        return super.set(axisRange.getMin(), axisRange.getMax());
    }

    @Override
    public boolean set(AxisDescription axisDescription) {
        return false;
    }

    @Override
    public boolean set(String string, String string2, double d2, double d3) {
        if (this.cache == null) {
            return super.set(string, string2, d2, d3);
        }
        AxisRange axisRange = this.computeRange(d2, d3, this.getLength(), 0.0);
        return super.set(string, string2, axisRange.getMin(), axisRange.getMax());
    }

    @Override
    public boolean setMax(double d2) {
        if (this.cache == null) {
            return super.setMax(d2);
        }
        AxisRange axisRange = this.computeRange(this.getMin(), d2, this.getLength(), 0.0);
        return super.set(axisRange.getMin(), axisRange.getMax());
    }

    @Override
    public boolean setMin(double d2) {
        if (this.cache == null) {
            return super.setMin(d2);
        }
        AxisRange axisRange = this.computeRange(d2, this.getMax(), this.getLength(), 0.0);
        return super.set(axisRange.getMin(), axisRange.getMax());
    }

    @Override
    protected AxisRange computeRange(double d2, double d3, double d4, double d5) {
        double d6 = this.computePreferredTickUnit(d4);
        double d7 = 10.0 * d6;
        double d8 = this.getAxisZeroValue();
        double d9 = this.getAxisZeroPosition();
        double d10 = d8 + (0.0 - d9) * d7;
        double d11 = d8 + (1.0 - d9) * d7;
        double d12 = this.calculateNewScale(d4, d10, d11);
        return new AxisRange(d10, d11, d4, d12, d6);
    }

    protected void recomputeClampedRange() {
        AxisRange axisRange = this.getRange();
        this.clampedRange.set(this.getMinRange());
        if (this.getMaxRange().isMaxDefined()) {
            this.clampedRange.add(Math.min(axisRange.getMax(), this.getMaxRange().getMax()));
        } else {
            this.clampedRange.add(axisRange.getMax());
        }
        if (this.getMaxRange().isMinDefined()) {
            this.clampedRange.add(Math.max(axisRange.getMin(), this.getMaxRange().getMin()));
        } else {
            this.clampedRange.add(axisRange.getMin());
        }
    }

    @Override
    public void updateCachedTransforms() {
        super.updateCachedTransforms();
        if (this.cache == null) {
            return;
        }
        this.cache.updateCachedAxisVariables();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    protected static double getEffectiveRange(double d2, double d3) {
        double d4 = Math.abs(d3 - d2);
        if (d4 == 0.0 || Double.isNaN(d4)) {
            d4 = 1.0;
        }
        return d4;
    }

    @Override
    public double getDisplayPosition(double d2) {
        return this.cache.localOffset + (d2 - this.cache.localCurrentLowerBound) * this.cache.localScale;
    }

    @Override
    protected AxisRange autoRange(double d2, double d3, double d4, double d5) {
        return this.computeRange(d2, d3, d4, d5);
    }

    protected class Cache {
        protected double localScale;
        protected double localCurrentLowerBound;
        protected double localCurrentUpperBound;
        protected double localOffset;
        protected double localOffset2;
        protected double upperBoundLog;
        protected double lowerBoundLog;
        protected double logScaleLength;
        protected double axisLength;
        protected double offset;

        protected Cache() {
        }

        private void updateCachedAxisVariables() {
            this.axisLength = OscilloscopeAxis.this.getLength();
            this.localCurrentLowerBound = OscilloscopeAxis.this.getMin();
            this.localCurrentUpperBound = OscilloscopeAxis.this.getMax();
            this.upperBoundLog = OscilloscopeAxis.this.axisTransform.forward(OscilloscopeAxis.this.getMax());
            this.lowerBoundLog = OscilloscopeAxis.this.axisTransform.forward(OscilloscopeAxis.this.getMin());
            this.logScaleLength = this.upperBoundLog - this.lowerBoundLog;
            this.localScale = OscilloscopeAxis.this.scaleProperty().get();
            double d2 = OscilloscopeAxis.super.getDisplayPosition(0.0);
            this.localOffset = d2 + this.localCurrentLowerBound * this.localScale;
            this.localOffset2 = this.localOffset - OscilloscopeAxis.this.cache.localCurrentLowerBound * OscilloscopeAxis.this.cache.localScale;
            this.offset = this.axisLength;
        }
    }
}

