/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

public enum MetricPrefix {
    QUETTA("quetta", "Q", 1.0E30),
    RONNA("ronna", "R", 1.0E27),
    YOTTA("yotta", "Y", 1.0E24),
    ZETTA("zetta", "Z", 1.0E21),
    EXA("exa", "E", 1.0E18),
    PETA("peta", "P", 1.0E15),
    TERA("tera", "T", 1.0E12),
    GIGA("giga", "G", 1.0E9),
    MEGA("mega", "M", 1000000.0),
    KILO("kilo", "k", 1000.0),
    HECTO("hecto", "h", 100.0),
    NONE("", "", 1.0),
    CENTI("centi", "c", 0.01),
    MILLI("milli", "m", 0.001),
    MICRO("micro", "\u03bc", 1.0E-6),
    NANO("nano", "n", 1.0E-9),
    PICO("pico", "p", 1.0E-12),
    FEMTO("femto", "f", 1.0E-15),
    ATTO("atto", "a", 1.0E-18),
    ZEPTO("zepto", "z", 1.0E-21),
    YOCTO("yocto", "y", 1.0E-24),
    RONTO("ronto", "r", 1.0E-27),
    QUECTO("quecto", "q", 1.0E-30);

    final String longPrefix;
    final String shortPrefix;
    final double power;

    private MetricPrefix(String string2, String string3, double d2) {
        this.longPrefix = string2;
        this.shortPrefix = string3;
        this.power = d2;
    }

    public String getLongPrefix() {
        return this.longPrefix;
    }

    public double getPower() {
        return this.power;
    }

    public String getShortPrefix() {
        return this.shortPrefix;
    }

    public static String getLongPrefix(double d2) {
        for (MetricPrefix metricPrefix : MetricPrefix.values()) {
            if (d2 != metricPrefix.getPower()) continue;
            return metricPrefix.getLongPrefix();
        }
        return "*" + d2;
    }

    public static MetricPrefix getNearestMatch(double d2) {
        for (MetricPrefix metricPrefix : MetricPrefix.values()) {
            if (!(d2 >= metricPrefix.getPower())) continue;
            return metricPrefix;
        }
        return NONE;
    }

    public static String getShortPrefix(double d2) {
        for (MetricPrefix metricPrefix : MetricPrefix.values()) {
            if (d2 != metricPrefix.getPower()) continue;
            return metricPrefix.getShortPrefix();
        }
        return "*" + d2;
    }
}

