/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.axes.AxisTransform;
import io.fair_acc.chartfx.axes.LogAxisType;
import io.fair_acc.chartfx.axes.TickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.AbstractAxis;
import io.fair_acc.chartfx.axes.spi.AbstractAxisParameter;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.format.DefaultTickUnitSupplier;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.security.InvalidParameterException;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;

public class LogarithmicAxis
extends AbstractAxis {
    private static final CssPropertyFactory<LogarithmicAxis> CSS = new CssPropertyFactory(AbstractAxisParameter.getClassCssMetaData());
    public static final double DEFAULT_LOGARITHM_BASE = 10.0;
    public static final double DEFAULT_LOG_MIN_VALUE = 1.0E-6;
    public static final double DB20_LOGARITHM_BASE = Math.exp(Math.log10(10.0) / 20.0);
    public static final double DB10_LOGARITHM_BASE = Math.exp(Math.log10(10.0) / 10.0);
    public static final int DEFAULT_SMALL_LOG_AXIS = 4;
    private static final int DEFAULT_TICK_COUNT = 9;
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private final transient Cache cache = new Cache();
    private boolean isUpdating;
    private final StyleableDoubleProperty tickUnit = CSS.createDoubleProperty(this, "tickUnit", 5.0, true, null, () -> {
        if (!this.isAutoRanging()) {
            this.invalidate();
            this.requestAxisLayout();
        }
    });
    private final ObjectProperty<TickUnitSupplier> tickUnitSupplier = new SimpleObjectProperty((Object)this, "tickUnitSupplier", (Object)DEFAULT_TICK_UNIT_SUPPLIER);
    private final DoubleProperty logarithmBase = new SimpleDoubleProperty(this, "logarithmBase", 10.0){

        protected void invalidated() {
            if (this.get() <= 1.0) {
                throw new IllegalArgumentException("logarithmBase must be grater than 1");
            }
            LogarithmicAxis.this.invalidate();
            LogarithmicAxis.this.requestAxisLayout();
        }
    };

    public LogarithmicAxis() {
        this("axis label", 0.0, 0.0, 5.0);
    }

    public LogarithmicAxis(double d2, double d3, double d4) {
        this(null, d2, d3, d4);
    }

    public LogarithmicAxis(String string, double d2, double d3, double d4) {
        super(d2, d3);
        this.setName(string);
        if (d2 >= d3 || d2 == 0.0 || d2 == 0.0 && d3 == 0.0) {
            this.setAutoRanging(true);
        }
        this.setTickUnit(d4);
        this.setMinorTickCount(9);
        super.minProperty().addListener((observableValue, number, number2) -> this.cache.updateCachedAxisVariables());
        super.maxProperty().addListener((observableValue, number, number2) -> this.cache.updateCachedAxisVariables());
        super.scaleProperty().addListener((observableValue, number, number2) -> this.cache.updateCachedAxisVariables());
        this.widthProperty().addListener((observableValue, number, number2) -> {
            this.cache.axisWidth = this.getWidth();
        });
        this.heightProperty().addListener((observableValue, number, number2) -> {
            this.cache.axisHeight = this.getHeight();
        });
        this.isUpdating = false;
    }

    @Override
    public double computePreferredTickUnit(double d2) {
        return this.tickUnit.get();
    }

    @Override
    public AxisTransform getAxisTransform() {
        return null;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return LogarithmicAxis.getClassCssMetaData();
    }

    @Override
    public double getDisplayPosition(double d2) {
        double d3 = this.log(d2) - this.cache.lowerBoundLog;
        if (this.cache.isVerticalAxis) {
            return this.cache.axisHeight - d3 * this.cache.logScaleLengthInv;
        }
        return d3 * this.cache.logScaleLengthInv;
    }

    public double getLogarithmBase() {
        return this.logarithmBaseProperty().get();
    }

    @Override
    public LogAxisType getLogAxisType() {
        return LogAxisType.LINEAR_SCALE;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    public TickUnitSupplier getTickUnitSupplier() {
        return (TickUnitSupplier)this.tickUnitSupplierProperty().get();
    }

    @Override
    public double getValueForDisplay(double d2) {
        if (this.cache.isVerticalAxis) {
            double d3 = this.cache.axisHeight;
            return this.pow(this.cache.lowerBoundLog + (d3 - d2) / d3 * this.cache.logScaleLength);
        }
        return this.pow(this.cache.lowerBoundLog + d2 / this.cache.axisWidth * this.cache.logScaleLength);
    }

    @Override
    public double getZeroPosition() {
        return this.getDisplayPosition(this.cache.localCurrentLowerBound);
    }

    @Override
    public boolean isLogAxis() {
        return true;
    }

    @Override
    public boolean isValueOnAxis(double d2) {
        return d2 >= this.getMin() && d2 <= this.getMax();
    }

    public DoubleProperty logarithmBaseProperty() {
        return this.logarithmBase;
    }

    @Override
    public void requestAxisLayout() {
        if (this.isUpdating) {
            return;
        }
        super.requestAxisLayout();
    }

    public void setLogarithmBase(double d2) {
        this.logarithmBaseProperty().set(d2);
    }

    @Override
    public void setTickUnit(double d2) {
        this.tickUnitProperty().set(d2);
    }

    public void setTickUnitSupplier(TickUnitSupplier tickUnitSupplier) {
        this.tickUnitSupplierProperty().set((Object)tickUnitSupplier);
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public ObjectProperty<TickUnitSupplier> tickUnitSupplierProperty() {
        return this.tickUnitSupplier;
    }

    private double log(double d2) {
        if (d2 <= 0.0) {
            return Double.NaN;
        }
        return Math.log10(d2) / this.cache.logBase;
    }

    private double pow(double d2) {
        return Math.pow(this.getLogarithmBase(), d2);
    }

    @Override
    protected AxisRange autoRange(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        if (d6 <= 0.0) {
            d6 = 1.0E-6;
            this.isUpdating = true;
            this.setMin(1.0E-6);
            this.isUpdating = false;
        }
        double d7 = 1.0 + this.getAutoRangePadding();
        double d8 = d6 / d7;
        double d9 = d3 * d7;
        return this.computeRange(d8, d9, d4, d5);
    }

    @Override
    protected void calculateMajorTickValues(AxisRange axisRange, DoubleArrayList doubleArrayList) {
        if (axisRange == null) {
            throw new InvalidParameterException("range is null");
        }
        if (axisRange.getLowerBound() >= axisRange.getUpperBound()) {
            doubleArrayList.add(axisRange.getLowerBound());
            return;
        }
        double d2 = Math.ceil(this.log(axisRange.getLowerBound()));
        double d3 = this.pow(d2);
        while (d3 <= axisRange.getUpperBound()) {
            doubleArrayList.add(d3);
            d3 = this.pow(d2 += 1.0);
        }
    }

    @Override
    protected void calculateMinorTickValues(DoubleArrayList doubleArrayList) {
        if (this.getMinorTickCount() <= 0) {
            return;
        }
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = Math.floor(this.log(d2));
        double d5 = this.pow(d4);
        while (d5 < d3) {
            double d6 = this.pow(d4 + 1.0);
            double d7 = (d6 - d5) / (double)this.getMinorTickCount();
            for (double d8 = d5 + d7; d8 < d6; d8 += d7) {
                if (!(d8 >= d2) || !(d8 <= d3)) continue;
                doubleArrayList.add(d8);
            }
            d5 = this.pow(d4 += 1.0);
        }
    }

    @Override
    protected AxisRange computeRange(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        double d7 = d3;
        if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
            d6 = d6 <= 0.0 ? 1.0E-6 : this.pow(Math.floor(this.log(d6)));
            d7 = this.pow(Math.ceil(this.log(d7)));
        }
        double d8 = this.calculateNewScale(d4, d6, d7);
        return new AxisRange(d6, d7, d4, d8, this.tickUnit.get());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    protected class Cache {
        protected double localCurrentLowerBound;
        protected double localCurrentUpperBound;
        protected double upperBoundLog;
        protected double lowerBoundLog;
        protected double logScaleLength;
        protected double logScaleLengthInv;
        protected boolean isVerticalAxis;
        protected double axisWidth;
        protected double axisHeight;
        protected double logBase;

        protected Cache() {
        }

        private void updateCachedAxisVariables() {
            this.localCurrentLowerBound = LogarithmicAxis.super.getMin();
            this.localCurrentUpperBound = LogarithmicAxis.super.getMax();
            this.upperBoundLog = LogarithmicAxis.this.log(LogarithmicAxis.this.getMax());
            this.lowerBoundLog = LogarithmicAxis.this.log(LogarithmicAxis.this.getMin());
            this.logScaleLength = this.upperBoundLog - this.lowerBoundLog;
            this.logScaleLengthInv = 1.0 / this.logScaleLength;
            if (LogarithmicAxis.this.getSide() != null) {
                this.isVerticalAxis = LogarithmicAxis.this.getSide().isVertical();
            }
            this.logScaleLengthInv = this.isVerticalAxis ? this.axisHeight / this.logScaleLength : this.axisWidth / this.logScaleLength;
            this.logBase = Math.log10(LogarithmicAxis.this.getLogarithmBase());
        }
    }
}

