/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.axes.AxisTransform;
import io.fair_acc.chartfx.axes.LogAxisType;
import io.fair_acc.chartfx.axes.TickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.AbstractAxis;
import io.fair_acc.chartfx.axes.spi.AbstractAxisParameter;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.format.DefaultTickUnitSupplier;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.security.InvalidParameterException;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;

public class LinearAxis
extends AbstractAxis {
    private static final CssPropertyFactory<LinearAxis> CSS = new CssPropertyFactory(AbstractAxisParameter.getClassCssMetaData());
    private static final int DEFAULT_TICK_COUNT = 9;
    private static final int TICK_MARK_GAP = 6;
    private static final double NEXT_TICK_UNIT_FACTOR = 1.01;
    private static final int MAX_TICK_COUNT = 20;
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private static final int DEFAULT_RANGE_LENGTH = 2;
    private final transient Cache cache = new Cache();
    private boolean isUpdating;
    private final BooleanProperty forceZeroInRange = new SimpleBooleanProperty(this, "forceZeroInRange", false){

        protected void invalidated() {
            if (LinearAxis.this.isAutoRanging() || LinearAxis.this.isAutoGrowRanging()) {
                LinearAxis.this.invalidate();
                LinearAxis.this.requestAxisLayout();
            }
        }
    };
    private final StyleableDoubleProperty tickUnit = CSS.createDoubleProperty(this, "tickUnit", 5.0, () -> {
        if (!this.isAutoRanging() || this.isAutoGrowRanging()) {
            this.invalidate();
            this.requestAxisLayout();
        }
    });
    private final ObjectProperty<TickUnitSupplier> tickUnitSupplier = new SimpleObjectProperty((Object)this, "tickUnitSupplier", (Object)DEFAULT_TICK_UNIT_SUPPLIER);

    public LinearAxis() {
        this("axis label", 0.0, 0.0, 5.0);
    }

    public LinearAxis(double d2, double d3, double d4) {
        this(null, d2, d3, d4);
    }

    public LinearAxis(String string, double d2, double d3, double d4) {
        super(d2, d3);
        this.setName(string);
        if (d2 >= d3 || d2 == 0.0 || d2 == 0.0 && d3 == 0.0) {
            this.setAutoRanging(true);
        }
        this.setTickUnit(d4);
        this.setMinorTickCount(9);
        super.minProperty().addListener((observableValue, number, number2) -> this.cache.updateCachedAxisVariables());
        super.maxProperty().addListener((observableValue, number, number2) -> this.cache.updateCachedAxisVariables());
        super.scaleProperty().addListener((observableValue, number, number2) -> this.cache.updateCachedAxisVariables());
        this.widthProperty().addListener((observableValue, number, number2) -> {
            this.cache.axisWidth = this.getWidth();
        });
        this.heightProperty().addListener((observableValue, number, number2) -> {
            this.cache.axisHeight = this.getHeight();
        });
        this.isUpdating = false;
    }

    @Override
    public double computePreferredTickUnit(double d2) {
        int n2;
        double d3;
        double d4 = this.getTickLabelFont().getSize() * 2.0;
        int n3 = (int)Math.floor(d2 / d4);
        int n4 = Math.max(Math.min(n3, 20), 2);
        double d5 = this.maxProperty().get();
        double d6 = this.minProperty().get();
        double d7 = (d5 - d6) / (double)n4;
        double d8 = Double.MIN_VALUE;
        double d9 = d6;
        double d10 = d5;
        do {
            double d11;
            if (Double.isNaN(d7)) {
                throw new IllegalArgumentException("Can't calculate axis range: data contains NaN value");
            }
            double d12 = d8;
            d8 = this.computeTickUnit(d7);
            if (d8 <= d12) break;
            if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
                d9 = Math.floor(d6 / d8) * d8;
                d10 = Math.ceil(d5 / d8) * d8;
                d11 = d9;
            } else {
                d11 = Math.ceil(d6 / d8) * d8;
            }
            n2 = 0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = d11;
            while (d15 <= d10) {
                double d16 = this.measureTickMarkLength(d15);
                if (d15 == d11) {
                    d14 = d16 / 2.0;
                } else {
                    d13 = Math.max(d13, d14 + 6.0 + d16 / 2.0);
                }
                d15 += d8;
                ++n2;
            }
            d3 = (double)(n2 - 1) * d13;
            d7 = d8 * 1.01;
        } while (n4 > 2 && (d3 > d2 || n2 > 20));
        return d8;
    }

    public BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    @Override
    public AxisTransform getAxisTransform() {
        return null;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return LinearAxis.getClassCssMetaData();
    }

    @Override
    public double getDisplayPosition(double d2) {
        return this.cache.localOffset + (d2 - this.cache.localCurrentLowerBound) * this.cache.localScale;
    }

    @Override
    public LogAxisType getLogAxisType() {
        return LogAxisType.LINEAR_SCALE;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    public TickUnitSupplier getTickUnitSupplier() {
        return (TickUnitSupplier)this.tickUnitSupplierProperty().get();
    }

    @Override
    public double getValueForDisplay(double d2) {
        return (d2 - this.cache.localOffset) / this.cache.localScale + this.cache.localCurrentLowerBound;
    }

    @Override
    public double getZeroPosition() {
        return this.getDisplayPosition(0.0);
    }

    public boolean isForceZeroInRange() {
        return this.forceZeroInRange.getValue();
    }

    @Override
    public boolean isLogAxis() {
        return false;
    }

    @Override
    public boolean isValueOnAxis(double d2) {
        return d2 >= this.getMin() && d2 <= this.getMax();
    }

    @Override
    public void requestAxisLayout() {
        if (this.isUpdating) {
            return;
        }
        super.requestAxisLayout();
    }

    public void setForceZeroInRange(boolean bl2) {
        this.forceZeroInRange.setValue(Boolean.valueOf(bl2));
    }

    @Override
    public void setTickUnit(double d2) {
        this.tickUnitProperty().set(d2);
    }

    public void setTickUnitSupplier(TickUnitSupplier tickUnitSupplier) {
        this.tickUnitSupplierProperty().set((Object)tickUnitSupplier);
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public ObjectProperty<TickUnitSupplier> tickUnitSupplierProperty() {
        return this.tickUnitSupplier;
    }

    private AxisRange computeRangeImpl(double d2, double d3, double d4, double d5) {
        double d6;
        int n2;
        double d7;
        int n3 = (int)Math.floor(d4 / d5);
        int n4 = Math.max(Math.min(n3, 20), 2);
        double d8 = (d3 - d2) / (double)n4;
        double d9 = Double.MIN_VALUE;
        double d10 = d2;
        double d11 = d3;
        do {
            if (Double.isNaN(d8)) {
                throw new IllegalArgumentException("Can't calculate axis range: data contains NaN value");
            }
            double d12 = d9;
            d9 = this.computeTickUnit(d8);
            if (d9 <= d12) break;
            if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
                d10 = Math.floor(d2 / d9) * d9;
                d11 = Math.ceil(d3 / d9) * d9;
                d6 = d10;
            } else {
                d6 = Math.ceil(d2 / d9) * d9;
            }
            n2 = 0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = d6;
            while (d15 <= d11) {
                double d16 = this.measureTickMarkLength(d15);
                if (d15 == d6) {
                    d14 = d16 / 2.0;
                } else {
                    d13 = Math.max(d13, d14 + 6.0 + d16 / 2.0);
                }
                d15 += d9;
                ++n2;
            }
            d7 = (double)(n2 - 1) * d13;
            d8 = d9 * 1.01;
        } while (n4 > 2 && (d7 > d4 || n2 > 20));
        d6 = this.calculateNewScale(d4, d10, d11);
        return new AxisRange(d10, d11, d4, d6, d9);
    }

    private double computeTickUnit(double d2) {
        double d3;
        TickUnitSupplier tickUnitSupplier = this.getTickUnitSupplier();
        if (tickUnitSupplier == null) {
            tickUnitSupplier = DEFAULT_TICK_UNIT_SUPPLIER;
        }
        if ((d3 = tickUnitSupplier.computeTickUnit(d2)) <= 0.0) {
            throw new IllegalArgumentException("The " + tickUnitSupplier.getClass().getName() + " computed illegal unit value [" + d3 + "] for argument " + d2);
        }
        return d3;
    }

    @Override
    protected AxisRange autoRange(double d2, double d3, double d4, double d5) {
        double d6 = d2 > 0.0 && this.isForceZeroInRange() ? 0.0 : d2;
        double d7 = d3 < 0.0 && this.isForceZeroInRange() ? 0.0 : d3;
        double d8 = LinearAxis.getEffectiveRange(d6, d7) * this.getAutoRangePadding();
        double d9 = LinearAxis.clampBoundToZero(d6 - d8, d6);
        double d10 = LinearAxis.clampBoundToZero(d7 + d8, d7);
        return this.computeRange(d9, d10, d4, d5);
    }

    @Override
    protected void calculateMajorTickValues(AxisRange axisRange, DoubleArrayList doubleArrayList) {
        double d2;
        if (axisRange == null) {
            throw new InvalidParameterException("range is null");
        }
        if (axisRange.getLowerBound() == axisRange.getUpperBound() || axisRange.getTickUnit() <= 0.0) {
            doubleArrayList.add(axisRange.getLowerBound());
            return;
        }
        for (double d3 = d2 = LinearAxis.computeFistMajorTick(axisRange.getLowerBound(), axisRange.getTickUnit()); d3 <= axisRange.getUpperBound(); d3 += axisRange.getTickUnit()) {
            doubleArrayList.add(d3);
        }
    }

    @Override
    protected void calculateMinorTickValues(DoubleArrayList doubleArrayList) {
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = this.getTickUnit();
        double d5 = LinearAxis.computeFistMajorTick(d2, d4);
        double d6 = d4 / (double)this.getMinorTickCount();
        for (double d7 = d5 - d4; d7 < d3; d7 += d4) {
            double d8 = d7 + d4;
            for (double d9 = d7 + d6; d9 < d8; d9 += d6) {
                if (!(d9 >= d2) || !(d9 <= d3)) continue;
                doubleArrayList.add(d9);
            }
        }
    }

    @Override
    protected AxisRange computeRange(double d2, double d3, double d4, double d5) {
        double d6 = d3;
        double d7 = d2;
        if (d6 - d7 == 0.0) {
            double d8 = this.getAutoRangePadding() < 0.0 ? 0.0 : this.getAutoRangePadding();
            double d9 = LinearAxis.getEffectiveRange(d7, d6) * d8;
            d7 -= d9 / 2.0;
            d6 += d9 / 2.0;
        }
        return this.computeRangeImpl(d7, d6, d4, d5);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    private static double clampBoundToZero(double d2, double d3) {
        if (d2 < 0.0 && d3 >= 0.0 || d2 > 0.0 && d3 <= 0.0) {
            return 0.0;
        }
        return d2;
    }

    private static double computeFistMajorTick(double d2, double d3) {
        return Math.ceil(d2 / d3) * d3;
    }

    private static double getEffectiveRange(double d2, double d3) {
        double d4 = d3 - d2;
        if (d4 == 0.0) {
            d4 = d2 == 0.0 ? 2.0 : Math.abs(d2);
        }
        return d4;
    }

    protected class Cache {
        protected double localScale;
        protected double localCurrentLowerBound;
        protected double localCurrentUpperBound;
        protected double localOffset;
        protected boolean isVerticalAxis;
        protected double axisWidth;
        protected double axisHeight;

        protected Cache() {
        }

        private void updateCachedAxisVariables() {
            this.localCurrentLowerBound = LinearAxis.super.getMin();
            this.localCurrentUpperBound = LinearAxis.super.getMax();
            this.localScale = LinearAxis.this.scaleProperty().get();
            double d2 = LinearAxis.super.getDisplayPosition(0.0);
            this.localOffset = d2 + this.localCurrentLowerBound * LinearAxis.this.scaleProperty().get();
            if (LinearAxis.this.getSide() != null) {
                this.isVerticalAxis = LinearAxis.this.getSide().isVertical();
            }
        }
    }
}

