/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx;

import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.Measurable;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.AbstractAxis;
import io.fair_acc.chartfx.axes.spi.AbstractAxisParameter;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.legend.Legend;
import io.fair_acc.chartfx.legend.spi.DefaultLegend;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.LabelledMarkerRenderer;
import io.fair_acc.chartfx.ui.ChartLayoutAnimator;
import io.fair_acc.chartfx.ui.HiddenSidesPane;
import io.fair_acc.chartfx.ui.ResizableCanvas;
import io.fair_acc.chartfx.ui.ToolBarFlowPane;
import io.fair_acc.chartfx.ui.css.ColorPalette;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.StyleGroup;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.ui.layout.ChartPane;
import io.fair_acc.chartfx.ui.layout.FullSizePane;
import io.fair_acc.chartfx.ui.layout.TitleLabel;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventSource;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.NoDuplicatesList;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public abstract class Chart
extends Region
implements EventSource,
Measurable {
    protected final BitState state = BitState.initDirty(this, -1).addChangeListener(ChartBits.ChartLayout, (bitState, n2) -> super.requestLayout()).addChangeListener(ChartBits.KnownMask, (bitState, n2) -> this.ensureJavaFxPulse());
    protected final BitState dataSetState = BitState.initDirtyMultiThreaded(this, -1).addChangeListener(FXUtils.runOnFxThread((bitState, n2) -> this.state.setDirty(bitState.getBits())));
    private static final String CHART_CSS = Objects.requireNonNull(Chart.class.getResource("chart.css")).toExternalForm();
    private static final CssPropertyFactory<Chart> CSS = new CssPropertyFactory(Region.getClassCssMetaData());
    private static final int DEFAULT_TRIGGER_DISTANCE = 50;
    protected static final boolean DEBUG = Boolean.getBoolean("chartfx.debug");
    protected final BooleanProperty showing = new SimpleBooleanProperty((Object)this, "showing", false);
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    protected final ChartLayoutAnimator animator = new ChartLayoutAnimator((Parent)this);
    protected final ObservableList<Axis> axesList = FXCollections.observableList(new NoDuplicatesList());
    private final Map<ChartPlugin, Group> pluginGroups = new HashMap<ChartPlugin, Group>();
    private final ObservableList<ChartPlugin> plugins = FXCollections.observableList(new LinkedList());
    protected final ObservableList<DataSet> allDataSets = FXCollections.observableArrayList();
    private final ObservableList<Renderer> renderers = FXCollections.observableArrayList();
    protected final ResizableCanvas canvas = StyleUtil.addStyles(new ResizableCanvas(), "chart-canvas");
    protected final Pane canvasForeground = StyleUtil.addStyles(new FullSizePane(new Node[0]), "chart-canvas-foreground");
    protected final Group pluginsArea = FXUtils.createUnmanagedGroup();
    protected final Pane plotBackground = StyleUtil.addStyles(new FullSizePane(new Node[0]), "chart-plot-background");
    protected final HiddenSidesPane plotArea = StyleUtil.addStyles(new HiddenSidesPane(), "chart-plot-area");
    protected final Pane plotForeGround = StyleUtil.addStyles(new FullSizePane(new Node[0]), "chart-plot-foreground");
    protected final ChartPane measurementPane = StyleUtil.addStyles(new ChartPane(), "chart-measurement-pane");
    protected final ChartPane titleLegendPane = StyleUtil.addStyles(new ChartPane(), "chart-title-pane", "chart-legend-pane");
    protected final ChartPane axesAndCanvasPane = StyleUtil.addStyles(new ChartPane(), "chart-content");
    protected final HiddenSidesPane menuPane = new HiddenSidesPane();
    protected final ToolBarFlowPane toolBar = new ToolBarFlowPane(this);
    protected final BooleanProperty toolBarPinned = new SimpleBooleanProperty((Object)this, "toolBarPinned", false);
    protected final StyleGroup styleableNodes = new StyleGroup((Node)this, (ObservableList<Node>)this.getChildren(), "chart");
    protected final TitleLabel titleLabel = StyleUtil.addStyles(new TitleLabel(), "chart-title");
    protected final ListChangeListener<Renderer> rendererChangeListener = this::rendererChanged;
    protected final ListChangeListener<Axis> axesChangeListenerLocal = this::axesChangedLocal;
    protected final ListChangeListener<Axis> axesChangeListener = this::axesChanged;
    protected final ListChangeListener<DataSet> datasetChangeListener = this::datasetsChanged;
    protected final ListChangeListener<ChartPlugin> pluginsChangedListener = this::pluginsChanged;
    private final ObjectProperty<Legend> legend = new SimpleObjectProperty<Legend>((Object)this, "legend", (Legend)new DefaultLegend()){
        private Legend oldLegend;
        {
            this.oldLegend = (Legend)this.get();
            Chart.this.getTitleLegendPane().addSide(this.oldLegend.getSide(), this.oldLegend.getNode(), new Node[0]);
        }

        protected void invalidated() {
            Legend legend = (Legend)this.get();
            if (this.oldLegend != null) {
                Chart.this.getTitleLegendPane().remove(this.oldLegend.getNode(), new Node[0]);
            }
            if (legend != null) {
                Chart.this.getTitleLegendPane().addSide(legend.getSide(), legend.getNode(), new Node[0]);
            }
            super.set((Object)legend);
            this.oldLegend = legend;
            Chart.this.fireInvalidated(ChartBits.ChartLegend);
        }
    };
    private final StyleableObjectProperty<ColorPalette> colorPalette = CSS.createEnumProperty((Styleable)this, "colorPalette", ColorPalette.DEFAULT, true, ColorPalette.class);
    private final StyleableObjectProperty<Side> toolBarSide = CSS.createObjectProperty(this, "toolBarSide", Side.TOP, false, StyleConverter.getEnumConverter(Side.class), (side, side2) -> {
        AssertUtils.notNull("Side must not be null", side2);
        this.menuPane.setTop(null);
        this.menuPane.setBottom(null);
        this.menuPane.setLeft(null);
        this.menuPane.setRight(null);
        switch (side2) {
            case LEFT: {
                this.getToolBar().setOrientation(Orientation.VERTICAL);
                this.menuPane.setLeft((Node)this.getToolBar());
                break;
            }
            case RIGHT: {
                this.getToolBar().setOrientation(Orientation.VERTICAL);
                this.menuPane.setRight((Node)this.getToolBar());
                break;
            }
            case BOTTOM: {
                this.getToolBar().setOrientation(Orientation.HORIZONTAL);
                this.menuPane.setBottom((Node)this.getToolBar());
                break;
            }
            default: {
                this.getToolBar().setOrientation(Orientation.HORIZONTAL);
                this.menuPane.setTop((Node)this.getToolBar());
            }
        }
        return side2;
    }, new Runnable[0]);
    private final List<DataSet> lockedDataSets = new ArrayList<DataSet>();
    private boolean hasLocked = false;
    private DurationMeasure benchPreLayout = DurationMeasure.DISABLED;
    private DurationMeasure benchCssAndLayout = DurationMeasure.DISABLED;
    private DurationMeasure benchLayoutChildren = DurationMeasure.DISABLED;
    private DurationMeasure benchPostLayout = DurationMeasure.DISABLED;
    private DurationMeasure benchLockDataSets = DurationMeasure.DISABLED;
    private DurationMeasure benchUpdateAxisRange = DurationMeasure.DISABLED;
    private DurationMeasure benchDrawAxes = DurationMeasure.DISABLED;
    private DurationMeasure benchDrawCanvas = DurationMeasure.DISABLED;

    public Chart(Axis ... axisArray) {
        for (int i2 = 0; i2 < axisArray.length; ++i2) {
            AbstractAxis abstractAxis;
            Axis axis = axisArray[i2];
            if (!(axis instanceof AbstractAxis) || (abstractAxis = (AbstractAxis)axis).getDimIndex() >= 0) continue;
            abstractAxis.setDimIndex(i2);
        }
        FXUtils.registerLayoutHooks((Node)this, this::runPreLayout, this::runPostLayout);
        this.showing.bind((ObservableValue)FXUtils.getShowingBinding((Node)this));
        this.getRenderers().addListener(this.rendererChangeListener);
        this.getPlugins().addListener(this.pluginsChangedListener);
        this.getAxes().addListener(this.axesChangeListenerLocal);
        this.getAxes().addListener(this.axesChangeListener);
        PropUtil.runOnChange(() -> {
            this.getColorPalette().applyPseudoClasses((Node)this);
            this.applyCss();
        }, new ObservableValue[]{this.colorPalette});
        this.menuPane.setTriggerDistance(50.0);
        this.plotBackground.toBack();
        this.plotForeGround.toFront();
        this.plotForeGround.setMouseTransparent(true);
        this.plotArea.triggerDistanceProperty().bindBidirectional((Property)this.menuPane.triggerDistanceProperty());
        this.plotArea.setAnimationDelay(Duration.millis((double)500.0));
        this.plotArea.setPickOnBounds(false);
        this.getCanvasForeground().setManaged(false);
        this.getCanvasForeground().setMouseTransparent(true);
        this.getCanvas().toFront();
        this.getCanvasForeground().toFront();
        this.pluginsArea.toFront();
        if (!this.canvas.isCache()) {
            this.canvas.setCache(true);
            this.canvas.setCacheHint(CacheHint.QUALITY);
        }
        this.titleLabel.focusTraversableProperty().bind((ObservableValue)Platform.accessibilityActiveProperty());
        this.getTitleLegendPane().getChildren().add((Object)this.titleLabel);
        this.toolBar.registerListener();
        this.menuPane.setTop((Node)this.getToolBar());
        FullSizePane fullSizePane = StyleUtil.addStyles(new FullSizePane(new Node[]{this.canvas, this.canvasForeground, this.pluginsArea}), "chart-canvas-area");
        this.plotArea.setContent((Node)fullSizePane);
        this.axesAndCanvasPane.addCenter((Node)this.plotBackground, new Node[]{this.plotArea, this.plotForeGround});
        this.titleLegendPane.addCenter((Node)this.axesAndCanvasPane, new Node[0]);
        this.measurementPane.addCenter((Node)this.titleLegendPane, new Node[0]);
        this.menuPane.setContent((Node)this.measurementPane);
        this.getChildren().add((Object)this.menuPane);
    }

    @Override
    public BitState getBitState() {
        return this.state;
    }

    public String getUserAgentStylesheet() {
        return CHART_CSS;
    }

    public void animate(KeyFrame ... keyFrameArray) {
        this.animator.animate(keyFrameArray);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public ObservableList<DataSet> getAllDatasets() {
        this.allDataSets.clear();
        for (Renderer renderer : this.renderers) {
            if (renderer instanceof LabelledMarkerRenderer) continue;
            this.allDataSets.addAll(renderer.getDatasets());
        }
        return this.allDataSets;
    }

    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    public ChartPane getAxesAndCanvasPane() {
        return this.axesAndCanvasPane;
    }

    public final Canvas getCanvas() {
        return this.canvas;
    }

    public final Pane getCanvasForeground() {
        return this.canvasForeground;
    }

    public Axis getFirstAxis(Orientation orientation) {
        Axis axis2;
        block6: for (Axis axis2 : this.getAxes()) {
            if (axis2.getSide() == null) continue;
            switch (orientation) {
                case VERTICAL: {
                    if (!axis2.getSide().isVertical()) continue block6;
                    return axis2;
                }
            }
            if (!axis2.getSide().isHorizontal()) continue;
            return axis2;
        }
        switch (orientation) {
            case HORIZONTAL: {
                DefaultNumericAxis defaultNumericAxis = new DefaultNumericAxis("x-Axis");
                defaultNumericAxis.setSide(Side.BOTTOM);
                defaultNumericAxis.setDimIndex(0);
                this.getAxes().add((Object)defaultNumericAxis);
                return defaultNumericAxis;
            }
        }
        axis2 = new DefaultNumericAxis("y-Axis");
        ((AbstractAxisParameter)axis2).setSide(Side.LEFT);
        ((AbstractAxisParameter)axis2).setDimIndex(1);
        this.getAxes().add((Object)axis2);
        return axis2;
    }

    public final Legend getLegend() {
        return (Legend)this.legend.getValue();
    }

    public final ChartPane getMeasurementPane() {
        return this.measurementPane;
    }

    public final HiddenSidesPane getPlotArea() {
        return this.plotArea;
    }

    public final HiddenSidesPane getMenuPane() {
        return this.menuPane;
    }

    public final Pane getPlotBackground() {
        return this.plotBackground;
    }

    public final Pane getPlotForeground() {
        return this.plotForeGround;
    }

    public final ObservableList<ChartPlugin> getPlugins() {
        return this.plugins;
    }

    public ObservableList<Renderer> getRenderers() {
        return this.renderers;
    }

    public final String getTitle() {
        return (String)this.titleProperty().get();
    }

    public final TitleLabel getTitleLabel() {
        return this.titleLabel;
    }

    public final ChartPane getTitleLegendPane() {
        return this.titleLegendPane;
    }

    public final FlowPane getToolBar() {
        return this.toolBar;
    }

    public final ObjectProperty<Side> getToolBarSideProperty() {
        return this.toolBarSide;
    }

    public final Side getToolBarSide() {
        return (Side)((Object)this.toolBarSideProperty().get());
    }

    public ColorPalette getColorPalette() {
        return (ColorPalette)((Object)this.colorPalette.get());
    }

    public StyleableObjectProperty<ColorPalette> colorPaletteProperty() {
        return this.colorPalette;
    }

    public void setColorPalette(ColorPalette colorPalette) {
        this.colorPalette.set((Object)colorPalette);
    }

    public final boolean isAnimated() {
        return this.animated.get();
    }

    public boolean isShowing() {
        return this.showing.get();
    }

    public boolean isToolBarPinned() {
        return this.toolBarPinned.get();
    }

    public void invalidate() {
        this.fireInvalidated(ChartBits.ChartLayout, ChartBits.ChartCanvas);
    }

    protected void runPreLayout() {
        this.state.setDirty(this.dataSetState.clear());
        if (this.state.isClean()) {
            return;
        }
        this.benchPreLayout.start();
        for (Measurable.EmptyDefault emptyDefault : this.renderers) {
            emptyDefault.updateAxes();
        }
        if (this.state.isDirty(ChartBits.ChartLegend)) {
            this.updateLegend((List<Renderer>)this.getRenderers());
        }
        this.state.clear(ChartBits.ChartLegend);
        this.benchLockDataSets.start();
        this.ensureLockedDataSets();
        this.benchLockDataSets.stop();
        this.benchUpdateAxisRange.start();
        this.updateAxisRange();
        this.benchUpdateAxisRange.stop();
        for (Measurable.EmptyDefault emptyDefault : this.renderers) {
            emptyDefault.runPreLayout();
            for (DataSetNode dataSetNode : emptyDefault.getDatasetNodes()) {
                dataSetNode.runPreLayout();
            }
        }
        for (Measurable.EmptyDefault emptyDefault : this.plugins) {
            ((ChartPlugin)emptyDefault).runPreLayout();
        }
        this.benchPreLayout.stop();
        this.benchCssAndLayout.start();
    }

    public void layoutChildren() {
        this.benchLayoutChildren.start();
        double d2 = this.snappedLeftInset();
        double d3 = this.snappedTopInset();
        double d4 = this.snapSizeX(this.getWidth()) - d2 - this.snappedRightInset();
        double d5 = this.snapSizeY(this.getHeight()) - d3 - this.snappedBottomInset();
        for (Node node : this.getChildren()) {
            node.resizeRelocate(d2, d3, d4, d5);
        }
        if (this.state.isDirty()) {
            this.ensureLockedDataSets();
            this.layoutPluginsChildren();
        }
        this.benchLayoutChildren.stop();
    }

    protected void runPostLayout() {
        this.benchCssAndLayout.stop();
        if (this.state.isClean() && !this.hasLocked) {
            return;
        }
        this.benchPostLayout.start();
        this.benchDrawAxes.start();
        for (Measurable.EmptyDefault emptyDefault : this.axesList) {
            emptyDefault.drawAxis();
        }
        this.benchDrawAxes.stop();
        ((Legend)this.legend.get()).drawLegend();
        this.benchDrawCanvas.start();
        this.redrawCanvas();
        this.benchDrawCanvas.stop();
        for (Measurable.EmptyDefault emptyDefault : this.renderers) {
            emptyDefault.runPostLayout();
        }
        for (Measurable.EmptyDefault emptyDefault : this.plugins) {
            ((ChartPlugin)emptyDefault).runPostLayout();
        }
        this.clearStates();
        this.benchPostLayout.stop();
    }

    protected void ensureLockedDataSets() {
        if (!this.hasLocked) {
            this.forEachDataSet(dataSet -> this.lockedDataSets.add((DataSet)dataSet.lock().readLock()));
            this.hasLocked = true;
        }
    }

    protected void clearStates() {
        for (Measurable.EmptyDefault emptyDefault : this.getRenderers()) {
            if (!(emptyDefault instanceof EventSource)) continue;
            ((EventSource)((Object)emptyDefault)).getBitState().clear();
        }
        for (Measurable.EmptyDefault emptyDefault : this.plugins) {
            if (!(emptyDefault instanceof EventSource)) continue;
            ((EventSource)((Object)emptyDefault)).getBitState().clear();
        }
        this.state.clear();
        for (Measurable.EmptyDefault emptyDefault : this.lockedDataSets) {
            for (AxisDescription axisDescription : emptyDefault.getAxisDescriptions()) {
                axisDescription.getBitState().clear();
            }
            emptyDefault.getBitState().clear();
            emptyDefault.lock().readUnLock();
        }
        this.hasLocked = false;
        this.lockedDataSets.clear();
    }

    protected void forEachDataSet(Consumer<DataSet> consumer) {
        for (Renderer renderer : this.renderers) {
            for (DataSet dataSet : renderer.getDatasets()) {
                consumer.accept(dataSet);
            }
        }
    }

    public final ObjectProperty<Legend> legendProperty() {
        return this.legend;
    }

    @Deprecated
    public final BooleanProperty legendVisibleProperty() {
        return this.getLegend().getNode().visibleProperty();
    }

    public final void setAnimated(boolean bl2) {
        this.animated.set(bl2);
    }

    public final void setLegend(Legend legend) {
        this.legend.set((Object)legend);
    }

    public final void setLegendVisible(boolean bl2) {
        this.getLegend().getNode().setVisible(bl2);
    }

    public final void setTitle(String string) {
        this.titleProperty().set((Object)string);
    }

    public Chart setToolBarPinned(boolean bl2) {
        this.toolBarPinned.set(bl2);
        return this;
    }

    public final void setToolBarSide(Side side) {
        this.toolBarSide.set((Object)side);
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.showing;
    }

    public final StringProperty titleProperty() {
        return this.titleLabel.textProperty();
    }

    public BooleanProperty toolBarPinnedProperty() {
        return this.toolBarPinned;
    }

    public final ObjectProperty<Side> toolBarSideProperty() {
        return this.toolBarSide;
    }

    public final Point2D toPlotArea(double d2, double d3) {
        Bounds bounds = this.getCanvas().getBoundsInParent();
        return new Point2D(d2 - bounds.getMinX(), d3 - bounds.getMinY());
    }

    public abstract void updateAxisRange();

    protected void animate(Animation animation) {
        this.animator.animate(animation);
    }

    protected abstract void axesChanged(ListChangeListener.Change<? extends Axis> var1);

    protected void axesChangedLocal(ListChangeListener.Change<? extends Axis> change) {
        while (change.next()) {
            for (Axis axis : change.getRemoved()) {
                AssertUtils.notNull("to be removed axis is null", axis);
                axis.removeListener(this.state);
                this.removeAxisFromChildren(axis);
            }
            for (Axis axis : change.getAddedSubList()) {
                AssertUtils.notNull("to be added axis is null", axis);
                axis.addListener(this.state);
                this.addAxisToChildren(axis);
            }
        }
        this.fireInvalidated(ChartBits.ChartLayout, ChartBits.ChartAxes);
    }

    private boolean addAxisToChildren(Axis axis) {
        Side side = axis.getSide();
        if (side == null) {
            throw new InvalidParameterException("axis '" + axis.getName() + "' has 'null' as side being set");
        }
        ObservableList observableList = this.getAxesAndCanvasPane().getChildren();
        if (axis instanceof Node && !observableList.contains((Object)axis)) {
            this.getAxesAndCanvasPane().addSide(side, (Node)axis, new Node[0]);
            return true;
        }
        return false;
    }

    private boolean removeAxisFromChildren(Axis axis) {
        ObservableList observableList = this.getAxesAndCanvasPane().getChildren();
        if (axis instanceof Node) {
            observableList.remove((Object)((Node)axis));
            return true;
        }
        return false;
    }

    protected void datasetsChanged(ListChangeListener.Change<? extends DataSet> change) {
        FXUtils.assertJavaFxThread();
        while (change.next()) {
            for (DataSet dataSet : change.getRemoved()) {
                dataSet.removeListener(this.dataSetState);
            }
            for (DataSet dataSet : change.getAddedSubList()) {
                dataSet.addListener(this.dataSetState);
            }
        }
        this.updateDataSetIndices();
        this.fireInvalidated(ChartBits.ChartLayout, ChartBits.ChartDataSets, ChartBits.ChartLegend);
    }

    protected void updateDataSetIndices() {
        int n2 = 0;
        for (Renderer renderer : this.renderers) {
            renderer.setGlobalIndexOffset(n2);
            n2 += renderer.getDatasetNodes().size();
        }
    }

    @Deprecated
    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Chart.getClassCssMetaData();
    }

    protected void layoutPluginsChildren() {
        this.plugins.forEach(ChartPlugin::layoutChildren);
    }

    protected void pluginAdded(ChartPlugin chartPlugin) {
        chartPlugin.setChart(this);
        Group group = FXUtils.createUnmanagedGroup();
        Bindings.bindContent((List)group.getChildren(), chartPlugin.getChartChildren());
        this.pluginGroups.put(chartPlugin, group);
    }

    protected void pluginRemoved(ChartPlugin chartPlugin) {
        chartPlugin.setChart(null);
        Group group = this.pluginGroups.remove(chartPlugin);
        Bindings.unbindContent((Object)group, chartPlugin.getChartChildren());
        group.getChildren().clear();
        this.pluginsArea.getChildren().remove((Object)group);
    }

    protected void pluginsChanged(ListChangeListener.Change<? extends ChartPlugin> change) {
        while (change.next()) {
            change.getRemoved().forEach(this::pluginRemoved);
            change.getAddedSubList().forEach(this::pluginAdded);
        }
        this.updatePluginsArea();
    }

    protected abstract void redrawCanvas();

    protected void rendererChanged(ListChangeListener.Change<? extends Renderer> change) {
        FXUtils.assertJavaFxThread();
        while (change.next()) {
            for (Renderer renderer : change.getAddedSubList()) {
                for (DataSet dataSet : renderer.getDatasets()) {
                    dataSet.addListener(this.dataSetState);
                }
                renderer.getDatasets().addListener(this.datasetChangeListener);
                renderer.setChart(this);
                Iterator iterator = renderer.getNode();
                if (iterator == null || this.styleableNodes.getChildren().contains((Object)iterator)) continue;
                this.styleableNodes.getChildren().add((Object)iterator);
            }
            for (Renderer renderer : change.getRemoved()) {
                for (DataSet dataSet : renderer.getDatasets()) {
                    dataSet.removeListener(this.dataSetState);
                }
                renderer.getDatasets().removeListener(this.datasetChangeListener);
                this.styleableNodes.getChildren().remove((Object)renderer.getNode());
                renderer.setChart(null);
            }
        }
        this.updateDataSetIndices();
        change.reset();
        this.fireInvalidated(ChartBits.ChartLayout, ChartBits.ChartRenderers, ChartBits.ChartLegend);
    }

    protected final boolean shouldAnimate() {
        return this.isAnimated() && this.getScene() != null;
    }

    protected void updateLegend(List<Renderer> list) {
        Legend legend = this.getLegend();
        if (legend == null) {
            return;
        }
        legend.updateLegend(list);
    }

    protected void updatePluginsArea() {
        List list = this.plugins.stream().map(this.pluginGroups::get).collect(Collectors.toList());
        this.pluginsArea.getChildren().setAll(list);
        this.fireInvalidated(ChartBits.ChartPlugins);
    }

    private void ensureJavaFxPulse() {
        this.styleableNodes.requestLayout();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS.getCssMetaData();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CSS.getCssMetaData();
    }

    @Override
    public void setRecorder(MeasurementRecorder measurementRecorder) {
        this.benchPreLayout = measurementRecorder.newDuration("chart-runPreLayout");
        this.benchCssAndLayout = measurementRecorder.newTraceDuration("chart-cssAndLayout").ignoreMissingStart();
        this.benchLayoutChildren = measurementRecorder.newTraceDuration("chart-layoutChildren");
        this.benchPostLayout = measurementRecorder.newDuration("chart-runPostLayout");
        this.benchLockDataSets = measurementRecorder.newDebugDuration("chart-lockDataSets");
        this.benchUpdateAxisRange = measurementRecorder.newDuration("chart-updateAxisRange");
        this.benchDrawAxes = measurementRecorder.newDuration("chart-drawAxes");
        this.benchDrawCanvas = measurementRecorder.newDebugDuration("chart-drawCanvas");
    }
}

