/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.bench;

import io.fair_acc.bench.AggregateDurationMeasure;
import io.fair_acc.bench.BenchLevel;
import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.RecordingDurationMeasure;
import io.fair_acc.bench.TimeMeasure;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;

@FunctionalInterface
public interface MeasurementRecorder {
    public static final MeasurementRecorder DISABLED = (string, intSupplier) -> TimeMeasure.DISABLED;

    public TimeMeasure newTime(String var1, IntSupplier var2);

    default public TimeMeasure newTime(String string) {
        return this.newTime(string, BenchLevel.Info);
    }

    default public TimeMeasure newDebugTime(String string) {
        return this.newTime(string, BenchLevel.Debug);
    }

    default public TimeMeasure newTraceTime(String string) {
        return this.newTime(string, BenchLevel.Trace);
    }

    default public DurationMeasure newDuration(String string, IntSupplier intSupplier) {
        return this.newTime(string, intSupplier).wrap(RecordingDurationMeasure::newNanoTime, DurationMeasure.DISABLED);
    }

    default public DurationMeasure newDuration(String string) {
        return this.newDuration(string, BenchLevel.Info);
    }

    default public DurationMeasure newDebugDuration(String string) {
        return this.newDuration(string, BenchLevel.Debug);
    }

    default public DurationMeasure newTraceDuration(String string) {
        return this.newDuration(string, BenchLevel.Trace);
    }

    default public AggregateDurationMeasure newDurationSum(String string, IntSupplier intSupplier) {
        return this.newTime(string, intSupplier).wrap(RecordingDurationMeasure::newNanoTimeSum, AggregateDurationMeasure.DISABLED);
    }

    default public AggregateDurationMeasure newDebugDurationSum(String string) {
        return this.newDurationSum(string, BenchLevel.Debug);
    }

    public static MeasurementRecorder printRecorder() {
        return MeasurementRecorder.printRecorder(System.out::println);
    }

    public static MeasurementRecorder printRecorder(Consumer<String> consumer) {
        return (string, intSupplier) -> (timeUnit, l2) -> consumer.accept(String.format(Locale.ENGLISH, "%s finished in %.3f ms", string, (double)timeUnit.toMicros(l2) * 0.001));
    }

    default public MeasurementRecorder matches(String string) {
        return this.filterTag(string2 -> string2.matches(string));
    }

    default public MeasurementRecorder contains(String string) {
        return this.filterTag(string2 -> string2.contains(string));
    }

    default public MeasurementRecorder startsWith(String string) {
        return this.filterTag(string2 -> string2.startsWith(string));
    }

    default public MeasurementRecorder filterTag(Predicate<String> predicate) {
        return (string, intSupplier) -> predicate.test(string) ? this.newTime(string, intSupplier) : TimeMeasure.DISABLED;
    }

    default public MeasurementRecorder info() {
        return this.maxLevel(BenchLevel.Info);
    }

    default public MeasurementRecorder debug() {
        return this.maxLevel(BenchLevel.Debug);
    }

    default public MeasurementRecorder trace() {
        return this.maxLevel(BenchLevel.Trace);
    }

    default public MeasurementRecorder minLevel(IntSupplier intSupplier) {
        return this.filterLevel(n2 -> n2 >= intSupplier.getAsInt());
    }

    default public MeasurementRecorder atLevel(IntSupplier intSupplier) {
        return this.filterLevel(n2 -> n2 == intSupplier.getAsInt());
    }

    default public MeasurementRecorder maxLevel(IntSupplier intSupplier) {
        return this.filterLevel(n2 -> n2 <= intSupplier.getAsInt());
    }

    default public MeasurementRecorder filterLevel(IntPredicate intPredicate) {
        return (string, intSupplier) -> intPredicate.test(intSupplier.getAsInt()) ? this.newTime(string, intSupplier) : TimeMeasure.DISABLED;
    }

    default public MeasurementRecorder addPrefix(String string) {
        return (string2, intSupplier) -> this.newTime(string + "-" + string2, intSupplier);
    }

    default public MeasurementRecorder addPostfix(String string) {
        return (string2, intSupplier) -> this.newTime(string2 + "-" + string, intSupplier);
    }

    default public MeasurementRecorder removeClassPrefix() {
        return (string, intSupplier) -> this.newTime(string.substring(string.indexOf(45) + 1), intSupplier);
    }

    default public MeasurementRecorder removePostfix() {
        return (string, intSupplier) -> this.newTime(string.substring(string.lastIndexOf(45) + 1), intSupplier);
    }
}

