/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.CountersReader;

public class LocalSocketAddressStatus {
    private static final int CHANNEL_STATUS_ID_OFFSET = 0;
    private static final int LOCAL_SOCKET_ADDRESS_LENGTH_OFFSET = 4;
    private static final int LOCAL_SOCKET_ADDRESS_STRING_OFFSET = 8;
    private static final int MAX_IPV6_LENGTH = "[ffff:ffff:ffff:ffff:ffff:ffff:255.255.255.255]:65536".length();
    public static final int INITIAL_LENGTH = 8;
    public static final int LOCAL_SOCKET_ADDRESS_STATUS_TYPE_ID = 14;

    public static AtomicCounter allocate(MutableDirectBuffer mutableDirectBuffer, CountersManager countersManager, long l2, int n2, String string, int n3) {
        mutableDirectBuffer.putInt(0, n2);
        mutableDirectBuffer.putInt(4, 0);
        int n4 = 8;
        int n5 = 0;
        n5 += mutableDirectBuffer.putStringWithoutLengthAscii(8 + n5, string);
        n5 += mutableDirectBuffer.putStringWithoutLengthAscii(8 + n5, ": ");
        n5 += mutableDirectBuffer.putIntAscii(8 + n5, n2);
        n5 += mutableDirectBuffer.putStringWithoutLengthAscii(8 + n5, " ");
        AtomicCounter atomicCounter = countersManager.newCounter(n3, mutableDirectBuffer, 0, 8, mutableDirectBuffer, 8, n5);
        countersManager.setCounterRegistrationId(atomicCounter.id(), l2);
        return atomicCounter;
    }

    public static void updateBindAddress(AtomicCounter atomicCounter, String string, UnsafeBuffer unsafeBuffer) {
        if (string.length() > MAX_IPV6_LENGTH) {
            throw new IllegalArgumentException("bindAddressAndPort value too long: " + string.length() + " max: " + MAX_IPV6_LENGTH);
        }
        int n2 = CountersReader.metaDataOffset(atomicCounter.id()) + 16;
        int n3 = n2 + 8;
        int n4 = unsafeBuffer.putStringWithoutLengthAscii(n3, string);
        int n5 = n2 + 4;
        unsafeBuffer.putInt(n5, n4);
        atomicCounter.appendToLabel(string);
    }

    public static List<String> findAddresses(CountersReader countersReader, long l2, int n2) {
        if (l2 != 1L) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        AtomicBuffer atomicBuffer = countersReader.metaDataBuffer();
        int n3 = countersReader.maxCounterId();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = countersReader.getCounterState(i2);
            if (1 == n4) {
                int n5;
                int n6;
                int n7;
                if (countersReader.getCounterTypeId(i2) != 14 || n2 != atomicBuffer.getInt((n7 = (n6 = CountersReader.metaDataOffset(i2)) + 16) + 0) || 1L != countersReader.getCounterValue(i2) || (n5 = atomicBuffer.getInt(n7 + 4)) <= 0) continue;
                arrayList.add(atomicBuffer.getStringWithoutLengthAscii(n7 + 8, n5));
                continue;
            }
            if (0 == n4) break;
        }
        return arrayList;
    }

    public static String findAddress(CountersReader countersReader, long l2, int n2) {
        String string = null;
        if (l2 == 1L) {
            AtomicBuffer atomicBuffer = countersReader.metaDataBuffer();
            int n3 = countersReader.maxCounterId();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = countersReader.getCounterState(i2);
                if (1 == n4) {
                    int n5;
                    int n6;
                    if (countersReader.getCounterTypeId(i2) != 14 || n2 != atomicBuffer.getInt((n6 = (n5 = CountersReader.metaDataOffset(i2)) + 16) + 0) || 1L != countersReader.getCounterValue(i2)) continue;
                    int n7 = atomicBuffer.getInt(n6 + 4);
                    if (n7 <= 0) break;
                    string = atomicBuffer.getStringWithoutLengthAscii(n6 + 8, n7);
                    break;
                }
                if (0 == n4) break;
            }
        }
        return string;
    }

    public static int findNumberOfAddressesByRegistrationId(CountersReader countersReader, long l2) {
        int n2 = 0;
        int n3 = countersReader.maxCounterId();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = countersReader.getCounterState(i2);
            if (n4 == 1 && countersReader.getCounterTypeId(i2) == 14 && countersReader.getCounterRegistrationId(i2) == l2) {
                ++n2;
                continue;
            }
            if (0 == n4) break;
        }
        return n2;
    }
}

