/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.status;

import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.CountersReader;

public class HeartbeatTimestamp {
    public static final int HEARTBEAT_TYPE_ID = 11;
    public static final int REGISTRATION_ID_OFFSET = 0;

    public static AtomicCounter allocate(MutableDirectBuffer mutableDirectBuffer, String string, int n2, CountersManager countersManager, long l2) {
        return new AtomicCounter(countersManager.valuesBuffer(), HeartbeatTimestamp.allocateCounterId(mutableDirectBuffer, string, n2, countersManager, l2), countersManager);
    }

    public static int allocateCounterId(MutableDirectBuffer mutableDirectBuffer, String string, int n2, CountersManager countersManager, long l2) {
        mutableDirectBuffer.putLong(0, l2);
        int n3 = 8;
        int n4 = BitUtil.align(8, 4);
        int n5 = 0;
        n5 += mutableDirectBuffer.putStringWithoutLengthAscii(n4 + n5, string);
        n5 += mutableDirectBuffer.putStringWithoutLengthAscii(n4 + n5, ": ");
        n5 += mutableDirectBuffer.putLongAscii(n4 + n5, l2);
        return countersManager.allocate(n2, mutableDirectBuffer, 0, 8, mutableDirectBuffer, n4, n5);
    }

    public static int findCounterIdByRegistrationId(CountersReader countersReader, int n2, long l2) {
        AtomicBuffer atomicBuffer = countersReader.metaDataBuffer();
        int n3 = countersReader.maxCounterId();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = countersReader.getCounterState(i2);
            if (n4 == 1) {
                if (countersReader.getCounterTypeId(i2) != n2 || atomicBuffer.getLong(CountersReader.metaDataOffset(i2) + 16 + 0) != l2) continue;
                return i2;
            }
            if (0 == n4) break;
        }
        return -1;
    }

    public static boolean isActive(CountersReader countersReader, int n2, int n3, long l2) {
        AtomicBuffer atomicBuffer = countersReader.metaDataBuffer();
        int n4 = CountersReader.metaDataOffset(n2);
        return countersReader.getCounterTypeId(n2) == n3 && atomicBuffer.getLong(n4 + 16 + 0) == l2 && countersReader.getCounterState(n2) == 1;
    }
}

