/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.NativeBigEndianHeaderWriter;
import java.nio.ByteOrder;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

public class HeaderWriter {
    final long versionFlagsType;
    final long sessionId;
    final long streamId;

    HeaderWriter(long l2, long l3, long l4) {
        this.versionFlagsType = l2;
        this.sessionId = l3;
        this.streamId = l4;
    }

    HeaderWriter(UnsafeBuffer unsafeBuffer) {
        this.versionFlagsType = (long)unsafeBuffer.getInt(4) << 32;
        this.sessionId = (long)unsafeBuffer.getInt(12) << 32;
        this.streamId = (long)unsafeBuffer.getInt(16) & 0xFFFFFFFFL;
    }

    public static HeaderWriter newInstance(UnsafeBuffer unsafeBuffer) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            return new HeaderWriter(unsafeBuffer);
        }
        return new NativeBigEndianHeaderWriter(unsafeBuffer);
    }

    public void write(UnsafeBuffer unsafeBuffer, int n2, int n3, int n4) {
        unsafeBuffer.putLongOrdered(n2 + 0, this.versionFlagsType | (long)(-n3) & 0xFFFFFFFFL);
        UnsafeAccess.UNSAFE.storeFence();
        unsafeBuffer.putLong(n2 + 8, this.sessionId | (long)n2);
        unsafeBuffer.putLong(n2 + 16, this.streamId | (long)n4 << 32);
    }
}

