/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class FrameDescriptor {
    public static final int MAX_MESSAGE_LENGTH = 0x1000000;
    public static final int FRAME_ALIGNMENT = 32;
    public static final byte BEGIN_FRAG_FLAG = -128;
    public static final byte END_FRAG_FLAG = 64;
    public static final byte UNFRAGMENTED = -64;
    public static final int VERSION_OFFSET = 4;
    public static final int FLAGS_OFFSET = 5;
    public static final int TYPE_OFFSET = 6;
    public static final int TERM_OFFSET = 8;
    public static final int TERM_ID_OFFSET = 20;
    public static final int SESSION_ID_OFFSET = 12;
    public static final int PADDING_FRAME_TYPE = 0;

    public static int computeMaxMessageLength(int n2) {
        return Math.min(n2 >> 3, 0x1000000);
    }

    public static int lengthOffset(int n2) {
        return n2;
    }

    public static int versionOffset(int n2) {
        return n2 + 4;
    }

    public static int flagsOffset(int n2) {
        return n2 + 5;
    }

    public static int typeOffset(int n2) {
        return n2 + 6;
    }

    public static int termOffsetOffset(int n2) {
        return n2 + 8;
    }

    public static int termIdOffset(int n2) {
        return n2 + 20;
    }

    public static int sessionIdOffset(int n2) {
        return n2 + 12;
    }

    public static int frameVersion(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getByte(FrameDescriptor.versionOffset(n2));
    }

    public static byte frameFlags(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getByte(FrameDescriptor.flagsOffset(n2));
    }

    public static int frameType(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getShort(FrameDescriptor.typeOffset(n2), ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static boolean isPaddingFrame(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getShort(FrameDescriptor.typeOffset(n2)) == 0;
    }

    public static int frameLength(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getInt(n2, ByteOrder.LITTLE_ENDIAN);
    }

    public static int frameTermId(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getInt(FrameDescriptor.termIdOffset(n2), ByteOrder.LITTLE_ENDIAN);
    }

    public static int frameSessionId(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getInt(FrameDescriptor.sessionIdOffset(n2), ByteOrder.LITTLE_ENDIAN);
    }

    public static int frameLengthVolatile(UnsafeBuffer unsafeBuffer, int n2) {
        int n3 = unsafeBuffer.getIntVolatile(n2);
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            n3 = Integer.reverseBytes(n3);
        }
        return n3;
    }

    public static void frameLengthOrdered(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        int n4 = n3;
        if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
            n4 = Integer.reverseBytes(n3);
        }
        unsafeBuffer.putIntOrdered(n2, n4);
    }

    public static void frameType(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        unsafeBuffer.putShort(FrameDescriptor.typeOffset(n2), (short)n3, ByteOrder.LITTLE_ENDIAN);
    }

    public static void frameFlags(UnsafeBuffer unsafeBuffer, int n2, byte by2) {
        unsafeBuffer.putByte(FrameDescriptor.flagsOffset(n2), by2);
    }

    public static void frameTermOffset(UnsafeBuffer unsafeBuffer, int n2) {
        unsafeBuffer.putInt(FrameDescriptor.termOffsetOffset(n2), n2, ByteOrder.LITTLE_ENDIAN);
    }

    public static void frameTermId(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        unsafeBuffer.putInt(FrameDescriptor.termIdOffset(n2), n3, ByteOrder.LITTLE_ENDIAN);
    }

    public static void frameSessionId(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        unsafeBuffer.putInt(FrameDescriptor.sessionIdOffset(n2), n3, ByteOrder.LITTLE_ENDIAN);
    }
}

