/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import io.aeron.driver.status.SystemCounterDescriptor;
import java.util.EnumMap;
import org.agrona.CloseHelper;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public final class SystemCounters
implements AutoCloseable {
    private final EnumMap<SystemCounterDescriptor, AtomicCounter> counterByDescriptorMap = new EnumMap(SystemCounterDescriptor.class);

    public SystemCounters(CountersManager countersManager) {
        for (SystemCounterDescriptor systemCounterDescriptor : SystemCounterDescriptor.values()) {
            this.counterByDescriptorMap.put(systemCounterDescriptor, systemCounterDescriptor.newCounter(countersManager));
        }
    }

    public AtomicCounter get(SystemCounterDescriptor systemCounterDescriptor) {
        return this.counterByDescriptorMap.get((Object)systemCounterDescriptor);
    }

    @Override
    public void close() {
        CloseHelper.closeAll(this.counterByDescriptorMap.values());
    }

    public String toString() {
        return "SystemCounters{counterByDescriptorMap=" + this.counterByDescriptorMap + '}';
    }
}

