/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.NetworkInterfaceShim;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import org.agrona.BufferUtil;

public final class NetworkUtil {
    public static NetworkInterface[] filterBySubnet(InetAddress inetAddress, int n2) throws SocketException {
        return NetworkUtil.filterBySubnet(NetworkInterfaceShim.DEFAULT, inetAddress, n2);
    }

    public static ByteBuffer allocateDirectAlignedAndPadded(int n2, int n3) {
        ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned(n2 + n3, n3);
        byteBuffer.limit(byteBuffer.limit() - n3);
        return byteBuffer.slice();
    }

    public static String formatAddressAndPort(InetAddress inetAddress, int n2) {
        if (inetAddress instanceof Inet6Address) {
            return "[" + inetAddress.getHostAddress() + "]:" + n2;
        }
        return inetAddress.getHostAddress() + ":" + n2;
    }

    public static ProtocolFamily getProtocolFamily(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return StandardProtocolFamily.INET;
        }
        if (inetAddress instanceof Inet6Address) {
            return StandardProtocolFamily.INET6;
        }
        throw new IllegalStateException("Unknown ProtocolFamily");
    }

    public static InetAddress findFirstMatchingLocalAddress(InetAddress inetAddress) throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                if (!NetworkUtil.isMatchWithPrefix(inetAddress.getAddress(), interfaceAddress.getAddress().getAddress(), interfaceAddress.getNetworkPrefixLength())) continue;
                return interfaceAddress.getAddress();
            }
        }
        return null;
    }

    static NetworkInterface[] filterBySubnet(NetworkInterfaceShim networkInterfaceShim, InetAddress inetAddress, int n2) throws SocketException {
        Object object;
        ArrayList<FilterResult> arrayList = new ArrayList<FilterResult>();
        byte[] byArray = inetAddress.getAddress();
        Enumeration<NetworkInterface> enumeration = networkInterfaceShim.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            object = NetworkUtil.findAddressOnInterface(networkInterfaceShim, networkInterface, byArray, n2);
            if (null == object) continue;
            arrayList.add(new FilterResult((InterfaceAddress)object, networkInterface, networkInterfaceShim.isLoopback(networkInterface)));
        }
        Collections.sort(arrayList);
        int n3 = arrayList.size();
        object = new NetworkInterface[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            object[i2] = ((FilterResult)arrayList.get(i2)).networkInterface;
        }
        return object;
    }

    static InetAddress findAddressOnInterface(NetworkInterface networkInterface, InetAddress inetAddress, int n2) {
        InterfaceAddress interfaceAddress = NetworkUtil.findAddressOnInterface(NetworkInterfaceShim.DEFAULT, networkInterface, inetAddress.getAddress(), n2);
        return null == interfaceAddress ? null : interfaceAddress.getAddress();
    }

    static InterfaceAddress findAddressOnInterface(NetworkInterfaceShim networkInterfaceShim, NetworkInterface networkInterface, byte[] byArray, int n2) {
        for (InterfaceAddress interfaceAddress : networkInterfaceShim.getInterfaceAddresses(networkInterface)) {
            InetAddress inetAddress;
            if (null == interfaceAddress || null == (inetAddress = interfaceAddress.getAddress()) || !NetworkUtil.isMatchWithPrefix(inetAddress.getAddress(), byArray, n2)) continue;
            return interfaceAddress;
        }
        return null;
    }

    public static boolean isMatchWithPrefix(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        if (byArray.length == 4) {
            int n3 = NetworkUtil.prefixLengthToIpV4Mask(n2);
            return (NetworkUtil.toInt(byArray) & n3) == (NetworkUtil.toInt(byArray2) & n3);
        }
        if (byArray.length == 16) {
            long l2 = NetworkUtil.prefixLengthToIpV6Mask(Math.min(n2, 64));
            long l3 = NetworkUtil.prefixLengthToIpV6Mask(Math.max(n2 - 64, 0));
            return (l2 & NetworkUtil.toLong(byArray, 0)) == (l2 & NetworkUtil.toLong(byArray2, 0)) && (l3 & NetworkUtil.toLong(byArray, 8)) == (l3 & NetworkUtil.toLong(byArray2, 8));
        }
        throw new IllegalArgumentException("how many bytes does an IP address have again?");
    }

    private static int prefixLengthToIpV4Mask(int n2) {
        return 0 == n2 ? 0 : -(1 << 32 - n2);
    }

    private static long prefixLengthToIpV6Mask(int n2) {
        return 0 == n2 ? 0L : -(1L << 64 - n2);
    }

    private static int toInt(byte[] byArray) {
        return (byArray[3] & 0xFF) + ((byArray[2] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 16) + (byArray[0] << 24);
    }

    static long toLong(byte[] byArray, int n2) {
        return ((long)byArray[n2 + 7] & 0xFFL) + (((long)byArray[n2 + 6] & 0xFFL) << 8) + (((long)byArray[n2 + 5] & 0xFFL) << 16) + (((long)byArray[n2 + 4] & 0xFFL) << 24) + (((long)byArray[n2 + 3] & 0xFFL) << 32) + (((long)byArray[n2 + 2] & 0xFFL) << 40) + (((long)byArray[n2 + 1] & 0xFFL) << 48) + ((long)byArray[n2] << 56);
    }

    static class FilterResult
    implements Comparable<FilterResult> {
        private final InterfaceAddress interfaceAddress;
        private final NetworkInterface networkInterface;
        private final boolean isLoopback;

        FilterResult(InterfaceAddress interfaceAddress, NetworkInterface networkInterface, boolean bl2) {
            this.interfaceAddress = interfaceAddress;
            this.networkInterface = networkInterface;
            this.isLoopback = bl2;
        }

        @Override
        public int compareTo(FilterResult filterResult) {
            if (this.isLoopback == filterResult.isLoopback) {
                return -Integer.compare(this.interfaceAddress.getNetworkPrefixLength(), filterResult.interfaceAddress.getNetworkPrefixLength());
            }
            return Boolean.compare(this.isLoopback, filterResult.isLoopback);
        }

        public boolean equals(Object object) {
            return object instanceof FilterResult && this.compareTo((FilterResult)object) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.interfaceAddress, this.networkInterface, this.isLoopback);
        }
    }
}

