/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.agrona.AsciiEncoding;
import org.agrona.Strings;

final class InterfaceSearchAddress {
    private static final InterfaceSearchAddress WILDCARD = new InterfaceSearchAddress(new InetSocketAddress(0), 0);
    private final InetSocketAddress address;
    private final int subnetPrefix;

    InterfaceSearchAddress(InetSocketAddress inetSocketAddress, int n2) {
        this.address = inetSocketAddress;
        this.subnetPrefix = n2;
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    InetAddress getInetAddress() {
        return this.address.getAddress();
    }

    int getSubnetPrefix() {
        return this.subnetPrefix;
    }

    int getPort() {
        return this.address.getPort();
    }

    static InterfaceSearchAddress wildcard() {
        return WILDCARD;
    }

    static InterfaceSearchAddress parse(String string) throws UnknownHostException {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("search address string is null or empty");
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = string.length();
        block5: for (int i2 = 0; i2 < n5; ++i2) {
            switch (string.charAt(i2)) {
                case '/': {
                    n2 = i2;
                    continue block5;
                }
                case ':': {
                    n3 = i2;
                    continue block5;
                }
                case ']': {
                    n4 = i2;
                }
            }
        }
        String string2 = InterfaceSearchAddress.getAddress(string, n2, n3, n4);
        InetAddress inetAddress = InetAddress.getByName(string2);
        int n6 = InterfaceSearchAddress.getPort(string, n2, n3, n4);
        int n7 = inetAddress.getAddress().length * 8;
        int n8 = InterfaceSearchAddress.getSubnet(string, n2, n7);
        return new InterfaceSearchAddress(new InetSocketAddress(inetAddress, n6), n8);
    }

    private static int getSubnet(String string, int n2, int n3) {
        if (n2 < 0) {
            return n3;
        }
        if (string.length() - 1 == n2) {
            throw new IllegalArgumentException("invalid subnet: " + string);
        }
        int n4 = n2 + 1;
        return AsciiEncoding.parseIntAscii(string, n4, string.length() - n4);
    }

    private static int getPort(String string, int n2, int n3, int n4) {
        if (n3 < 0 || n4 > n3) {
            return 0;
        }
        if (string.length() - 1 == n3) {
            throw new IllegalArgumentException("invalid port: " + string);
        }
        int n5 = n3 + 1;
        int n6 = n2 > 0 ? n2 : string.length();
        return AsciiEncoding.parseIntAscii(string, n5, n6 - n5);
    }

    private static String getAddress(String string, int n2, int n3, int n4) {
        int n5 = string.length();
        if (n2 >= 0) {
            n5 = n2;
        }
        if (n3 >= 0 && n3 > n4) {
            n5 = n3;
        }
        return string.substring(0, n5);
    }
}

