/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class DataTransportPoller
extends UdpTransportPoller {
    private static final ChannelAndTransport[] EMPTY_TRANSPORTS = new ChannelAndTransport[0];
    private final ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned(65504, 64);
    private final UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
    private final DataHeaderFlyweight dataMessage = new DataHeaderFlyweight(this.unsafeBuffer);
    private final SetupFlyweight setupMessage = new SetupFlyweight(this.unsafeBuffer);
    private final RttMeasurementFlyweight rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    private ChannelAndTransport[] channelAndTransports = EMPTY_TRANSPORTS;

    public DataTransportPoller(ErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Override
    public void close() {
        for (ChannelAndTransport channelAndTransport : this.channelAndTransports) {
            ReceiveChannelEndpoint receiveChannelEndpoint = channelAndTransport.channelEndpoint;
            receiveChannelEndpoint.closeMultiRcvDestinationTransports(this);
            CloseHelper.close(this.errorHandler, receiveChannelEndpoint);
        }
        super.close();
    }

    @Override
    public int pollTransports() {
        int n2 = 0;
        try {
            if (this.channelAndTransports.length <= ITERATION_THRESHOLD) {
                for (ChannelAndTransport channelAndTransport : this.channelAndTransports) {
                    n2 += this.poll(channelAndTransport);
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] selectionKeyArray = this.selectedKeySet.keys();
                int n3 = this.selectedKeySet.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    n2 += this.poll((ChannelAndTransport)selectionKeyArray[i2].attachment());
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return n2;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport udpChannelTransport) {
        return this.registerForRead((ReceiveChannelEndpoint)udpChannelTransport, udpChannelTransport, 0);
    }

    public SelectionKey registerForRead(ReceiveChannelEndpoint receiveChannelEndpoint, UdpChannelTransport udpChannelTransport, int n2) {
        SelectionKey selectionKey = null;
        try {
            ChannelAndTransport channelAndTransport = new ChannelAndTransport(receiveChannelEndpoint, udpChannelTransport, n2);
            selectionKey = udpChannelTransport.receiveDatagramChannel().register(this.selector, 1, channelAndTransport);
            this.channelAndTransports = ArrayUtil.add(this.channelAndTransports, channelAndTransport);
        }
        catch (ClosedChannelException closedChannelException) {
            LangUtil.rethrowUnchecked(closedChannelException);
        }
        return selectionKey;
    }

    @Override
    public void cancelRead(UdpChannelTransport udpChannelTransport) {
        this.cancelRead((ReceiveChannelEndpoint)udpChannelTransport, udpChannelTransport);
    }

    public void cancelRead(ReceiveChannelEndpoint receiveChannelEndpoint, UdpChannelTransport udpChannelTransport) {
        ChannelAndTransport[] channelAndTransportArray = this.channelAndTransports;
        int n2 = -1;
        int n3 = channelAndTransportArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (receiveChannelEndpoint != channelAndTransportArray[i2].channelEndpoint || udpChannelTransport != channelAndTransportArray[i2].transport) continue;
            n2 = i2;
            break;
        }
        if (n2 != -1) {
            this.channelAndTransports = 1 == channelAndTransportArray.length ? EMPTY_TRANSPORTS : ArrayUtil.remove(channelAndTransportArray, n2);
        }
    }

    public void checkForReResolutions(long l2, DriverConductorProxy driverConductorProxy) {
        for (ChannelAndTransport channelAndTransport : this.channelAndTransports) {
            channelAndTransport.channelEndpoint.checkForReResolution(l2, driverConductorProxy);
        }
    }

    private int poll(ChannelAndTransport channelAndTransport) {
        int n2;
        ReceiveChannelEndpoint receiveChannelEndpoint;
        int n3 = 0;
        InetSocketAddress inetSocketAddress = channelAndTransport.transport.receive(this.byteBuffer);
        if (null != inetSocketAddress && (receiveChannelEndpoint = channelAndTransport.channelEndpoint).isValidFrame(this.unsafeBuffer, n2 = this.byteBuffer.position())) {
            receiveChannelEndpoint.receiveHook(this.unsafeBuffer, n2, inetSocketAddress);
            int n4 = FrameDescriptor.frameType(this.unsafeBuffer, 0);
            if (1 == n4 || 0 == n4) {
                n3 = receiveChannelEndpoint.onDataPacket(this.dataMessage, this.unsafeBuffer, n2, inetSocketAddress, channelAndTransport.transportIndex);
            } else if (5 == n4) {
                receiveChannelEndpoint.onSetupMessage(this.setupMessage, this.unsafeBuffer, n2, inetSocketAddress, channelAndTransport.transportIndex);
            } else if (6 == n4) {
                receiveChannelEndpoint.onRttMeasurement(this.rttMeasurement, this.unsafeBuffer, n2, inetSocketAddress, channelAndTransport.transportIndex);
            }
        }
        return n3;
    }

    public String toString() {
        return "DataTransportPoller{}";
    }

    static class ChannelAndTransport {
        final ReceiveChannelEndpoint channelEndpoint;
        final UdpChannelTransport transport;
        final int transportIndex;

        ChannelAndTransport(ReceiveChannelEndpoint receiveChannelEndpoint, UdpChannelTransport udpChannelTransport, int n2) {
            this.channelEndpoint = receiveChannelEndpoint;
            this.transport = udpChannelTransport;
            this.transportIndex = n2;
        }
    }
}

