/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.DebugChannelEndpointConfiguration;
import io.aeron.driver.ext.LossGenerator;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class DebugSendChannelEndpoint
extends SendChannelEndpoint {
    private final LossGenerator dataLossGenerator;
    private final LossGenerator controlLossGenerator;
    private final UnsafeBuffer dataBuffer = new UnsafeBuffer();

    public DebugSendChannelEndpoint(UdpChannel udpChannel, AtomicCounter atomicCounter, MediaDriver.Context context) {
        this(udpChannel, atomicCounter, context, DebugChannelEndpointConfiguration.sendDataLossGeneratorSupplier(), DebugChannelEndpointConfiguration.sendControlLossGeneratorSupplier());
    }

    public DebugSendChannelEndpoint(UdpChannel udpChannel, AtomicCounter atomicCounter, MediaDriver.Context context, LossGenerator lossGenerator, LossGenerator lossGenerator2) {
        super(udpChannel, atomicCounter, context);
        this.dataLossGenerator = lossGenerator;
        this.controlLossGenerator = lossGenerator2;
    }

    @Override
    public int send(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.dataBuffer.wrap(byteBuffer, byteBuffer.position(), n2);
        if (!this.dataLossGenerator.shouldDropFrame(this.connectAddress, this.dataBuffer, n2)) {
            n2 = super.send(byteBuffer);
        }
        return n2;
    }

    @Override
    public void onStatusMessage(StatusMessageFlyweight statusMessageFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(inetSocketAddress, statusMessageFlyweight, statusMessageFlyweight.frameLength())) {
            super.onStatusMessage(statusMessageFlyweight, unsafeBuffer, n2, inetSocketAddress);
        }
    }

    @Override
    public void onNakMessage(NakFlyweight nakFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(inetSocketAddress, nakFlyweight, nakFlyweight.frameLength())) {
            super.onNakMessage(nakFlyweight, unsafeBuffer, n2, inetSocketAddress);
        }
    }

    @Override
    public void onRttMeasurement(RttMeasurementFlyweight rttMeasurementFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(inetSocketAddress, rttMeasurementFlyweight, rttMeasurementFlyweight.frameLength())) {
            super.onRttMeasurement(rttMeasurementFlyweight, unsafeBuffer, n2, inetSocketAddress);
        }
    }
}

