/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.CubicCongestionControlConfiguration;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.PerImageIndicator;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class CubicCongestionControl
implements CongestionControl {
    public static final String CC_PARAM_VALUE = "cubic";
    private static final long SECOND_IN_NS = TimeUnit.SECONDS.toNanos(1L);
    private static final int INITCWND = 10;
    private static final int RTT_TIMEOUT_MULTIPLE = 4;
    private static final double C = 0.4;
    private static final double B = 0.2;
    private final int mtu;
    private final int maxCwnd;
    private final int initialWindowLength;
    private final int maxWindowLength;
    private double k;
    private int w_max;
    private int windowLength;
    private int cwnd;
    private long lastUpdateTimestampNs;
    private long lastLossTimestampNs;
    private long lastRttTimestampNs = 0L;
    private long rttNs;
    private long rttTimeoutNs;
    private final long windowUpdateTimeoutNs;
    private final ErrorHandler errorHandler;
    private final AtomicCounter rttIndicator;
    private final AtomicCounter windowIndicator;

    public CubicCongestionControl(long l2, UdpChannel udpChannel, int n2, int n3, int n4, int n5, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, NanoClock nanoClock, MediaDriver.Context context, CountersManager countersManager) {
        try {
            this.errorHandler = context.errorHandler();
            this.mtu = n5;
            int n6 = 0 != udpChannel.receiverWindowLength() ? udpChannel.receiverWindowLength() : context.initialWindowLength();
            this.maxWindowLength = Configuration.receiverWindowLength(n4, n6);
            this.maxCwnd = this.maxWindowLength / this.mtu;
            this.cwnd = Math.min(10, this.maxCwnd);
            this.initialWindowLength = this.cwnd * this.mtu;
            this.w_max = this.maxCwnd;
            this.k = StrictMath.cbrt((double)this.w_max * 0.2 / 0.4);
            this.windowUpdateTimeoutNs = this.rttNs = CubicCongestionControlConfiguration.INITIAL_RTT_NS;
            this.rttTimeoutNs = this.rttNs * 4L;
            this.rttIndicator = PerImageIndicator.allocate(context.tempBuffer(), "rcv-cc-cubic-rtt", countersManager, l2, n3, n2, udpChannel.originalUriString());
            this.windowIndicator = PerImageIndicator.allocate(context.tempBuffer(), "rcv-cc-cubic-wnd", countersManager, l2, n3, n2, udpChannel.originalUriString());
            this.windowLength = this.initialWindowLength;
            this.rttIndicator.setOrdered(0L);
            this.windowIndicator.setOrdered(this.initialWindowLength);
            this.lastUpdateTimestampNs = this.lastLossTimestampNs = nanoClock.nanoTime();
        }
        catch (Exception exception) {
            this.close();
            throw exception;
        }
    }

    @Override
    public void close() {
        CloseHelper.close(this.errorHandler, this.rttIndicator);
        CloseHelper.close(this.errorHandler, this.windowIndicator);
    }

    @Override
    public boolean shouldMeasureRtt(long l2) {
        return CubicCongestionControlConfiguration.MEASURE_RTT && this.lastRttTimestampNs + this.rttTimeoutNs - l2 < 0L;
    }

    @Override
    public void onRttMeasurementSent(long l2) {
        this.lastRttTimestampNs = l2;
    }

    @Override
    public void onRttMeasurement(long l2, long l3, InetSocketAddress inetSocketAddress) {
        this.lastRttTimestampNs = l2;
        this.rttNs = l3;
        this.rttIndicator.setOrdered(l3);
        this.rttTimeoutNs = Math.max(l3, CubicCongestionControlConfiguration.INITIAL_RTT_NS) * 4L;
    }

    @Override
    public long onTrackRebuild(long l2, long l3, long l4, long l5, long l6, long l7, boolean bl2) {
        boolean bl3 = false;
        if (bl2) {
            bl3 = true;
            this.w_max = this.cwnd;
            this.k = StrictMath.cbrt((double)this.w_max * 0.2 / 0.4);
            this.cwnd = Math.max(1, (int)((double)this.cwnd * 0.8));
            this.windowLength = this.cwnd * this.mtu;
            this.windowIndicator.setOrdered(this.windowLength);
            this.lastLossTimestampNs = l2;
        } else if (this.cwnd < this.maxCwnd && this.lastUpdateTimestampNs + this.windowUpdateTimeoutNs - l2 < 0L) {
            int n2;
            double d2 = (double)(l2 - this.lastLossTimestampNs) / (double)SECOND_IN_NS;
            double d3 = d2 - this.k;
            double d4 = 0.4 * d3 * d3 * d3;
            this.cwnd = Math.min(this.maxCwnd, this.w_max + (int)d4);
            if (CubicCongestionControlConfiguration.TCP_MODE && this.cwnd < this.w_max) {
                double d5 = (double)this.rttNs / (double)SECOND_IN_NS;
                double d6 = (double)this.w_max * 0.8 + 0.33333333333333337 * (d2 / d5);
                this.cwnd = Math.max(this.cwnd, (int)d6);
            }
            if ((n2 = this.cwnd * this.mtu) != this.windowLength) {
                this.windowLength = n2;
                this.windowIndicator.setOrdered(n2);
            }
            this.lastUpdateTimestampNs = l2;
        } else if (1 == this.cwnd && l3 > l4) {
            bl3 = true;
        }
        return CongestionControl.packOutcome(this.windowLength, bl3);
    }

    @Override
    public int initialWindowLength() {
        return this.initialWindowLength;
    }

    @Override
    public int maxWindowLength() {
        return this.maxWindowLength;
    }

    int maxCongestionWindow() {
        return this.maxCwnd;
    }
}

